/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.ColorConverter;
import com.mathworks.hg.print.Graphics2DDecorator;
import com.mathworks.hg.print.ImageUtils;
import com.mathworks.hg.uij.SolidPaint;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;

public class ColorConvertingGraphics2D
extends Graphics2DDecorator {
    private Color fConvertedBackground = null;
    private Paint fConvertedPaint = null;
    private ColorConverter fColorConverter = new NullColorConverter();

    public ColorConvertingGraphics2D(Graphics graphics, ColorConverter colorConverter) {
        super(graphics);
        this.fColorConverter = colorConverter;
    }

    public ColorConvertingGraphics2D(Graphics graphics) {
        this(graphics, new NullColorConverter());
    }

    @Override
    protected Graphics doCreateNew(Graphics graphics) {
        ColorConvertingGraphics2D colorConvertingGraphics2D = new ColorConvertingGraphics2D(graphics);
        colorConvertingGraphics2D.fColorConverter = this.fColorConverter;
        colorConvertingGraphics2D.fConvertedBackground = this.fConvertedBackground;
        colorConvertingGraphics2D.fConvertedPaint = this.fConvertedPaint;
        return colorConvertingGraphics2D;
    }

    @Override
    public void setPaint(Paint paint) {
        if (this.notEqualPaints(paint, this.getPaint())) {
            this.fConvertedPaint = null;
            super.setPaint(paint);
        }
    }

    @Override
    public void setColor(Color color) {
        if (this.notEqualPaints(color, this.getPaint())) {
            this.fConvertedPaint = null;
            super.setColor(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (!color.equals(this.getBackground())) {
            this.fConvertedBackground = null;
            super.setBackground(color);
        }
    }

    private boolean notEqualPaints(Paint paint, Paint paint2) {
        if (paint instanceof Color && paint2 instanceof Color) {
            Color color = (Color)paint;
            Color color2 = (Color)paint2;
            return color != color2 || !Arrays.equals(color.getComponents(null), color2.getComponents(null)) || color.getColorSpace() != color2.getColorSpace() || color.getTransparency() != color2.getTransparency();
        }
        return paint != paint2;
    }

    @Override
    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().draw3DRect(n, n2, n3, n4, bl);
        super.setPaint(paint);
    }

    @Override
    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().fill3DRect(n, n2, n3, n4, bl);
        super.setPaint(paint);
    }

    @Override
    public void draw(Shape shape) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().draw(shape);
        super.setPaint(paint);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawLine(n, n2, n3, n4);
        super.setPaint(paint);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().fillRect(n, n2, n3, n4);
        super.setPaint(paint);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawRect(n, n2, n3, n4);
        super.setPaint(paint);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawRoundRect(n, n2, n3, n4, n5, n6);
        super.setPaint(paint);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().fillRoundRect(n, n2, n3, n4, n5, n6);
        super.setPaint(paint);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawOval(n, n2, n3, n4);
        super.setPaint(paint);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().fillOval(n, n2, n3, n4);
        super.setPaint(paint);
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawArc(n, n2, n3, n4, n5, n6);
        super.setPaint(paint);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().fillArc(n, n2, n3, n4, n5, n6);
        super.setPaint(paint);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawPolyline(nArray, nArray2, n);
        super.setPaint(paint);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawPolygon(nArray, nArray2, n);
        super.setPaint(paint);
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawPolygon(polygon);
        super.setPaint(paint);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().fillPolygon(nArray, nArray2, n);
        super.setPaint(paint);
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().fillPolygon(polygon);
        super.setPaint(paint);
    }

    @Override
    public void fill(Shape shape) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().fill(shape);
        super.setPaint(paint);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        Color color = this.setConvertedBackground();
        this.get2DContained().clearRect(n, n2, n3, n4);
        super.setBackground(color);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawString(string, f, f2);
        super.setPaint(paint);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        Paint paint = this.setConvertedPaint();
        super.drawString(string, n, n2);
        super.setPaint(paint);
    }

    @Override
    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawChars(cArray, n, n2, n3, n4);
        super.setPaint(paint);
    }

    @Override
    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawBytes(byArray, n, n2, n3, n4);
        super.setPaint(paint);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawString(attributedCharacterIterator, n, n2);
        super.setPaint(paint);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawString(attributedCharacterIterator, f, f2);
        super.setPaint(paint);
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        Paint paint = this.setConvertedPaint();
        this.get2DContained().drawGlyphVector(glyphVector, f, f2);
        super.setPaint(paint);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return super.drawImage(this.convertImage(image, imageObserver), affineTransform, imageObserver);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        super.drawImage(this.convertImage(bufferedImage), bufferedImageOp, n, n2);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        super.drawRenderedImage(this.convertImage(renderedImage), affineTransform);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        RenderedImage renderedImage = renderableImage.createDefaultRendering();
        this.drawRenderedImage(renderedImage, affineTransform);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return super.drawImage(this.convertImage(image, imageObserver), n, n2, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return super.drawImage(this.convertImage(image, imageObserver), n, n2, n3, n4, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return super.drawImage(this.convertImage(image, imageObserver), n, n2, this.convertColor(color), imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return super.drawImage(this.convertImage(image, imageObserver), n, n2, n3, n4, this.convertColor(color), imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return super.drawImage(this.convertImage(image, imageObserver), n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return super.drawImage(this.convertImage(image, imageObserver), n, n2, n3, n4, n5, n6, n7, n8, this.convertColor(color), imageObserver);
    }

    private Paint setConvertedPaint() {
        Paint paint = this.getPaint();
        if (this.fConvertedPaint == null) {
            this.fConvertedPaint = this.convertPaint(paint);
        }
        super.setPaint(this.fConvertedPaint);
        return paint;
    }

    private Color setConvertedBackground() {
        Color color = this.getBackground();
        if (this.fConvertedBackground == null) {
            this.fConvertedBackground = this.convertColor(color);
        }
        super.setBackground(this.fConvertedBackground);
        return color;
    }

    private Paint convertPaint(Paint paint) {
        Paint paint2 = paint instanceof Color ? this.convertColor((Color)paint) : (paint instanceof GradientPaint ? this.convertPaint((GradientPaint)paint) : (paint instanceof LinearGradientPaint ? this.convertPaint((LinearGradientPaint)paint) : (paint instanceof RadialGradientPaint ? this.convertPaint((RadialGradientPaint)paint) : (paint instanceof TexturePaint ? this.convertPaint((TexturePaint)paint) : (paint instanceof SolidPaint ? this.convertPaint((SolidPaint)paint) : this.fColorConverter.convertPaint(this, paint))))));
        return paint2;
    }

    private Color convertColor(Color color) {
        return this.fColorConverter.convert(this, color);
    }

    private Color[] convertColors(Color[] colorArray) {
        Color[] colorArray2 = new Color[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray2[i] = this.fColorConverter.convert(this, colorArray[i]);
        }
        return colorArray;
    }

    private Image convertImage(Image image, ImageObserver imageObserver) {
        BufferedImage bufferedImage = ImageUtils.renderImage(image, imageObserver);
        return this.fColorConverter.convertImage(this, bufferedImage);
    }

    private BufferedImage convertImage(BufferedImage bufferedImage) {
        return this.fColorConverter.convertImage(this, bufferedImage);
    }

    private BufferedImage convertImage(RenderedImage renderedImage) {
        BufferedImage bufferedImage;
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            ColorModel colorModel = renderedImage.getColorModel();
            Raster raster = renderedImage.getData();
            boolean bl = colorModel.isAlphaPremultiplied();
            bufferedImage = new BufferedImage(colorModel, raster.createCompatibleWritableRaster(), bl, null);
            bufferedImage.setData(raster);
        }
        return this.fColorConverter.convertImage(this, bufferedImage);
    }

    private SolidPaint convertPaint(SolidPaint solidPaint) {
        return new SolidPaint(this.convertColor(solidPaint.getColor()));
    }

    private GradientPaint convertPaint(GradientPaint gradientPaint) {
        return new GradientPaint(gradientPaint.getPoint1(), this.convertColor(gradientPaint.getColor1()), gradientPaint.getPoint2(), this.convertColor(gradientPaint.getColor2()), gradientPaint.isCyclic());
    }

    private LinearGradientPaint convertPaint(LinearGradientPaint linearGradientPaint) {
        return new LinearGradientPaint(linearGradientPaint.getStartPoint(), linearGradientPaint.getEndPoint(), linearGradientPaint.getFractions(), this.convertColors(linearGradientPaint.getColors()), linearGradientPaint.getCycleMethod(), linearGradientPaint.getColorSpace(), linearGradientPaint.getTransform());
    }

    private RadialGradientPaint convertPaint(RadialGradientPaint radialGradientPaint) {
        return new RadialGradientPaint(radialGradientPaint.getCenterPoint(), radialGradientPaint.getRadius(), radialGradientPaint.getFocusPoint(), radialGradientPaint.getFractions(), this.convertColors(radialGradientPaint.getColors()), radialGradientPaint.getCycleMethod(), radialGradientPaint.getColorSpace(), radialGradientPaint.getTransform());
    }

    private TexturePaint convertPaint(TexturePaint texturePaint) {
        return new TexturePaint(this.convertImage(texturePaint.getImage()), texturePaint.getAnchorRect());
    }

    public static class NullColorConverter
    implements ColorConverter {
        @Override
        public Color convert(Graphics2D graphics2D, Color color) {
            return color;
        }

        @Override
        public BufferedImage convertImage(Graphics2D graphics2D, BufferedImage bufferedImage) {
            return bufferedImage;
        }

        @Override
        public Paint convertPaint(Graphics2D graphics2D, Paint paint) {
            return paint;
        }
    }
}

