/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.FOPPSVectorStrategy;
import com.mathworks.hg.print.MWPSGraphics2D;
import com.mathworks.hg.util.MPrintJob;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.java2d.ps.AbstractPSDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;

public class FOPEPSVectorStrategy
extends FOPPSVectorStrategy {
    public FOPEPSVectorStrategy(int n) {
        super(n);
    }

    @Override
    protected AbstractPSDocumentGraphics2D createGraphics(boolean bl, int n, boolean bl2) {
        return new MWEPSDocumentGraphics2D(bl, n, bl2);
    }

    @Override
    protected Dimension getDocumentSize(MPrintJob mPrintJob) {
        Rectangle2D rectangle2D = mPrintJob.getPaperPositionInPoints();
        return new Dimension((int)Math.round(rectangle2D.getWidth()), (int)Math.round(rectangle2D.getHeight()));
    }

    @Override
    protected Point2D getOutputOrigin(MPrintJob mPrintJob) {
        return new Point(0, 0);
    }

    private class MWEPSDocumentGraphics2D
    extends EPSDocumentGraphics2D {
        private int fLanguageLevel;
        private boolean fTightBBox;

        public MWEPSDocumentGraphics2D(boolean bl, int n, boolean bl2) {
            super(bl);
            this.fLanguageLevel = 3;
            this.fTightBBox = true;
            this.fLanguageLevel = n;
            this.fTightBBox = bl2;
        }

        public void setupDocument(OutputStream outputStream, int n, int n2) throws IOException {
            this.width = n;
            this.height = n2;
            this.pagecount = 0;
            this.pagePending = false;
            if (this.fTightBBox) {
                this.setPSGenerator(new FOPPSVectorStrategy.BBoxPSGenerator(FOPEPSVectorStrategy.this, outputStream));
            } else {
                this.setPSGenerator(new FOPPSVectorStrategy.CustomPSGenerator(FOPEPSVectorStrategy.this, outputStream));
            }
            this.writeFileHeader();
        }

        public void setPSGenerator(PSGenerator pSGenerator) {
            pSGenerator.setPSLevel(this.fLanguageLevel);
            super.setPSGenerator(pSGenerator);
        }

        public Graphics create() {
            Graphics graphics = super.create();
            return MWPSGraphics2D.createFromGraphics(graphics, (AbstractPSDocumentGraphics2D)this);
        }
    }
}

