/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.FontSubstitutionMap;
import com.mathworks.hg.print.Graphics2DDecorator;
import com.mathworks.hg.print.MWTextHandler;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;

public class TextRenderingGraphics2D
extends Graphics2DDecorator {
    private boolean fInPossibleRecursion = false;

    public TextRenderingGraphics2D(Graphics graphics) {
        super(graphics);
    }

    @Override
    protected Graphics doCreateNew(Graphics graphics) {
        return new TextRenderingGraphics2D(graphics);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(FontSubstitutionMap.getFontSubstitution(font));
    }

    @Override
    public void drawString(String string, float f, float f2) {
        if (MWTextHandler.stringHasUnicodeChars(string)) {
            Font font = this.getFont();
            FontRenderContext fontRenderContext = this.getFontRenderContext();
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
            Shape shape = glyphVector.getOutline(f, f2);
            this.fill(shape);
        } else {
            super.drawString(string, f, f2);
        }
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        if (this.fInPossibleRecursion) {
            System.err.println("Called itself: drawString(AttributedCharacterIterator)");
        } else {
            this.fInPossibleRecursion = true;
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
            textLayout.draw(this, f, f2);
            this.fInPossibleRecursion = false;
        }
    }
}

