/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.Graphics2DDecorator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public class TextureLimitingGraphics2D
extends Graphics2DDecorator {
    private int fSizeLimit = (int)Math.pow(2.0, 10.0);

    public TextureLimitingGraphics2D(Graphics graphics) {
        super(graphics);
    }

    public TextureLimitingGraphics2D(Graphics graphics, int n) {
        this(graphics);
        this.setLimit(n);
    }

    @Override
    protected Graphics doCreateNew(Graphics graphics) {
        TextureLimitingGraphics2D textureLimitingGraphics2D = new TextureLimitingGraphics2D(graphics);
        textureLimitingGraphics2D.setLimit(this.getLimit());
        return textureLimitingGraphics2D;
    }

    public void setLimit(int n) {
        this.fSizeLimit = n;
    }

    public int getLimit() {
        return this.fSizeLimit;
    }

    @Override
    public void fillRect(final int n, final int n2, final int n3, final int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.doShapeFill(rectangle, new Runnable(){

            @Override
            public void run() {
                TextureLimitingGraphics2D.this.get2DContained().fillRect(n, n2, n3, n4);
            }
        });
    }

    @Override
    public void fillRoundRect(final int n, final int n2, final int n3, final int n4, final int n5, final int n6) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6);
        this.doShapeFill(double_, new Runnable(){

            @Override
            public void run() {
                TextureLimitingGraphics2D.this.get2DContained().fillRoundRect(n, n2, n3, n4, n5, n6);
            }
        });
    }

    @Override
    public void fillOval(final int n, final int n2, final int n3, final int n4) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(n, n2, n3, n4);
        this.doShapeFill(double_, new Runnable(){

            @Override
            public void run() {
                TextureLimitingGraphics2D.this.get2DContained().fillOval(n, n2, n3, n4);
            }
        });
    }

    @Override
    public void fillArc(final int n, final int n2, final int n3, final int n4, final int n5, final int n6) {
        Arc2D.Double double_ = new Arc2D.Double(n, n2, n3, n4, n5, n6, 2);
        this.doShapeFill(double_, new Runnable(){

            @Override
            public void run() {
                TextureLimitingGraphics2D.this.get2DContained().fillArc(n, n2, n3, n4, n5, n6);
            }
        });
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fillPolygon(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void fillPolygon(final Polygon polygon) {
        this.doShapeFill(polygon, new Runnable(){

            @Override
            public void run() {
                TextureLimitingGraphics2D.this.get2DContained().fillPolygon(polygon);
            }
        });
    }

    @Override
    public void fill(final Shape shape) {
        this.doShapeFill(shape, new Runnable(){

            @Override
            public void run() {
                TextureLimitingGraphics2D.this.get2DContained().fill(shape);
            }
        });
    }

    private void doShapeFill(Shape shape, Runnable runnable) {
        BufferedImage bufferedImage;
        Paint paint = this.getPaint();
        if (paint instanceof TexturePaint && (bufferedImage = ((TexturePaint)paint).getImage()).getWidth() * bufferedImage.getHeight() > this.fSizeLimit) {
            this.setPaint(new Color(0, 0, 0, 0));
            this.fillAsImage(shape, (TexturePaint)paint);
            this.setPaint(paint);
            return;
        }
        runnable.run();
    }

    private void fillAsImage(Shape shape, TexturePaint texturePaint) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        Shape shape2 = this.getClip();
        this.clip(shape);
        BufferedImage bufferedImage = texturePaint.getImage();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
        affineTransform.scale(rectangle2D.getWidth() / (double)bufferedImage.getWidth(), rectangle2D.getHeight() / (double)bufferedImage.getHeight());
        this.drawImage(bufferedImage, affineTransform, null);
        this.setClip(shape2);
    }
}

