/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print.metafile;

import com.mathworks.hg.print.ImageUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;

public abstract class MinimalGraphics2D
extends Graphics2D {
    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.fill(rectangle);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6);
        this.fill(double_);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(n, n2, n3, n4);
        this.fill(double_);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Double double_ = new Arc2D.Double(n, n2, n3, n4, n5, n6, 2);
        this.fill(double_);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fillPolygon(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.fill(polygon);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        Stroke stroke = this.getStroke();
        this.setStroke(new BasicStroke(1.0f, 2, 2));
        this.draw(new Line2D.Double((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, (double)n4 + 0.5));
        this.setStroke(stroke);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        Stroke stroke = this.getStroke();
        this.setStroke(new BasicStroke(1.0f, 2, 2));
        this.draw(new Rectangle2D.Double((double)n + 0.5, (double)n2 + 0.5, n3, n4));
        this.setStroke(stroke);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        Stroke stroke = this.getStroke();
        this.setStroke(new BasicStroke(1.0f, 2, 2));
        this.draw(new RoundRectangle2D.Double((double)n + 0.5, (double)n2 + 0.5, n3, n4, n5, n6));
        this.setStroke(stroke);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        Stroke stroke = this.getStroke();
        this.setStroke(new BasicStroke(1.0f, 2, 2));
        this.draw(new Ellipse2D.Double((double)n + 0.5, (double)n2 + 0.5, n3, n4));
        this.setStroke(stroke);
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Stroke stroke = this.getStroke();
        this.setStroke(new BasicStroke(1.0f, 2, 2));
        this.draw(new Arc2D.Double((double)n + 0.5, (double)n2 + 0.5, n3, n4, n5, n6, 2));
        this.setStroke(stroke);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n > 1) {
            Stroke stroke = this.getStroke();
            this.setStroke(new BasicStroke(1.0f, 2, 2));
            Path2D.Double double_ = new Path2D.Double(1, n);
            ((Path2D)double_).moveTo((float)nArray[0] + 0.5f, (float)nArray2[0] + 0.5f);
            for (int i = 1; i < n; ++i) {
                ((Path2D)double_).lineTo((float)nArray[i] + 0.5f, (float)nArray2[i] + 0.5f);
            }
            this.draw(double_);
            this.setStroke(stroke);
        }
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawPolygon(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        Stroke stroke = this.getStroke();
        this.setStroke(new BasicStroke(1.0f, 2, 2));
        AffineTransform affineTransform = this.getTransform();
        this.translate(0.5, 0.5);
        this.draw(polygon);
        this.setStroke(stroke);
        this.setTransform(affineTransform);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        BufferedImage bufferedImage = ImageUtils.renderImage(image, imageObserver);
        this.drawRenderedImage(bufferedImage, affineTransform);
        return true;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage((Image)bufferedImage2, n, n2, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return ImageUtils.drawImageTransform(this, image, n, n2, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return ImageUtils.drawImageTransform(this, image, n, n2, n3, n4, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return ImageUtils.drawImageTransform(this, image, n, n2, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return ImageUtils.drawImageTransform(this, image, n, n2, n3, n4, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return ImageUtils.drawImageTransform(this, image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return ImageUtils.drawImageTransform(this, image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        if (attributedCharacterIterator != null) {
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
            textLayout.draw(this, f, f2);
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        if (glyphVector.getNumGlyphs() != 0) {
            this.fill(glyphVector.getOutline(f, f2));
        }
    }
}

