/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.util.CategoricalVariable;
import com.mathworks.util.StyledColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.math.DoubleRange;

public class HGMeshColor {
    private volatile double fRed;
    private volatile double fGreen;
    private volatile double fBlue;
    private final double alpha;
    public static final int COLOR = -1;
    public static final int NONE = 0;
    public static final int FLAT = 1;
    public static final int INTERP = 2;
    public static final int TEXTUREMAP = 3;
    public static final int AUTO = 4;
    private volatile Style fStyle;
    public static final int NONE_FLAT_INTERP_TEXTURE = AllowedStyles.NONE_FLAT_INTERP_TEXTURE.getAllowedStyleIndex();
    public static final int NONE_AUTO = AllowedStyles.NONE_AUTO.getAllowedStyleIndex();
    public static final int NONE_AUTO_FLAT = AllowedStyles.NONE_AUTO_FLAT.getAllowedStyleIndex();
    public static final int NONE_FLAT_INTERP = AllowedStyles.NONE_FLAT_INTERP.getAllowedStyleIndex();
    public static final int NONE_ONLY = AllowedStyles.NONE_ONLY.getAllowedStyleIndex();
    private final AllowedStyles fAllowedStyles;
    private static final DoubleRange validRange = new DoubleRange(0.0, 1.0);

    public HGMeshColor(double d, double d2, double d3, int n) {
        this(d, d2, d3, 1.0, n);
    }

    public HGMeshColor(double d, double d2, double d3, double d4, int n) {
        this.fRed = d;
        this.fGreen = d2;
        this.fBlue = d3;
        this.alpha = d4;
        this.fStyle = Style.COLOR;
        this.fAllowedStyles = AllowedStyles.byInt(n);
    }

    public HGMeshColor(int n, int n2) {
        this.fStyle = Style.byInt(n);
        this.fAllowedStyles = AllowedStyles.byInt(n2);
        this.alpha = 0.0;
    }

    public HGMeshColor(HGMeshColor hGMeshColor) {
        if (hGMeshColor == null) {
            throw new IllegalArgumentException("Argument meshColor must not be null.");
        }
        this.fAllowedStyles = hGMeshColor.fAllowedStyles;
        this.fStyle = hGMeshColor.fStyle;
        this.fRed = hGMeshColor.fRed;
        this.fGreen = hGMeshColor.fGreen;
        this.fBlue = hGMeshColor.fBlue;
        this.alpha = hGMeshColor.alpha;
    }

    private void validateComponents(double d, double d2, double d3, double d4) {
        if (!validRange.containsDouble(d)) {
            throw new IllegalArgumentException("red is out of valid range [0,1]: " + d);
        }
        if (!validRange.containsDouble(d2)) {
            throw new IllegalArgumentException("green is out of valid range [0,1]: " + d2);
        }
        if (!validRange.containsDouble(d3)) {
            throw new IllegalArgumentException("blue is out of valid range [0,1]: " + d3);
        }
        if (!validRange.containsDouble(d4)) {
            throw new IllegalArgumentException("alpha is out of valid range [0,1]: " + d4);
        }
    }

    public static HGMeshColor valueOf(StyledColor styledColor, int n) {
        if (styledColor == null) {
            return null;
        }
        String string = styledColor.getStyleName();
        assert (AllowedStyles.byInt(n) != null);
        if (styledColor.isStyle()) {
            assert (Style.byName(string) != null);
            return new HGMeshColor(Style.byName((String)string).fIntValue, n);
        }
        float[] fArray = styledColor.getColorComponents(null);
        return new HGMeshColor(fArray[0], fArray[1], fArray[2], styledColor.getAlpha(), n);
    }

    public StyledColor colorValue() {
        String string = null;
        if (this.fStyle != null) {
            string = Style.byInt((int)this.fStyle.fIntValue).fName;
        }
        List<String> list = this.fAllowedStyles.asList();
        if (Style.COLOR.equals((Object)this.fStyle)) {
            return new StyledColor(this.fRed, this.fGreen, this.fBlue, this.alpha, list);
        }
        return new StyledColor(string, list);
    }

    public double getRed() {
        return this.fRed;
    }

    public void setRed(double d) {
        this.fRed = d;
    }

    public double getGreen() {
        return this.fGreen;
    }

    public void setGreen(double d) {
        this.fGreen = d;
    }

    public double getBlue() {
        return this.fBlue;
    }

    public void setBlue(double d) {
        this.fBlue = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public CategoricalVariable<Integer> getStyleCategory() {
        Style[] styleArray = this.fAllowedStyles.getAllowedStyles();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (int i = 0; i < styleArray.length; ++i) {
            hashMap.put(styleArray[i].fIntValue, styleArray[i].fName);
        }
        hashMap.put(-1, "");
        CategoricalVariable categoricalVariable = new CategoricalVariable(hashMap, null);
        if (this.fStyle != null) {
            categoricalVariable.setValue((Object)this.fStyle.fIntValue);
        }
        return categoricalVariable;
    }

    public void setStyleCategory(CategoricalVariable<Integer> categoricalVariable) {
        this.fStyle = Style.byName(categoricalVariable.getLabel());
    }

    public int getStyle() {
        if (this.fStyle != null) {
            return this.fStyle.fIntValue;
        }
        return -1000;
    }

    public void setStyle(int n) {
        this.fStyle = Style.byInt(n);
    }

    Style getStyleEnum() {
        return this.fStyle;
    }

    private synchronized double[] getComponents() {
        return new double[]{this.fRed, this.fGreen, this.fBlue, this.alpha};
    }

    public List<String> getAllowedStyles() {
        return Collections.unmodifiableList(this.fAllowedStyles.asList());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HGMeshColor)) {
            return false;
        }
        HGMeshColor hGMeshColor = (HGMeshColor)object;
        boolean bl = hGMeshColor.getStyle() == this.getStyle() && (this.getStyleEnum() != Style.COLOR || hGMeshColor.fRed == this.fRed && hGMeshColor.fGreen == this.fGreen && hGMeshColor.fBlue == this.fBlue && hGMeshColor.alpha == this.alpha);
        return bl;
    }

    public static Color getColor(HGMeshColor hGMeshColor) {
        Color color = null;
        if (hGMeshColor != null && hGMeshColor.getStyleEnum() == Style.COLOR) {
            int n = (int)(hGMeshColor.getRed() * 255.0);
            int n2 = (int)(hGMeshColor.getGreen() * 255.0);
            int n3 = (int)(hGMeshColor.getBlue() * 255.0);
            int n4 = (int)(hGMeshColor.alpha * 255.0);
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            color = new Color(n, n2, n3, n4);
        }
        return color;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        if (this.fStyle != null) {
            toStringBuilder.append("style", (Object)this.fStyle.toString());
        }
        toStringBuilder.append("allowedStyles", (Object)this.fAllowedStyles.asList().toString());
        toStringBuilder.append("red", this.fRed).append("green", this.fGreen).append("blue", this.fBlue).append("alpha", this.alpha);
        return toStringBuilder.toString();
    }

    public static enum Style {
        COLOR("", -1),
        NONE("none", 0),
        FLAT("flat", 1),
        INTERP("interp", 2),
        TEXTUREMAP("texturemap", 3),
        AUTO("auto", 4);

        final String fName;
        final int fIntValue;

        private Style(String string2, int n2) {
            this.fName = string2;
            this.fIntValue = n2;
        }

        public String toString() {
            return this.fName;
        }

        public Integer intValue() {
            return this.fIntValue;
        }

        public static boolean contains(String string) {
            Style[] styleArray;
            for (Style style : styleArray = Style.values()) {
                if (!StringUtils.equalsIgnoreCase((String)string, (String)style.toString())) continue;
                return true;
            }
            return false;
        }

        public static boolean contains(int n) {
            Style[] styleArray;
            for (Style style : styleArray = Style.values()) {
                if (style.fIntValue != n) continue;
                return true;
            }
            return false;
        }

        public static Style byInt(int n) {
            for (Style style : Style.values()) {
                if (style.fIntValue != n) continue;
                return style;
            }
            return null;
        }

        public static Style byName(String string) {
            for (Style style : Style.values()) {
                if (!style.fName.equals(string)) continue;
                return style;
            }
            return null;
        }
    }

    public static enum AllowedStyles {
        NONE_FLAT_INTERP_TEXTURE(0, new Style[]{Style.NONE, Style.FLAT, Style.INTERP, Style.TEXTUREMAP}),
        NONE_AUTO(1, new Style[]{Style.NONE, Style.AUTO}),
        NONE_AUTO_FLAT(2, new Style[]{Style.NONE, Style.AUTO, Style.FLAT}),
        NONE_FLAT_INTERP(3, new Style[]{Style.NONE, Style.FLAT, Style.INTERP}),
        NONE_ONLY(4, new Style[]{Style.NONE});

        private Style[] fAllowedStyles;
        private int fAllowedStyleIndex;

        private AllowedStyles(int n2, Style[] styleArray) {
            this.fAllowedStyles = styleArray;
            this.fAllowedStyleIndex = n2;
        }

        public static AllowedStyles byInt(int n) {
            for (AllowedStyles allowedStyles : AllowedStyles.values()) {
                if (allowedStyles.fAllowedStyleIndex != n) continue;
                return allowedStyles;
            }
            return null;
        }

        public List<String> asList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Style style : this.fAllowedStyles) {
                arrayList.add(style.fName);
            }
            return arrayList;
        }

        public Style[] getAllowedStyles() {
            return this.fAllowedStyles;
        }

        public int getAllowedStyleIndex() {
            return this.fAllowedStyleIndex;
        }
    }
}

