/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.panel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.MultilineLabel;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;

public class InfoPanel
extends MJPanel {
    private MJLabel iconLabel;
    private MultilineLabel textLabel;
    private Icon infoIcon;
    private String infoText;

    public InfoPanel(String string) {
        this(string, CommonIcon.INFO.getIcon());
    }

    public InfoPanel(String string, Icon icon) {
        this.setInfoText(string);
        this.setInfoIcon(icon);
        this.buildInfoPanel();
    }

    public void setInfoText(String string) {
        this.infoText = string;
        if (this.textLabel != null) {
            this.textLabel.setText(string);
        }
    }

    public String getInfoText() {
        return this.infoText;
    }

    public MultilineLabel getTextComponent() {
        return this.textLabel;
    }

    public void setInfoIcon(Icon icon) {
        this.infoIcon = icon;
        if (this.iconLabel != null) {
            this.iconLabel.setIcon(icon);
            this.iconLabel.setVisible(icon != null);
        }
    }

    public Icon getInfoIcon() {
        return this.infoIcon;
    }

    private void buildInfoPanel() {
        this.iconLabel = new MJLabel(this.getInfoIcon());
        this.textLabel = new MultilineLabel(this.getInfoText());
        FormLayout formLayout = new FormLayout("4dlu, p, 4dlu, 0dlu:g(1.0)", "max(24dlu;p)");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)((Object)this));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.iconLabel, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.textLabel, cellConstraints.xy(4, 1));
        this.iconLabel.setVisible(this.getInfoIcon() != null);
        this.setBackground(SystemColor.text);
        this.setForeground(SystemColor.textText);
        this.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow));
    }
}

