/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.panel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import com.jidesoft.grid.AbstractMultiTableModel;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.NumberCellRenderer;
import com.jidesoft.grid.StringCellEditor;
import com.jidesoft.grid.TableScrollPane;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.hg.types.table.TablePropertyModel;
import com.mathworks.hg.types.table.panel.AbstractEditorPanel;
import com.mathworks.hg.types.table.panel.EditableTableSupport;
import com.mathworks.hg.types.table.panel.EditableTableUtils;
import com.mathworks.hg.types.table.panel.MessagePanel;
import com.mathworks.hg.types.table.panel.PropertyPanelEnum;
import com.mathworks.hg.types.table.panel.StringListTableModel;
import com.mathworks.hg.types.table.panel.TableEnterKeyAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class RowHeaderPanel
extends AbstractEditorPanel
implements EditableTableSupport {
    private JTable mainTable;
    private JTable rowHeaderTable;
    private StringListTableModel tableModel;
    private MessagePanel infoPanel;
    private MJRadioButton headerNone;
    private MJRadioButton headerNumbered;
    private MJRadioButton headerNamed;
    private MJButton buttonInsert;
    private MJButton buttonCopy;
    private MJButton buttonDelete;
    private MJButton buttonMoveUp;
    private MJButton buttonMoveDown;
    private RowInfoMode currentInfoMode;

    public RowHeaderPanel(PropertyPanelEnum propertyPanelEnum, TablePropertyModel tablePropertyModel) {
        super(propertyPanelEnum, tablePropertyModel);
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    protected JPanel buildEditorPanel() {
        this.infoPanel = new MessagePanel(this.getResourceString("row_names.info_default"));
        this.infoPanel.getAccessibleContext().setAccessibleDescription(this.getResourceString("row_names.info_default"));
        this.currentInfoMode = RowInfoMode.DEFAULT;
        FormLayout formLayout = new FormLayout("p, 0dlu:g(1.0)", "p, 8dlu, p, 0dlu:g(1.0)");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.buildModePanel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildRowNamePanel(), cellConstraints.xy(1, 3));
        panelBuilder.setBorder(Borders.createEmptyBorder((String)"6dlu, 0dlu, 0dlu, 0dlu"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)((Object)this.infoPanel), (Object)"North");
        mJPanel.add((Component)panelBuilder.getPanel(), (Object)"Center");
        mJPanel.setBorder(Borders.createEmptyBorder((String)"7dlu, 7dlu, 0dlu, 0dlu"));
        mJPanel.getAccessibleContext().setAccessibleName(this.getResourceString("acc.header.name"));
        return mJPanel;
    }

    private JPanel buildModePanel() {
        this.headerNone = this.createRadioButton("row_names.none", "row_names.tip_none");
        this.headerNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowHeaderPanel.this.updateInfoPanel(RowInfoMode.DEFAULT);
            }
        });
        this.headerNumbered = this.createRadioButton("row_names.numbered", "row_names.tip_numbered");
        this.headerNumbered.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowHeaderPanel.this.updateInfoPanel(RowInfoMode.DEFAULT);
            }
        });
        this.headerNamed = this.createRadioButton("row_names.named", "row_names.tip_named");
        this.headerNamed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowHeaderPanel.this.switchToNameMode();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.headerNone);
        buttonGroup.add((AbstractButton)this.headerNumbered);
        buttonGroup.add((AbstractButton)this.headerNamed);
        FormLayout formLayout = new FormLayout("p, 0dlu:g(1.0)", "p, 4dlu, p, 4dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.headerNone, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.headerNumbered, cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.headerNamed, cellConstraints.xy(1, 5));
        return panelBuilder.getPanel();
    }

    private void updateInfoPanel(RowInfoMode rowInfoMode) {
        if (rowInfoMode != this.currentInfoMode) {
            switch (rowInfoMode) {
                default: 
            }
            this.infoPanel.setMessage(this.getResourceString("row_names.info_default"));
            this.infoPanel.getAccessibleContext().setAccessibleDescription(this.getResourceString("row_names.info_default"));
            this.currentInfoMode = rowInfoMode;
        }
    }

    @Override
    protected void initializePanel() {
        String string;
        Object object = this.propertyModel.getProperty("RowName");
        Object object2 = this.getMetadataValue("RowNameTyped");
        Object object3 = this.getMetadataValue("DataPropertyDimension");
        MJRadioButton mJRadioButton = object == null || "".equals(object) || object instanceof String[] && ((String[])object).length == 0 ? this.headerNone : ("numbered".equals(object) ? this.headerNumbered : this.headerNamed);
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            string = null;
            if (object != null && object instanceof String[] && ((String[])object).length > n) {
                string = ((String[])object)[n];
            } else if (object2 != null && object2 instanceof String[] && ((String[])object2).length > n) {
                string = ((String[])object2)[n];
            }
            if (!(object3 != null && object3 instanceof double[] && (double)n < ((double[])object3)[0]) && string == null) continue;
            arrayList.add(string);
        } while (object3 != null && object3 instanceof double[] && (double)(++n) < ((double[])object3)[0] || string != null);
        this.tableModel.setStrings(arrayList);
        if (this.tableModel.getRowCount() == 0) {
            this.tableModel.addString();
        }
        mJRadioButton.setSelected(true);
        this.requestInitialFocus(mJRadioButton);
    }

    @Override
    public void commit() {
        int n = this.tableModel.getRowCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.tableModel.getValueAt(i, 1) == null ? "" : this.tableModel.getValueAt(i, 1).toString();
        }
        String[] stringArray2 = "";
        if (this.headerNumbered.isSelected()) {
            stringArray2 = "numbered";
        } else if (this.headerNamed.isSelected()) {
            stringArray2 = stringArray;
        }
        this.setMetadataValue("RowNameTyped", stringArray);
        this.propertyModel.putProperty("RowName", stringArray2);
    }

    private void requestInitialFocus(final MJRadioButton mJRadioButton) {
        if (EventQueue.isDispatchThread()) {
            mJRadioButton.requestFocusInWindow();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    mJRadioButton.requestFocusInWindow();
                }
            });
        }
    }

    private MJRadioButton createRadioButton(String string, String string2) {
        MJRadioButton mJRadioButton = new MJRadioButton(this.getResourceString(string));
        if (string2 != null) {
            mJRadioButton.setToolTipText(this.getResourceString(string2));
        }
        return mJRadioButton;
    }

    private JPanel buildRowNamePanel() {
        FormLayout formLayout = new FormLayout("16dlu, fill:p, 6dlu, p, 0dlu:g(1.0)", "fill:p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.buildRowNameTable(), cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.buildButtonPanel(), cellConstraints.xy(4, 1));
        return panelBuilder.getPanel();
    }

    private TableScrollPane buildRowNameTable() {
        this.tableModel = this.createTableModel();
        TableScrollPane tableScrollPane = this.createTableScrollPane(this.tableModel);
        this.mainTable = tableScrollPane.getMainTable();
        this.rowHeaderTable = tableScrollPane.getRowHeaderTable();
        this.customizeMainTable();
        this.setTableHeaderAlignments();
        this.setChoiceColumnCellEditor();
        this.setRowHeaderColumnRenderer();
        this.attachTableModelListener();
        this.attachEnterKeyActions();
        this.attachMainTableSelectionListener();
        EditableTableUtils.attachTableAccelerators(this.mainTable, this);
        return tableScrollPane;
    }

    private StringListTableModel createTableModel() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(EDITOR_RESOURCES.getString("row_names.title0"));
        arrayList.add(EDITOR_RESOURCES.getString("row_names.title1"));
        return new StringListTableModel(arrayList);
    }

    private TableScrollPane createTableScrollPane(AbstractMultiTableModel abstractMultiTableModel) {
        TableScrollPane tableScrollPane = new TableScrollPane((MultiTableModel)abstractMultiTableModel, false){

            protected JTable createTable(TableModel tableModel, boolean bl) {
                return new CellStyleTable(tableModel){

                    public boolean getScrollableTracksViewportWidth() {
                        if (this.autoResizeMode != 0 && this.getParent() instanceof JViewport) {
                            return this.getParent().getWidth() > this.getPreferredSize().width;
                        }
                        return false;
                    }
                };
            }
        };
        tableScrollPane.setPreferredSize(new Dimension(280, 200));
        return tableScrollPane;
    }

    private void customizeMainTable() {
        this.mainTable.setAutoResizeMode(3);
        this.mainTable.setSelectionMode(0);
        this.mainTable.setCellSelectionEnabled(true);
        this.mainTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.mainTable.getAccessibleContext().setAccessibleName(this.getResourceString("acc.header.table"));
    }

    private void setTableHeaderAlignments() {
        ((JLabel)((Object)this.mainTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        ((JLabel)((Object)this.rowHeaderTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
    }

    private void setChoiceColumnCellEditor() {
        StringCellEditor stringCellEditor = new StringCellEditor();
        this.mainTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)stringCellEditor);
    }

    private void attachTableModelListener() {
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!RowHeaderPanel.this.headerNamed.isSelected() && RowHeaderPanel.this.tableModel.hasStrings()) {
                            RowHeaderPanel.this.headerNamed.setSelected(true);
                        }
                        RowHeaderPanel.this.scrollSelectedRowToVisible();
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    runnable.run();
                } else {
                    EventQueue.invokeLater(runnable);
                }
            }
        });
    }

    private void attachEnterKeyActions() {
        JTextField jTextField = ((StringCellEditor)this.mainTable.getColumnModel().getColumn(0).getCellEditor()).getTextField();
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "none");
        TableEnterKeyAction tableEnterKeyAction = new TableEnterKeyAction(this.mainTable, this);
        this.mainTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "my-action-key");
        this.mainTable.getActionMap().put("my-action-key", tableEnterKeyAction);
    }

    private void attachMainTableSelectionListener() {
        this.mainTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    RowHeaderPanel.this.processSelectionChange();
                }
            }
        });
    }

    private void setRowHeaderColumnRenderer() {
        TableColumn tableColumn = this.rowHeaderTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(40);
        NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
        numberCellRenderer.setHorizontalAlignment(0);
        numberCellRenderer.setBackground(UIManager.getColor("TableHeader.background"));
        numberCellRenderer.setForeground(UIManager.getColor("TableHeader.foreground"));
        numberCellRenderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        tableColumn.setCellRenderer((TableCellRenderer)numberCellRenderer);
    }

    private JPanel buildButtonPanel() {
        this.buttonInsert = this.createButton("buttons.insert", "buttons.tip_insert", MiscellaneousIcon.ADD.getIcon());
        this.buttonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowHeaderPanel.this.addEntry();
            }
        });
        this.buttonCopy = this.createButton("buttons.copy", "buttons.tip_copy", CommonIcon.COPY.getIcon());
        this.buttonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowHeaderPanel.this.copyEntry();
            }
        });
        this.buttonDelete = this.createButton("buttons.delete", "buttons.tip_delete", MiscellaneousIcon.SUBTRACT.getIcon());
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowHeaderPanel.this.removeEntry();
            }
        });
        this.buttonMoveUp = this.createButton("buttons.move_up", "buttons.tip_move_up", CommonIcon.UP.getIcon());
        this.buttonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowHeaderPanel.this.moveEntryUp();
            }
        });
        this.buttonMoveDown = this.createButton("buttons.move_down", "buttons.tip_move_down", CommonIcon.DOWN.getIcon());
        this.buttonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowHeaderPanel.this.moveEntryDown();
            }
        });
        FormLayout formLayout = new FormLayout("fill:p", "p, p, p, p, p, p, p, p, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        ConstantSize constantSize = LayoutStyle.getCurrent().getUnrelatedComponentsPadY();
        int n = constantSize.getPixelSize((Component)panelBuilder.getPanel());
        ConstantSize constantSize2 = LayoutStyle.getCurrent().getRelatedComponentsPadY();
        int n2 = constantSize2.getPixelSize((Component)panelBuilder.getPanel());
        panelBuilder.add((Component)this.buttonInsert, cellConstraints.xy(1, 1));
        panelBuilder.add(Box.createVerticalStrut(n2), cellConstraints.xy(1, 2));
        panelBuilder.add((Component)this.buttonCopy, cellConstraints.xy(1, 3));
        panelBuilder.add(Box.createVerticalStrut(n2), cellConstraints.xy(1, 4));
        panelBuilder.add((Component)this.buttonDelete, cellConstraints.xy(1, 5));
        panelBuilder.add(Box.createVerticalStrut(n), cellConstraints.xy(1, 6));
        panelBuilder.add((Component)this.buttonMoveUp, cellConstraints.xy(1, 7));
        panelBuilder.add(Box.createVerticalStrut(n2), cellConstraints.xy(1, 8));
        panelBuilder.add((Component)this.buttonMoveDown, cellConstraints.xy(1, 9));
        return panelBuilder.getPanel();
    }

    private MJButton createButton(String string, String string2, Icon icon) {
        MJButton mJButton = new MJButton();
        if (string != null) {
            mJButton.setText(EDITOR_RESOURCES.getString(string));
        }
        if (string2 != null) {
            mJButton.setToolTipText(EDITOR_RESOURCES.getString(string2));
        }
        if (!PlatformInfo.isMacintosh() && icon != null) {
            int n;
            mJButton.setIcon(icon);
            Insets insets = mJButton.getMargin();
            insets.left = n = (int)((double)insets.top * 2.0);
            insets.right = n;
            mJButton.setMargin(insets);
            mJButton.setHorizontalAlignment(10);
        }
        return mJButton;
    }

    private void switchToNameMode() {
        int n;
        boolean bl = false;
        List<String> list = this.tableModel.getStrings();
        for (String string : list) {
            if (string == null || string.length() <= 0) continue;
            bl = true;
            break;
        }
        if ((n = this.tableModel.getRowCount() - 1) >= 0) {
            n = bl ? n : 0;
            this.mainTable.setRowSelectionInterval(n, n);
            this.mainTable.setColumnSelectionInterval(0, 0);
        }
        this.mainTable.requestFocusInWindow();
    }

    @Override
    public void addEntry() {
        int n = this.mainTable.getSelectedRow();
        if (n == -1) {
            n = this.mainTable.getRowCount() - 1;
        }
        this.tableModel.addString(++n);
        this.mainTable.getSelectionModel().setSelectionInterval(n, n);
        this.mainTable.requestFocusInWindow();
    }

    @Override
    public void copyEntry() {
        int n = this.mainTable.getSelectedRow();
        if (n != -1) {
            this.tableModel.copyString(n);
            this.mainTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            this.mainTable.requestFocusInWindow();
        }
    }

    @Override
    public void removeEntry() {
        int n = this.mainTable.getSelectedRow();
        if (n != -1) {
            this.tableModel.removeString(n);
            int n2 = this.mainTable.getRowCount() - 1;
            if (n2 >= 0) {
                n = n > n2 ? n2 : n;
                this.mainTable.getSelectionModel().setSelectionInterval(n, n);
                this.mainTable.requestFocusInWindow();
            }
        }
    }

    @Override
    public void moveEntryUp() {
        boolean bl = this.buttonMoveUp.hasFocus();
        int n = this.mainTable.getSelectedRow();
        if (n > 0) {
            this.tableModel.moveStringUp(n);
            this.mainTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            if (bl) {
                this.buttonMoveUp.requestFocusInWindow();
            }
        }
    }

    @Override
    public void moveEntryDown() {
        boolean bl = this.buttonMoveUp.hasFocus();
        int n = this.mainTable.getSelectedRow();
        int n2 = this.mainTable.getRowCount() - 1;
        if (n >= 0 && n < n2) {
            this.tableModel.moveStringDown(n);
            this.mainTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            if (bl) {
                this.buttonMoveDown.requestFocusInWindow();
            }
        }
    }

    private void scrollSelectedRowToVisible() {
        int n = this.mainTable.getSelectedRow();
        Rectangle rectangle = this.mainTable.getCellRect(n, 0, true);
        this.mainTable.scrollRectToVisible(rectangle);
    }

    private void processSelectionChange() {
        int n = this.mainTable.getSelectedRow();
        int n2 = this.mainTable.getRowCount() - 1;
        this.buttonInsert.setSelected(true);
        this.buttonCopy.setEnabled(n >= 0);
        this.buttonDelete.setEnabled(n >= 0);
        this.buttonMoveUp.setEnabled(n > 0);
        this.buttonMoveDown.setEnabled(n >= 0 && n < n2);
    }

    private static enum RowInfoMode {
        DEFAULT,
        NAMES;

    }
}

