/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.panel;

import com.jidesoft.grid.AbstractMultiTableModel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class StringListTableModel
extends AbstractMultiTableModel {
    private LinkedList<String> listStrings;
    private List<String> listTitles;
    private boolean isDirty;

    public StringListTableModel(List<String> list) {
        this(list, null);
    }

    public StringListTableModel(List<String> list, List<String> list2) {
        this.listTitles = list;
        this.listStrings = new LinkedList();
        if (list2 != null) {
            for (String string : list2) {
                this.listStrings.add(string);
            }
        }
        this.isDirty = false;
    }

    public String getColumnName(int n) {
        return n < this.listTitles.size() ? this.listTitles.get(n) : "";
    }

    public int getColumnCount() {
        return this.listTitles.size();
    }

    public int getRowCount() {
        return this.listStrings.size();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return Object.class;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 1: {
                boolean bl;
                String string = (String)object;
                String string2 = this.listStrings.get(n);
                if (string2 == null) {
                    string2 = "";
                }
                boolean bl2 = bl = !string.equals(string2);
                if (!bl) break;
                this.isDirty = true;
                this.listStrings.set(n, string);
                this.fireTableCellUpdated(n, n2);
                break;
            }
        }
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return String.valueOf(n + 1);
            }
            case 1: {
                return this.listStrings.get(n);
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 > 0;
    }

    public int getTableIndex(int n) {
        return 0;
    }

    public int getColumnType(int n) {
        return n <= 0 ? 1 : 0;
    }

    public void addString() {
        int n = this.listStrings.size();
        this.addString(n);
    }

    public void addString(int n) {
        String string = "";
        this.listStrings.add(n, string);
        this.fireTableRowsInserted(n, n);
    }

    public void copyString(int n) {
        String string = this.listStrings.get(n);
        String string2 = String.valueOf(string);
        this.listStrings.add(n + 1, string2);
        this.fireTableRowsInserted(n + 1, n + 1);
    }

    public void removeString(int n) {
        if (n >= 0 && n < this.listStrings.size()) {
            this.listStrings.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void moveStringUp(int n) {
        String string = this.listStrings.get(n);
        this.listStrings.remove(n);
        this.listStrings.add(n - 1, string);
        this.fireTableRowsUpdated(n - 1, n);
    }

    public void moveStringDown(int n) {
        String string = this.listStrings.get(n);
        this.listStrings.remove(n);
        this.listStrings.add(n + 1, string);
        this.fireTableRowsUpdated(n, n + 1);
    }

    public List<String> getStrings() {
        return this.listStrings;
    }

    public void setStrings(List<String> list) {
        this.listStrings.clear();
        this.listStrings.addAll(list);
        this.fireTableDataChanged();
    }

    public void clearStrings() {
        this.listStrings.clear();
        this.fireTableDataChanged();
    }

    public boolean hasStrings() {
        boolean bl;
        block1: {
            String string;
            bl = false;
            if (this.listStrings.size() <= 0) break block1;
            Iterator iterator = this.listStrings.iterator();
            while (iterator.hasNext() && !(bl = (string = (String)iterator.next()) != null && !"".equals(string))) {
            }
        }
        return bl;
    }

    public boolean isDirty() {
        return this.isDirty;
    }
}

