/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import com.sun.jini.example.browser.Browser;
import com.sun.jini.example.browser.Introspector;
import com.sun.jini.example.browser.ObjectNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.ServiceControlled;

abstract class EntryTreePanel
extends JPanel {
    private boolean isControllable;
    private JScrollPane scrollPane;
    protected JTree tree;
    protected ObjectNode root;
    protected DefaultTreeModel model;
    private boolean showModifier = false;
    private boolean showPackage = false;

    public EntryTreePanel(boolean bl) {
        this.isControllable = bl;
        this.setLayout(new BorderLayout());
        this.root = new ObjectNode(bl);
        this.model = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.model);
        this.tree.setRootVisible(false);
        ObjectNodeRenderer objectNodeRenderer = new ObjectNodeRenderer();
        this.tree.setCellRenderer(objectNodeRenderer);
        this.tree.setRowHeight(0);
        this.scrollPane = new JScrollPane(this.tree);
        this.add((Component)this.scrollPane, "Center");
        this.tree.validate();
        this.scrollPane.validate();
    }

    protected abstract Entry[] getEntryArray();

    protected void initTree() {
        Entry[] entryArray = this.getEntryArray();
        if (entryArray == null) {
            entryArray = new Entry[]{};
        }
        for (int i = 0; i < entryArray.length; ++i) {
            boolean bl = false;
            if (this.isControllable && !(entryArray[i] instanceof ServiceControlled)) {
                bl = true;
            }
            ObjectNode objectNode = new ObjectNode(entryArray[i], bl);
            this.root.add(objectNode);
            try {
                this.recursiveObjectTree(objectNode);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Browser.logger.log(Level.INFO, "entry access failed", illegalAccessException);
            }
        }
    }

    public void refreshPanel() {
        this.root.removeAllChildren();
        this.initTree();
        this.model.nodeStructureChanged(this.root);
        this.tree.validate();
        this.scrollPane.validate();
    }

    protected void recursiveObjectTree(ObjectNode objectNode) throws IllegalArgumentException, IllegalAccessException {
        Object object = objectNode.getObject();
        if (object == null) {
            return;
        }
        Field[] fieldArray = object.getClass().getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Object object2;
            Field field = fieldArray[i];
            if (Introspector.isHidden(field)) continue;
            Class<?> clazz = field.getType();
            ObjectNode objectNode2 = null;
            String string = field.getName();
            if (clazz.isPrimitive()) {
                object2 = clazz.toString();
                Constable constable = null;
                if ("int".equals(object2)) {
                    constable = new Integer(field.getInt(object));
                } else if ("boolean".equals(object2)) {
                    constable = new Boolean(field.getBoolean(object));
                } else if ("byte".equals(object2)) {
                    constable = new Byte(field.getByte(object));
                } else if ("char".equals(object2)) {
                    constable = new Character(field.getChar(object));
                } else if ("double".equals(object2)) {
                    constable = new Double(field.getDouble(object));
                } else if ("float".equals(object2)) {
                    constable = new Float(field.getFloat(object));
                } else if ("long".equals(object2)) {
                    constable = new Long(field.getLong(object));
                }
                objectNode2 = new ObjectNode(constable, clazz, string, true);
            } else if (Introspector.isWrapper(clazz) || Introspector.isString(clazz)) {
                objectNode2 = new ObjectNode(field.get(object), clazz, string, true);
            } else if (clazz.isArray()) {
                objectNode2 = new ObjectNode(field.get(object), clazz, string, false);
                objectNode2.setAdministrable(objectNode.isAdministrable());
                objectNode2.setControllable(objectNode.isControllable());
                this.recursiveArrayTree(objectNode2, field);
            } else {
                object2 = field.get(object);
                if (this.countViewableFields(clazz) > 0) {
                    objectNode2 = new ObjectNode(object2, clazz, string, false);
                    objectNode2.setAdministrable(objectNode.isAdministrable());
                    objectNode2.setControllable(objectNode.isControllable());
                    this.recursiveObjectTree(objectNode2);
                } else {
                    objectNode2 = new ObjectNode(object2, clazz, string, true);
                }
            }
            objectNode.add(objectNode2);
        }
    }

    private int countViewableFields(Class clazz) {
        int n = 0;
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (Introspector.isHidden(field)) continue;
            ++n;
        }
        return n;
    }

    private void recursiveArrayTree(ObjectNode objectNode, Field field) throws IllegalArgumentException, IllegalAccessException {
        String string = objectNode.getFieldName();
        Object object = objectNode.getObject();
        int n = Array.getLength(object);
        Class<?> clazz = field.getType().getComponentType();
        if (clazz.isPrimitive() || Introspector.isWrapper(clazz) || Introspector.isString(clazz)) {
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                ObjectNode objectNode2 = new ObjectNode(object2, clazz, string, i, true);
                objectNode.add(objectNode2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object, i);
                ObjectNode objectNode3 = new ObjectNode(object3, clazz, string, i, false);
                this.recursiveObjectTree(objectNode3);
                objectNode3.setAdministrable(objectNode.isAdministrable());
                objectNode3.setControllable(objectNode.isControllable());
                objectNode.add(objectNode3);
            }
        }
    }

    class ObjectNodeRenderer
    implements TreeCellRenderer {
        private JLabel label = new JLabel();

        public ObjectNodeRenderer() {
            this.label.setOpaque(true);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.label.setForeground(jTree.getForeground());
            if (bl) {
                this.label.setBackground(MetalLookAndFeel.getPrimaryControl());
            } else {
                this.label.setBackground(jTree.getBackground());
            }
            ObjectNode objectNode = (ObjectNode)object;
            this.label.setText(objectNode.getTitle());
            this.label.setIcon(objectNode.getIcon());
            return this.label;
        }
    }
}

