/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.StreamGobbler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ProcessExecutorImpl
implements ProcessExecutor {
    private static final long DEFAULT_TIMEOUT = 60000L;

    @Override
    public int executeWithTimeout(Process process, String[] stringArray, long l) throws IOException, TimeoutException {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new InterruptScheduler(Thread.currentThread()), l);
        int n = -1;
        try {
            ProcessExecutorImpl.gobbleStreams(process);
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            process.destroy();
            String string = "";
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (string.length() > 0) {
                        string = string.concat(" ");
                    }
                    string = string.concat(string2);
                }
            }
            TimeoutException timeoutException = new TimeoutException("External process (" + string + ") did not return after " + l + " milliseconds");
            timeoutException.initCause(interruptedException);
            throw timeoutException;
        }
        finally {
            timer.cancel();
        }
        return n;
    }

    static int waitWithTimeoutUsingFuture(final Process process, String[] stringArray, long l, ExecutorService executorService) throws ExecutionException, TimeoutException, InterruptedException {
        int n = -1;
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() throws InterruptedException {
                process.waitFor();
                return process.exitValue();
            }
        };
        Future<Integer> future = executorService.submit(callable);
        try {
            ProcessExecutorImpl.gobbleStreams(process);
            n = future.get(l, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            process.destroy();
            String string = "";
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (string.length() > 0) {
                        string = string.concat(" ");
                    }
                    string = string.concat(string2);
                }
            }
            TimeoutException timeoutException2 = new TimeoutException("External process (" + string + ") did not return after " + l + " milliseconds");
            timeoutException2.initCause(timeoutException);
            throw timeoutException2;
        }
        finally {
            future.cancel(true);
        }
        return n;
    }

    @Override
    public int executeWithTimeout(Process process, long l) throws IOException, TimeoutException {
        return this.executeWithTimeout(process, null, l);
    }

    @Override
    public int executeWithTimeout(Process process) throws IOException, TimeoutException {
        return this.executeWithTimeout(process, 60000L);
    }

    @Override
    public int executeWithTimeout(String[] stringArray) throws IOException, TimeoutException {
        return this.executeWithTimeout(stringArray, 60000L);
    }

    @Override
    public int executeWithTimeout(String[] stringArray, long l) throws IOException, TimeoutException {
        Process process = this.start(stringArray);
        return this.executeWithTimeout(process, stringArray, l);
    }

    @Override
    public int runtimeExecWithTimeout(List<String> list, String[] stringArray, long l, ExecutorService executorService) throws TimeoutException, IOException, ExecutionException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        String string = ProcessExecutorImpl.convertPathListToString(list);
        Map<String, String> map = processBuilder.environment();
        ProcessExecutorImpl.prependDirsToPath(string, map);
        Process process = processBuilder.start();
        return ProcessExecutorImpl.waitWithTimeoutUsingFuture(process, stringArray, l, executorService);
    }

    static String convertPathListToString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder("");
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    static void prependDirsToPath(String string, Map<String, String> map) {
        Set<String> set = map.keySet();
        boolean bl = false;
        for (String string2 : set) {
            if (!string2.equalsIgnoreCase("Path")) continue;
            bl = true;
            StringBuilder stringBuilder = new StringBuilder(string);
            String string3 = map.get(string2);
            if (string3 != null) {
                stringBuilder.append(string3);
            }
            if (stringBuilder.length() > 2047) {
                stringBuilder.setLength(2047);
            }
            map.put(string2, stringBuilder.toString());
        }
        if (!bl) {
            map.put("Path", string);
        }
    }

    @Override
    public Process start(String[] stringArray) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        return ProcessExecutorImpl.start(processBuilder);
    }

    @Override
    public Process start(String[] stringArray, File file) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray).directory(file);
        return ProcessExecutorImpl.start(processBuilder);
    }

    private static Process start(ProcessBuilder processBuilder) throws IOException {
        Process process = processBuilder.start();
        ProcessExecutorImpl.gobbleStreams(process);
        return process;
    }

    private static void gobbleStreams(Process process) {
        StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
        StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream());
        streamGobbler.start();
        streamGobbler2.start();
    }

    public static List<String> executeTaskWithOutput(String[] stringArray, ExecutorService executorService) throws IOException, TimeoutException, ExecutionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        final Process process = new ProcessBuilder(stringArray).start();
        StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
        streamGobbler.start();
        Callable<List<String>> callable = new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> call() throws InterruptedException, IOException {
                BufferedReader bufferedReader = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        arrayList.add(string);
                    }
                    process.waitFor();
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                return arrayList;
            }
        };
        Future<List<String>> future = executorService.submit(callable);
        try {
            arrayList.addAll((Collection)future.get(5000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException | TimeoutException exception) {
            process.destroy();
            String string = "";
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (string.length() > 0) {
                        string = string.concat(" ");
                    }
                    string = string.concat(string2);
                }
            }
            TimeoutException timeoutException = new TimeoutException("External process (" + string + ") did not return after " + 5000L + " milliseconds");
            timeoutException.initCause(exception);
            throw timeoutException;
        }
        finally {
            future.cancel(true);
        }
        return arrayList;
    }

    private static class InterruptScheduler
    extends TimerTask {
        private Thread target = null;

        InterruptScheduler(Thread thread) {
            this.target = thread;
        }

        @Override
        public void run() {
            this.target.interrupt();
        }
    }
}

