/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.logging;

import com.mathworks.instutil.logging.AppLogFormatter;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.instutil.logging.AppMemoryTarget;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;

public class AppLoggerImpl
implements AppLogger {
    private static final Level DEFAULT_LEVEL = Level.INFO;
    private final Logger theJavaLogger = Logger.getLogger("com.mathworks.instutil.logging");
    private FileHandler fileHandler = null;
    private ConsoleHandler consoleHandler = null;
    private MemoryHandler memHandler = null;
    private AppMemoryTarget localMemTarget = null;
    private String path;

    public AppLoggerImpl() {
        this.configLogger();
        this.printLogHeader();
    }

    @Override
    public synchronized void enableFileLogging(String string) throws IOException {
        this.path = string;
        if (this.fileHandler != null) {
            this.fileHandler.close();
            this.theJavaLogger.removeHandler(this.fileHandler);
        }
        this.fileHandler = new FileHandler(string, 0, 1, true);
        this.fileHandler.setLevel(DEFAULT_LEVEL);
        this.fileHandler.setFormatter(new AppLogFormatter());
        this.theJavaLogger.addHandler(this.fileHandler);
        this.theJavaLogger.removeHandler(this.memHandler);
        this.memHandler = null;
    }

    @Override
    public synchronized void enableConsoleLogging() {
        if (this.consoleHandler != null) {
            this.consoleHandler.close();
            this.theJavaLogger.removeHandler(this.consoleHandler);
        }
        this.consoleHandler = new StdOutConsoleHandler();
        this.consoleHandler.setLevel(DEFAULT_LEVEL);
        this.consoleHandler.setFormatter(new AppLogFormatter());
        this.theJavaLogger.addHandler(this.consoleHandler);
        this.theJavaLogger.removeHandler(this.memHandler);
        this.memHandler = null;
    }

    @Override
    public synchronized void dumpStoredMessages() {
        if (this.memHandler == null) {
            String[] stringArray;
            for (String string : stringArray = this.localMemTarget.popMessages()) {
                this.logMsg(string);
            }
        }
    }

    @Override
    public void setLevel(Level level) throws SecurityException {
        Handler[] handlerArray;
        this.theJavaLogger.setLevel(level);
        for (Handler handler : handlerArray = this.theJavaLogger.getHandlers()) {
            handler.setLevel(level);
        }
    }

    @Override
    public void logMsg(String string) {
        this.logLevel(Level.INFO, string);
    }

    @Override
    public void debugMsg(String string) {
        this.logLevel(Level.FINE, string);
    }

    private void logLevel(Level level, String string) {
        this.theJavaLogger.log(level, string);
    }

    @Override
    public synchronized void close() {
        if (this.fileHandler != null) {
            this.fileHandler.close();
        }
        if (this.consoleHandler != null) {
            this.consoleHandler.close();
        }
        if (this.memHandler != null) {
            this.memHandler.close();
        }
        this.theJavaLogger.removeHandler(this.fileHandler);
        this.theJavaLogger.removeHandler(this.consoleHandler);
        this.theJavaLogger.removeHandler(this.memHandler);
    }

    @Override
    public synchronized String getPath() {
        return this.path;
    }

    @Override
    public Logger getLogger() {
        return this.theJavaLogger;
    }

    private void printLogHeader() {
        this.logMsg("##################################################################");
        this.logMsg("#");
        this.logMsg("# Today's Date: ");
        this.logMsg(new Date().toString());
        this.logMsg("");
        this.logMsg("System Info");
        this.logMsg("OS: " + System.getProperty("os.name") + ' ' + System.getProperty("os.version"));
        this.logMsg("Arch: " + System.getProperty("os.arch"));
        this.logMsg("Data Model: " + System.getProperty("sun.arch.data.model"));
        this.logMsg("Language: " + Locale.getDefault().getLanguage());
        this.logMsg("Java Vendor: " + System.getProperty("java.vendor"));
        this.logMsg("Java Home: " + System.getProperty("java.home"));
        this.logMsg("Java Version: " + System.getProperty("java.version"));
        this.logMsg("Java VM Name: " + System.getProperty("java.vm.name"));
        this.logMsg("Java Class Path: " + System.getProperty("java.class.path"));
        this.logMsg("User Name: " + System.getProperty("user.name"));
        this.logMsg("Current Directory: " + System.getProperty("user.dir"));
    }

    private synchronized void configLogger() {
        this.theJavaLogger.setUseParentHandlers(false);
        this.theJavaLogger.setLevel(DEFAULT_LEVEL);
        this.theJavaLogger.setFilter(null);
        this.localMemTarget = new AppMemoryTarget();
        this.localMemTarget.setFormatter(new AppLogFormatter());
        this.localMemTarget.setLevel(DEFAULT_LEVEL);
        this.memHandler = new MemoryHandler(this.localMemTarget, 1000, DEFAULT_LEVEL);
        this.memHandler.setFormatter(new AppLogFormatter());
        this.memHandler.setLevel(DEFAULT_LEVEL);
        this.theJavaLogger.addHandler(this.memHandler);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private static class StdOutConsoleHandler
    extends ConsoleHandler {
        StdOutConsoleHandler() {
            this.setOutputStream(System.out);
        }
    }
}

