/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.services;

import com.mathworks.instutil.services.AwsActivationServiceThread;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.internal.mwaws.client.v5.MWACreateProfileResponse;
import com.mathworks.internal.mwaws.client.v5.MWAResponse;
import com.mathworks.mlwebservices.ActivationService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class CreateProfileForSelfThread
extends AwsActivationServiceThread<Boolean> {
    private final String email;
    private final String password;
    private final String firstName;
    private final String lastName;
    private final String activationKey;
    private boolean verified;
    private Lock resultLock = new ReentrantLock();

    CreateProfileForSelfThread(ServiceThreadView serviceThreadView, ActivationService activationService, String string, String string2, String string3, String string4, String string5) {
        super(serviceThreadView, activationService, "dialog.title", "dialog.service");
        this.email = string;
        this.password = string2;
        this.firstName = string3;
        this.lastName = string4;
        this.activationKey = string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        ActivationService activationService = this.getActivationService();
        if (activationService.isConnected()) {
            String string = this.getClientString();
            try {
                MWACreateProfileResponse mWACreateProfileResponse = activationService.createProfileForSelf(this.email, this.password, this.firstName, this.lastName, this.activationKey, string);
                ServiceThreadState serviceThreadState = this.processResponse((MWAResponse)mWACreateProfileResponse);
                this.setStatus(serviceThreadState);
                if (this.getStatus() != ServiceThreadState.SUCCESS) return;
                this.resultLock.lock();
                try {
                    this.verified = mWACreateProfileResponse.getIsVerified();
                    return;
                }
                finally {
                    this.resultLock.unlock();
                }
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
                return;
            }
            finally {
                if (this.isCancelled()) {
                    this.resultLock.lock();
                    try {
                        this.verified = false;
                    }
                    finally {
                        this.resultLock.unlock();
                    }
                } else {
                    this.finish();
                }
            }
        } else {
            this.showConnectionError();
            this.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean getResult() {
        boolean bl;
        this.resultLock.lock();
        try {
            bl = this.verified;
        }
        finally {
            this.resultLock.unlock();
        }
        return bl;
    }
}

