/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.system;

import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.NativeUtility;
import com.mathworks.instutil.system.HostIdProvider;
import java.util.ArrayList;

public final class HostIdProviderImpl
extends NativeUtility
implements HostIdProvider {
    private static final int ETHERNET_ADDRESS_LENGTH = 12;
    private static final int DISK_SERIAL_NUM_LENGTH = 8;
    private final String ethernetAddress;
    private final String ipAddress;
    private final String hostName;
    private final String untrimmedDiskSerialNumber;

    public HostIdProviderImpl(String string) throws JNIException {
        super(string);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        this.getHostId(stringBuffer, stringBuffer2, stringBuffer3, stringBuffer4, stringBuffer5);
        String string2 = stringBuffer.toString().replaceAll("\"", "");
        this.ethernetAddress = HostIdProviderImpl.trim(string2);
        this.untrimmedDiskSerialNumber = HostIdProviderImpl.confirmDiskSerialNumLength(stringBuffer4.toString());
        this.ipAddress = HostIdProviderImpl.trim(stringBuffer2.toString());
        this.hostName = HostIdProviderImpl.trim(stringBuffer3.toString());
    }

    @Override
    public final String getHostName() {
        return this.hostName;
    }

    @Override
    public final String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public final String getEthernetAddress() {
        return this.ethernetAddress;
    }

    @Override
    public String[] getEthernetAddresses() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray = this.getEthernetAddress().split(" ")) {
            if (string.length() == 0) continue;
            StringBuilder stringBuilder = new StringBuilder(string);
            while (stringBuilder.toString().length() < 12) {
                stringBuilder.insert(0, '0');
            }
            arrayList.add(HostIdProviderImpl.trim(stringBuilder.toString()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String getDiskSerialNumber() {
        return HostIdProviderImpl.trim(this.untrimmedDiskSerialNumber);
    }

    @Override
    public String getLockingString() {
        String string = this.getDiskSerialNumber();
        if (null != string && !"".equalsIgnoreCase(string) && !"0".equalsIgnoreCase(string)) {
            return this.untrimmedDiskSerialNumber;
        }
        return this.ethernetAddress;
    }

    private static String trim(String string) {
        String string2;
        int n = string.indexOf(61);
        if (n > -1) {
            int n2 = string.length();
            string2 = string.substring(n + 1, n2);
        } else {
            string2 = string;
        }
        return string2;
    }

    static String confirmDiskSerialNumLength(String string) {
        String[] stringArray = string.split("=");
        if (stringArray.length == 2 && stringArray[1] != null) {
            while (stringArray[1].length() < 8) {
                stringArray[1] = '0' + stringArray[1];
            }
            return stringArray[0] + '=' + stringArray[1];
        }
        return string;
    }

    private native int getHostId(StringBuffer var1, StringBuffer var2, StringBuffer var3, StringBuffer var4, StringBuffer var5);
}

