/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.wizard;

import com.mathworks.instutil.wizard.HyperlinkHandler;
import java.awt.AWTKeyStroke;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import sun.awt.CausedFocusEvent;

public final class JEditorPaneHyperlinkHandler
implements HyperlinkHandler {
    private static final String NEXT_LINK_KEY = "next-link-action";
    private static final String PREVIOUS_LINK_KEY = "previous-link-action";
    private boolean navigating;
    private KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();

    @Override
    public void start(final JEditorPane jEditorPane) {
        this.checkForExceptions(jEditorPane);
        try {
            this.createLinkActions(jEditorPane);
        }
        catch (Exception exception) {
            return;
        }
        jEditorPane.setFocusCycleRoot(false);
        Set<AWTKeyStroke> set = this.keyboardFocusManager.getDefaultFocusTraversalKeys(0);
        Set<AWTKeyStroke> set2 = this.keyboardFocusManager.getDefaultFocusTraversalKeys(1);
        this.addKeyStrokesForTab(set, jEditorPane);
        this.addKeyStrokesForShiftTab(set2, jEditorPane);
        AWTKeyStroke aWTKeyStroke = set.iterator().next();
        final KeyStroke keyStroke = KeyStroke.getKeyStroke(aWTKeyStroke.getKeyCode(), aWTKeyStroke.getModifiers());
        AWTKeyStroke aWTKeyStroke2 = set2.iterator().next();
        final KeyStroke keyStroke2 = KeyStroke.getKeyStroke(aWTKeyStroke2.getKeyCode(), aWTKeyStroke2.getModifiers());
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(10, 0);
        Object object = jEditorPane.getInputMap().get(keyStroke3);
        this.addKeyStrokesForEnter(keyStroke3, object, jEditorPane);
        this.setUpCaretListener(jEditorPane);
        jEditorPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jEditorPane.setFocusTraversalKeysEnabled(false);
                if (focusEvent instanceof CausedFocusEvent) {
                    CausedFocusEvent causedFocusEvent = (CausedFocusEvent)focusEvent;
                    if (causedFocusEvent.getCause().equals((Object)CausedFocusEvent.Cause.TRAVERSAL_FORWARD)) {
                        JEditorPaneHyperlinkHandler.this.navigateToFirstLink(keyStroke, null, jEditorPane);
                    } else if (causedFocusEvent.getCause().equals((Object)CausedFocusEvent.Cause.TRAVERSAL_BACKWARD)) {
                        JEditorPaneHyperlinkHandler.this.navigateToLastLink(keyStroke2, null, jEditorPane);
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    JEditorPaneHyperlinkHandler.this.resetHighlights(null, jEditorPane);
                }
            }
        });
        if (jEditorPane.getBorder() == null) {
            jEditorPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        }
    }

    private void createLinkActions(JComponent jComponent) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName("javax.swing.text.html.HTMLEditorKit$NavigateLinkAction");
        Constructor<?> constructor = clazz.getConstructor(String.class);
        constructor.setAccessible(true);
        Object obj = constructor.newInstance(NEXT_LINK_KEY);
        jComponent.getActionMap().put(NEXT_LINK_KEY, (Action)obj);
        Object obj2 = constructor.newInstance(PREVIOUS_LINK_KEY);
        jComponent.getActionMap().put(PREVIOUS_LINK_KEY, (Action)obj2);
    }

    private void checkForExceptions(JEditorPane jEditorPane) {
        if (jEditorPane == null) {
            throw new IllegalArgumentException("comp cannot be null");
        }
        if (jEditorPane.isEditable()) {
            throw new IllegalArgumentException("JEditorPaneHyperlinkHandler does not support editable JEditorPanes");
        }
        if (!(jEditorPane.getEditorKit() instanceof HTMLEditorKit)) {
            throw new IllegalArgumentException("JEditorPaneHyperlinkHandler only supports JEditorPanes with an HTMLEditorKit");
        }
        if (!jEditorPane.isFocusable()) {
            throw new IllegalArgumentException("JEditorPaneHyperlinkHandler only supports focusable JEditorPanes");
        }
    }

    private void setUpCaretListener(final JTextComponent jTextComponent) {
        CaretListener caretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (!JEditorPaneHyperlinkHandler.this.navigating) {
                    JEditorPaneHyperlinkHandler.this.resetHighlights(caretEvent, jTextComponent);
                }
            }
        };
        jTextComponent.addCaretListener(caretListener);
    }

    private void addKeyStrokesForEnter(KeyStroke keyStroke, Object object, final JEditorPane jEditorPane) {
        final Action action = object == null ? null : jEditorPane.getActionMap().get(object);
        jEditorPane.getInputMap().put(keyStroke, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = JEditorPaneHyperlinkHandler.this.activateHyperlink(actionEvent, jEditorPane);
                if (!bl && action != null) {
                    action.actionPerformed(actionEvent);
                }
            }
        });
    }

    private void addKeyStrokesForShiftTab(Set<AWTKeyStroke> set, final JEditorPane jEditorPane) {
        for (AWTKeyStroke aWTKeyStroke : set) {
            final KeyStroke keyStroke = KeyStroke.getKeyStroke(aWTKeyStroke.getKeyCode(), aWTKeyStroke.getModifiers());
            jEditorPane.getInputMap().put(keyStroke, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JEditorPaneHyperlinkHandler.this.navigateToPreviousLink(keyStroke, actionEvent, jEditorPane);
                }
            });
        }
    }

    private void addKeyStrokesForTab(Set<AWTKeyStroke> set, final JEditorPane jEditorPane) {
        for (AWTKeyStroke aWTKeyStroke : set) {
            final KeyStroke keyStroke = KeyStroke.getKeyStroke(aWTKeyStroke.getKeyCode(), aWTKeyStroke.getModifiers());
            jEditorPane.getInputMap().put(keyStroke, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JEditorPaneHyperlinkHandler.this.navigateToNextLink(keyStroke, actionEvent, jEditorPane);
                }
            });
        }
    }

    private void navigateToFirstLink(KeyStroke keyStroke, ActionEvent actionEvent, JTextComponent jTextComponent) {
        jTextComponent.select(0, 0);
        this.navigateToNextLink(keyStroke, actionEvent, jTextComponent);
    }

    private void navigateToNextLink(KeyStroke keyStroke, ActionEvent actionEvent, JTextComponent jTextComponent) {
        this.resetHighlights(null, jTextComponent);
        this.navigating = true;
        int n = jTextComponent.getSelectionStart();
        int n2 = jTextComponent.getSelectionEnd();
        Action action = jTextComponent.getActionMap().get(NEXT_LINK_KEY);
        if (action != null) {
            action.actionPerformed(actionEvent);
        }
        this.navigating = false;
        if (n == jTextComponent.getSelectionStart() && n2 == jTextComponent.getSelectionEnd()) {
            Container container = this.keyboardFocusManager.getCurrentFocusCycleRoot();
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            if (focusTraversalPolicy != null && jTextComponent.equals(focusTraversalPolicy.getComponentAfter(container, jTextComponent))) {
                if (this.aTagIsValid(jTextComponent)) {
                    this.navigateToFirstLink(keyStroke, actionEvent, jTextComponent);
                }
            } else {
                this.selectAndDispatchEvent(keyStroke, jTextComponent.getDocument().getLength(), jTextComponent);
            }
        }
    }

    private void navigateToPreviousLink(KeyStroke keyStroke, ActionEvent actionEvent, JTextComponent jTextComponent) {
        this.resetHighlights(null, jTextComponent);
        this.navigating = true;
        int n = jTextComponent.getSelectionStart();
        int n2 = jTextComponent.getSelectionEnd();
        boolean bl = false;
        HTMLDocument.Iterator iterator = ((HTMLDocument)jTextComponent.getDocument()).getIterator(HTML.Tag.A);
        if (iterator.isValid() && n < iterator.getStartOffset()) {
            bl = true;
        }
        Action action = jTextComponent.getActionMap().get(PREVIOUS_LINK_KEY);
        if (!bl && action != null) {
            action.actionPerformed(actionEvent);
        }
        this.navigating = false;
        if (n == jTextComponent.getSelectionStart() && n2 == jTextComponent.getSelectionEnd()) {
            Container container = this.keyboardFocusManager.getCurrentFocusCycleRoot();
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            if (focusTraversalPolicy != null && jTextComponent.equals(focusTraversalPolicy.getComponentBefore(container, jTextComponent))) {
                if (this.aTagIsValid(jTextComponent)) {
                    this.navigateToLastLink(keyStroke, actionEvent, jTextComponent);
                }
            } else {
                this.selectAndDispatchEvent(keyStroke, 0, jTextComponent);
            }
        }
    }

    private boolean aTagIsValid(JTextComponent jTextComponent) {
        return ((HTMLDocument)jTextComponent.getDocument()).getIterator(HTML.Tag.A).isValid();
    }

    private void navigateToLastLink(KeyStroke keyStroke, ActionEvent actionEvent, JTextComponent jTextComponent) {
        int n = jTextComponent.getDocument().getLength();
        jTextComponent.select(n, n);
        this.navigateToPreviousLink(keyStroke, actionEvent, jTextComponent);
    }

    private void selectAndDispatchEvent(KeyStroke keyStroke, int n, JTextComponent jTextComponent) {
        jTextComponent.select(n, n);
        jTextComponent.setFocusTraversalKeysEnabled(true);
        this.keyboardFocusManager.dispatchEvent(new KeyEvent(jTextComponent, 401, new Date().getTime(), keyStroke.getModifiers(), keyStroke.getKeyCode(), keyStroke.getKeyChar()));
    }

    private boolean activateHyperlink(ActionEvent actionEvent, JEditorPane jEditorPane) {
        boolean bl = false;
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
        int n = jEditorPane.getSelectionStart();
        while (iterator.isValid() && !bl) {
            AttributeSet attributeSet = iterator.getAttributes();
            int n2 = iterator.getStartOffset();
            if (n == n2) {
                Object object = attributeSet.getAttribute(HTML.Attribute.HREF);
                if (object != null) {
                    URL uRL = null;
                    String string = null;
                    try {
                        uRL = new URL(object.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        string = object.toString();
                    }
                    jEditorPane.fireHyperlinkUpdate(new HyperlinkEvent(actionEvent, HyperlinkEvent.EventType.ACTIVATED, uRL, string));
                }
                bl = true;
            }
            iterator.next();
        }
        return bl;
    }

    private void resetHighlights(CaretEvent caretEvent, JTextComponent jTextComponent) {
        Highlighter.Highlight[] highlightArray;
        for (Highlighter.Highlight highlight : highlightArray = jTextComponent.getHighlighter().getHighlights()) {
            try {
                if (caretEvent != null && (highlight.getStartOffset() == caretEvent.getDot() || highlight.getEndOffset() == caretEvent.getDot()) && (highlight.getStartOffset() == caretEvent.getMark() || highlight.getEndOffset() == caretEvent.getMark())) continue;
                jTextComponent.getHighlighter().changeHighlight(highlight, 1, 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        jTextComponent.repaint();
    }
}

