/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.event.Tree4Deltas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionList<S>
extends TransformedList<S, S> {
    public static final Policy PREFER_TARGET_CHANGES = new PreferTargetChangesPolicy();
    public static final Policy PREFER_SOURCE_CHANGES = new PreferSourceChangesPolicy();
    private final Tree4Deltas<S> deltas = new Tree4Deltas();
    private boolean txStarted = false;
    private final Policy<S> policy;

    public TransactionList(EventList<S> source) {
        this(source, PREFER_TARGET_CHANGES);
    }

    public TransactionList(EventList<S> source, Policy<S> policy) {
        super(source);
        this.policy = policy;
        this.deltas.horribleHackPreferMostRecentValue = true;
        this.deltas.reset(source.size());
        source.addListEventListener(this);
    }

    public void begin() {
        if (this.txStarted) {
            throw new IllegalStateException("Cannot begin() another transaction before committing or rolling back the current transaction");
        }
        this.deltas.reset(this.source.size());
        this.txStarted = true;
    }

    public void commit() {
        if (!this.txStarted) {
            throw new IllegalStateException("Cannot commit() a transaction that does not exist. Please call begin() to start a transaction first.");
        }
        new EventListTransactionHack().runAsTransaction(new HackRunnable(), this.source);
    }

    public void rollback() {
        if (!this.txStarted) {
            throw new IllegalStateException("Cannot rollback() a transaction that does not exist. Please call begin() to start a transaction first.");
        }
        this.txStarted = false;
        this.deltas.reset(this.source.size());
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void listChanged(ListEvent<S> listChanges) {
        this.updates.beginEvent(true);
        while (listChanges.next()) {
            Object sourceValue;
            S targetValue;
            int targetIndex;
            byte targetChangeType;
            int sourceChangeType = listChanges.getType();
            int sourceIndex = listChanges.getIndex();
            if (sourceChangeType == 2) {
                this.deltas.sourceInsert(sourceIndex);
                this.updates.addInsert(this.deltas.sourceToTarget(sourceIndex));
                continue;
            }
            if (sourceChangeType == 1) {
                targetChangeType = this.deltas.getChangeType(sourceIndex);
                if (targetChangeType == Tree4Deltas.INSERT) {
                    throw new IllegalStateException("Unexpected target type: insert over top of update");
                }
                if (targetChangeType == Tree4Deltas.UPDATE) {
                    targetIndex = this.deltas.sourceToTarget(sourceIndex);
                    targetValue = this.deltas.getTargetValue(targetIndex);
                    sourceValue = this.source.get(sourceIndex);
                    S resolvedValue = this.policy.sourceUpdatedTargetUpdated(sourceValue, targetValue);
                    if (resolvedValue == sourceValue) {
                        this.deltas.sourceRevert(sourceIndex);
                        this.updates.elementUpdated(targetIndex, targetValue);
                        continue;
                    }
                    if (resolvedValue == targetValue) continue;
                    this.deltas.targetUpdate(targetIndex, targetIndex + 1, resolvedValue, ListEvent.UNKNOWN_VALUE);
                    this.updates.elementUpdated(targetIndex, targetValue);
                    continue;
                }
                if (targetChangeType == Tree4Deltas.DELETE) {
                    S deletedFromTarget = this.deltas.getSourceValue(sourceIndex);
                    Object updatedFromSource = this.source.get(sourceIndex);
                    Policy.Result policyResult = this.policy.sourceUpdatedTargetDeleted(updatedFromSource, deletedFromTarget);
                    if (policyResult == Policy.KEEP_SOURCE) {
                        this.deltas.sourceRevert(sourceIndex);
                        this.updates.addInsert(this.deltas.sourceToTarget(sourceIndex));
                        continue;
                    }
                    if (policyResult != Policy.KEEP_TARGET) continue;
                    this.deltas.sourceRevert(sourceIndex);
                    int targetIndex2 = this.deltas.sourceToTarget(sourceIndex);
                    this.deltas.targetDelete(targetIndex2, targetIndex2 + 1, updatedFromSource);
                    continue;
                }
                if (targetChangeType != Tree4Deltas.NO_CHANGE) continue;
                this.updates.elementUpdated(this.deltas.sourceToTarget(sourceIndex), listChanges.getOldValue());
                continue;
            }
            if (sourceChangeType != 0) continue;
            targetChangeType = this.deltas.getChangeType(sourceIndex);
            if (targetChangeType == Tree4Deltas.INSERT) {
                throw new IllegalStateException("Unexpected target type: insert over top of delete");
            }
            if (targetChangeType == Tree4Deltas.UPDATE) {
                targetIndex = this.deltas.sourceToTarget(sourceIndex);
                targetValue = this.deltas.getTargetValue(targetIndex);
                sourceValue = listChanges.getOldValue();
                Policy.Result policyResult = this.policy.sourceDeletedTargetUpdated(sourceValue, targetValue);
                if (policyResult == Policy.KEEP_SOURCE) {
                    this.deltas.sourceDelete(sourceIndex);
                    this.updates.elementDeleted(targetIndex, targetValue);
                    continue;
                }
                if (policyResult != Policy.KEEP_TARGET) continue;
                this.deltas.sourceDelete(sourceIndex);
                this.deltas.targetInsert(targetIndex, targetIndex + 1, targetValue);
                continue;
            }
            if (targetChangeType == Tree4Deltas.DELETE) {
                this.deltas.sourceDelete(sourceIndex);
                continue;
            }
            if (targetChangeType != Tree4Deltas.NO_CHANGE) continue;
            this.updates.elementDeleted(this.deltas.sourceToTarget(sourceIndex), listChanges.getOldValue());
            this.deltas.sourceDelete(sourceIndex);
        }
        this.updates.commitEvent();
    }

    @Override
    public void add(int index, S element) {
        if (this.txStarted) {
            this.updates.beginEvent();
            this.updates.elementInserted(index, element);
            this.deltas.targetInsert(index, index + 1, element);
            this.updates.commitEvent();
        } else {
            super.add(index, element);
        }
    }

    @Override
    public S remove(int index) {
        if (this.txStarted) {
            this.updates.beginEvent();
            S value = this.get(index);
            this.deltas.targetDelete(index, index + 1, value);
            this.updates.elementDeleted(index, value);
            this.updates.commitEvent();
            return value;
        }
        return (S)super.remove(index);
    }

    @Override
    public S set(int index, S element) {
        if (this.txStarted) {
            this.updates.beginEvent();
            S value = this.get(index);
            this.deltas.targetUpdate(index, index + 1, element, ListEvent.UNKNOWN_VALUE);
            this.updates.elementUpdated(index, value, ListEvent.UNKNOWN_VALUE);
            this.updates.commitEvent();
            return value;
        }
        return super.set(index, element);
    }

    @Override
    public S get(int index) {
        S targetValue = this.deltas.getTargetValue(index);
        if (targetValue == ListEvent.UNKNOWN_VALUE) {
            return (S)this.source.get(this.deltas.targetToSource(index));
        }
        return targetValue;
    }

    @Override
    public int size() {
        return this.deltas.targetSize();
    }

    private static class PreferTargetChangesPolicy
    implements Policy {
        private PreferTargetChangesPolicy() {
        }

        public Policy.Result sourceDeletedTargetUpdated(Object deletedFromSource, Object updatedFromTarget) {
            return KEEP_TARGET;
        }

        public Policy.Result sourceUpdatedTargetDeleted(Object updatedFromSource, Object deletedFromTarget) {
            return KEEP_TARGET;
        }

        public Object sourceUpdatedTargetUpdated(Object updatedFromSource, Object updatedFromTarget) {
            return updatedFromTarget;
        }
    }

    private static class PreferSourceChangesPolicy
    implements Policy {
        private PreferSourceChangesPolicy() {
        }

        public Policy.Result sourceDeletedTargetUpdated(Object deletedFromSource, Object updatedFromTarget) {
            return KEEP_SOURCE;
        }

        public Policy.Result sourceUpdatedTargetDeleted(Object updatedFromSource, Object deletedFromTarget) {
            return KEEP_SOURCE;
        }

        public Object sourceUpdatedTargetUpdated(Object updatedFromSource, Object updatedFromTarget) {
            return updatedFromSource;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Policy<S> {
        public static final Result KEEP_SOURCE = new Result();
        public static final Result KEEP_TARGET = new Result();

        public Result sourceDeletedTargetUpdated(S var1, S var2);

        public Result sourceUpdatedTargetDeleted(S var1, S var2);

        public S sourceUpdatedTargetUpdated(S var1, S var2);

        public static class Result {
            private Result() {
            }
        }
    }

    private static final class EventListTransactionHack {
        private EventListTransactionHack() {
        }

        public void runAsTransaction(Runnable task, EventList eventList) {
            BasicEventList<String> list = new BasicEventList<String>(eventList.getPublisher(), eventList.getReadWriteLock());
            ListEventListenerHack listener = new ListEventListenerHack(task);
            list.addListEventListener(listener);
            list.add("A");
            list.removeListEventListener(listener);
        }

        private static final class ListEventListenerHack
        implements ListEventListener {
            private final Runnable task;

            public ListEventListenerHack(Runnable task) {
                this.task = task;
            }

            public void listChanged(ListEvent listChanges) {
                this.task.run();
            }
        }
    }

    private final class HackRunnable
    implements Runnable {
        private HackRunnable() {
        }

        public void run() {
            TransactionList.this.updates.beginEvent(true);
            Tree4Deltas.Iterator i = TransactionList.this.deltas.iterator();
            while (i.hasNext()) {
                i.next();
                int index = i.getIndex();
                int type = i.getType();
                if (type == 2) {
                    TransactionList.this.updates.elementDeleted(index, TransactionList.this.deltas.getTargetValue(index));
                    continue;
                }
                if (type == 1) {
                    TransactionList.this.updates.elementUpdated(index, TransactionList.this.deltas.getTargetValue(index));
                    continue;
                }
                if (type != 0) continue;
                TransactionList.this.updates.addInsert(index);
            }
            TransactionList.this.updates.commitEvent();
            int sourceSizeBeforeChanges = TransactionList.this.source.size();
            Tree4Deltas.Iterator i2 = TransactionList.this.deltas.iterator();
            while (i2.hasNext()) {
                i2.next();
                int index = i2.getIndex();
                int type = i2.getType();
                if (type == 2) {
                    TransactionList.this.source.add(index, i2.getOldValue());
                    continue;
                }
                if (type == 1) {
                    TransactionList.this.source.set(index, i2.getOldValue());
                    continue;
                }
                if (type != 0) continue;
                TransactionList.this.source.remove(index);
            }
            TransactionList.this.txStarted = false;
            TransactionList.this.deltas.reset(sourceSizeBeforeChanges);
        }
    }
}

