/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.hibernate;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.hibernate.EventListFactory;
import ca.odell.glazedlists.util.concurrent.LockFactory;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.HashMap;
import java.util.Map;

final class CategoryEventListFactory
implements EventListFactory {
    private static final Map<String, ListInfo> CATEGORY_MAP = new HashMap<String, ListInfo>();
    private String category;

    public CategoryEventListFactory(String category) {
        this.setCategory(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCategory(String newCategory) {
        if (newCategory == null) {
            throw new IllegalArgumentException("Category must not be null");
        }
        this.category = newCategory;
        Map<String, ListInfo> map = CATEGORY_MAP;
        synchronized (map) {
            if (!CATEGORY_MAP.containsKey(this.category)) {
                CATEGORY_MAP.put(this.category, new ListInfo());
            }
        }
    }

    public String getCategory() {
        return this.category;
    }

    public EventList createEventList() {
        ListInfo info = this.getListInfo();
        return new BasicEventList(info.publisher, info.lock);
    }

    public EventList createEventList(int initalCapacity) {
        ListInfo info = this.getListInfo();
        return new BasicEventList(initalCapacity, info.publisher, info.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListInfo getListInfo() {
        Map<String, ListInfo> map = CATEGORY_MAP;
        synchronized (map) {
            return CATEGORY_MAP.get(this.getCategory());
        }
    }

    private static class ListInfo {
        public ReadWriteLock lock = LockFactory.DEFAULT.createReadWriteLock();
        public ListEventPublisher publisher = ListEventAssembler.createListEventPublisher();

        ListInfo() {
        }
    }
}

