/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.GroupingList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupingListMultiMap<K, V>
implements Map<Comparable<K>, List<V>>,
ListEventListener<List<V>> {
    private final GroupingList<V> groupingList;
    private final FunctionList<List<V>, List<V>> valueList;
    private final List<Comparable<K>> keyList;
    private Set<Comparable<K>> keySet;
    private final FunctionList.Function<V, ? extends Comparable<K>> keyFunction;
    private final Map<Comparable<K>, List<V>> delegate;
    private Set<Map.Entry<Comparable<K>, List<V>>> entrySet;

    public GroupingListMultiMap(EventList<V> source, FunctionList.Function<V, ? extends Comparable<K>> keyFunction) {
        this.keyFunction = keyFunction;
        this.groupingList = new GroupingList<V>(source, new FunctionComparator<V, K>(keyFunction));
        this.valueList = new FunctionList(this.groupingList, new ValueListFunction());
        this.valueList.addListEventListener(this);
        this.keyList = new BasicEventList<Comparable<K>>(this.groupingList.size());
        this.delegate = new HashMap<Comparable<K>, List<V>>(this.groupingList.size());
        for (List value : this.valueList) {
            Comparable<K> key = this.key((V)value);
            this.keyList.add(key);
            this.delegate.put(key, value);
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public List<V> get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public List<V> put(Comparable<K> key, List<V> value) {
        this.checkKeyValueAgreement(key, (V)value);
        Object removed = this.remove(key);
        this.groupingList.add(value);
        return removed;
    }

    @Override
    public void putAll(Map<? extends Comparable<K>, ? extends List<V>> m) {
        for (Map.Entry<Comparable<K>, List<V>> entry : m.entrySet()) {
            Comparable<K> key = entry.getKey();
            List<V> value = entry.getValue();
            this.checkKeyValueAgreement(key, (V)value);
        }
        Iterator<Object> i = m.keySet().iterator();
        while (i.hasNext()) {
            this.remove(i.next());
        }
        this.groupingList.addAll(m.values());
    }

    private void checkKeyValueAgreement(Comparable<K> key, Collection<? extends V> value) {
        Iterator<V> i = value.iterator();
        while (i.hasNext()) {
            this.checkKeyValueAgreement(key, i.next());
        }
    }

    private void checkKeyValueAgreement(Comparable<K> key, V value) {
        Comparable<K> k = this.key(value);
        if (!GlazedListsImpl.equal(key, k)) {
            throw new IllegalArgumentException("The calculated key for the given value (" + k + ") does not match the given key (" + key + ")");
        }
    }

    @Override
    public void clear() {
        this.groupingList.clear();
    }

    @Override
    public List<V> remove(Object key) {
        int index = this.keyList.indexOf(key);
        return index == -1 ? null : this.groupingList.remove(index);
    }

    @Override
    public Collection<List<V>> values() {
        return this.groupingList;
    }

    @Override
    public Set<Comparable<K>> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Comparable<K>, List<V>>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.delegate).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    @Override
    public void listChanged(ListEvent<List<V>> listChanges) {
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                List inserted = (List)listChanges.getSourceList().get(changeIndex);
                Comparable<K> key = this.key((V)inserted);
                this.keyList.add(changeIndex, key);
                this.delegate.put(key, inserted);
                continue;
            }
            if (changeType != 0) continue;
            Comparable<K> deleted = this.keyList.remove(changeIndex);
            this.delegate.remove(deleted);
        }
    }

    private Comparable<K> key(List<V> values) {
        return this.key(values.get(0));
    }

    private Comparable<K> key(V value) {
        return this.keyFunction.evaluate(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueList
    implements List<V> {
        private final List<V> delegate;
        private final Comparable<K> key;

        public ValueList(List<V> delegate) {
            this.delegate = delegate;
            this.key = GroupingListMultiMap.this.key(delegate.get(0));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<V> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean add(V o) {
            GroupingListMultiMap.this.checkKeyValueAgreement(this.key, o);
            return this.delegate.add(o);
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            GroupingListMultiMap.this.checkKeyValueAgreement((Comparable)this.key, (Object)c);
            return this.delegate.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> c) {
            GroupingListMultiMap.this.checkKeyValueAgreement((Comparable)this.key, (Object)c);
            return this.delegate.addAll(index, c);
        }

        @Override
        public void add(int index, V element) {
            GroupingListMultiMap.this.checkKeyValueAgreement(this.key, element);
            this.delegate.add(index, element);
        }

        @Override
        public V set(int index, V element) {
            GroupingListMultiMap.this.checkKeyValueAgreement(this.key, element);
            return this.delegate.set(index, element);
        }

        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            return new ValueList(this.delegate.subList(fromIndex, toIndex));
        }

        @Override
        public ListIterator<V> listIterator() {
            return new ValueListIterator(this.delegate.listIterator());
        }

        @Override
        public ListIterator<V> listIterator(int index) {
            return new ValueListIterator(this.delegate.listIterator(index));
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegate.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.delegate.retainAll(c);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.delegate).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }

        @Override
        public V get(int index) {
            return this.delegate.get(index);
        }

        @Override
        public V remove(int index) {
            return this.delegate.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.delegate.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegate.lastIndexOf(o);
        }

        public String toString() {
            return this.delegate.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ValueListIterator
        implements ListIterator<V> {
            private final ListIterator<V> delegate;

            public ValueListIterator(ListIterator<V> delegate) {
                this.delegate = delegate;
            }

            @Override
            public void set(V o) {
                GroupingListMultiMap.this.checkKeyValueAgreement(ValueList.this.key, o);
                this.delegate.set(o);
            }

            @Override
            public void add(V o) {
                GroupingListMultiMap.this.checkKeyValueAgreement(ValueList.this.key, o);
                this.delegate.add(o);
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public V next() {
                return this.delegate.next();
            }

            @Override
            public boolean hasPrevious() {
                return this.delegate.hasPrevious();
            }

            @Override
            public V previous() {
                return this.delegate.previous();
            }

            @Override
            public int nextIndex() {
                return this.delegate.nextIndex();
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }

            @Override
            public int previousIndex() {
                return this.delegate.previousIndex();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueListFunction
    implements FunctionList.Function<List<V>, List<V>> {
        private ValueListFunction() {
        }

        @Override
        public List<V> evaluate(List<V> sourceValue) {
            return new ValueList(sourceValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunctionComparator<V, K>
    implements Comparator<V> {
        private final Comparator<Comparable> delegate = GlazedLists.comparableComparator();
        private final FunctionList.Function<V, ? extends Comparable<K>> function;

        FunctionComparator(FunctionList.Function<V, ? extends Comparable<K>> function) {
            if (function == null) {
                throw new IllegalArgumentException("function may not be null");
            }
            this.function = function;
        }

        @Override
        public int compare(V o1, V o2) {
            Comparable<K> c1 = this.function.evaluate(o1);
            Comparable<K> c2 = this.function.evaluate(o2);
            return this.delegate.compare(c1, c2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySetIterator
    implements Iterator<Comparable<K>> {
        private final ListIterator<Comparable<K>> keyIter;

        KeySetIterator(ListIterator<Comparable<K>> keyIter) {
            this.keyIter = keyIter;
        }

        @Override
        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        @Override
        public Comparable<K> next() {
            return this.keyIter.next();
        }

        @Override
        public void remove() {
            int index = this.keyIter.previousIndex();
            if (index == -1) {
                throw new IllegalStateException("Cannot remove() without a prior call to next()");
            }
            GroupingListMultiMap.this.groupingList.remove(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<Comparable<K>> {
        private KeySet() {
        }

        @Override
        public int size() {
            return GroupingListMultiMap.this.keyList.size();
        }

        @Override
        public Iterator<Comparable<K>> iterator() {
            return new KeySetIterator(GroupingListMultiMap.this.keyList.listIterator());
        }

        @Override
        public boolean contains(Object o) {
            return GroupingListMultiMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return GroupingListMultiMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            GroupingListMultiMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiMapEntry
    implements Map.Entry<Comparable<K>, List<V>> {
        private final Comparable<K> key;
        private List<V> value;

        MultiMapEntry(Comparable<K> key, List<V> value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            this.value = value;
            this.key = key;
        }

        @Override
        public Comparable<K> getKey() {
            return this.key;
        }

        @Override
        public List<V> getValue() {
            return this.value;
        }

        @Override
        public List<V> setValue(List<V> newValue) {
            GroupingListMultiMap.this.checkKeyValueAgreement((Comparable)((Comparable)this.getKey()), (Object)newValue);
            ArrayList oldValue = new ArrayList(this.value);
            this.value.addAll(newValue);
            this.value.removeAll(oldValue);
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            boolean keysEqual = GlazedListsImpl.equal(this.getKey(), e.getKey());
            return keysEqual && GlazedListsImpl.equal(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ ((Object)this.value).hashCode();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySetIterator
    implements Iterator<Map.Entry<Comparable<K>, List<V>>> {
        private final ListIterator<Comparable<K>> keyIter;

        EntrySetIterator(ListIterator<Comparable<K>> keyIter) {
            this.keyIter = keyIter;
        }

        @Override
        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        @Override
        public Map.Entry<Comparable<K>, List<V>> next() {
            Comparable key = this.keyIter.next();
            return new MultiMapEntry(key, GroupingListMultiMap.this.get(key));
        }

        @Override
        public void remove() {
            int index = this.keyIter.previousIndex();
            if (index == -1) {
                throw new IllegalStateException("Cannot remove() without a prior call to next()");
            }
            GroupingListMultiMap.this.groupingList.remove(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<Comparable<K>, List<V>>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return GroupingListMultiMap.this.keyList.size();
        }

        @Override
        public Iterator<Map.Entry<Comparable<K>, List<V>>> iterator() {
            return new EntrySetIterator(GroupingListMultiMap.this.keyList.listIterator());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Comparable key = (Comparable)e.getKey();
            List value = (List)e.getValue();
            Object mapValue = GroupingListMultiMap.this.get(key);
            return GlazedListsImpl.equal(value, mapValue);
        }

        @Override
        public boolean remove(Object o) {
            if (!this.contains(o)) {
                return false;
            }
            GroupingListMultiMap.this.remove(((Map.Entry)o).getKey());
            return true;
        }

        @Override
        public void clear() {
            GroupingListMultiMap.this.clear();
        }
    }
}

