/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ItemSafetyListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PropertySafetyListener;
import com.mathworks.mwswing.WeakPropertyChangeCoupler;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;

public class MJCheckBox
extends JCheckBox {
    protected boolean fAutoMnemonicEnabled = true;
    protected String fOriginalString = "";
    private PropertyChangeListener fActionPropertyHandler;
    private ItemListener fSelectionSafetyListener;
    protected static final String BASE_NAME = "CheckBox";

    public MJCheckBox() {
        this.setText("");
        this.addSafetyListeners();
    }

    public MJCheckBox(Action action) {
        this.setAction(action);
        this.addSafetyListeners();
    }

    public MJCheckBox(Icon icon) {
        super(icon);
        this.setText("");
        this.addSafetyListeners();
    }

    public MJCheckBox(Icon icon, boolean bl) {
        super(icon, bl);
        this.setText("");
        this.addSafetyListeners();
    }

    public MJCheckBox(String string) {
        this.setText(string);
        this.addSafetyListeners();
    }

    public MJCheckBox(String string, boolean bl) {
        super(string, bl);
        this.setText(string);
        this.addSafetyListeners();
    }

    public MJCheckBox(String string, Icon icon) {
        super(icon);
        this.setText(string);
        this.addSafetyListeners();
    }

    public MJCheckBox(String string, Icon icon, boolean bl) {
        super(icon, bl);
        this.setText(string);
        this.addSafetyListeners();
    }

    @Override
    public Color getForeground() {
        return PlatformInfo.isWindowsModernAppearance() && !this.isEnabled() ? UIManager.getColor("CheckBox.foreground") : super.getForeground();
    }

    private void addSafetyListeners() {
        if (MJUtilities.threadingChecksEnabled()) {
            this.fSelectionSafetyListener = new ItemSafetyListener(this);
            this.getModel().addItemListener(this.fSelectionSafetyListener);
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    @Override
    public void setText(String string) {
        this.fOriginalString = string;
        if (!this.fAutoMnemonicEnabled) {
            super.setText(string);
            return;
        }
        if (string == null) {
            super.setText(null);
            this.setMnemonic('\u0000');
            return;
        }
        super.setText(MJUtilities.exciseAmpersand(string));
        MJUtilities.setMnemonicFromText(this, string);
    }

    public void setAutoMnemonicEnabled(boolean bl) {
        this.fAutoMnemonicEnabled = bl;
        this.setText(this.fOriginalString);
    }

    public boolean isAutoMnemonicEnabled() {
        return this.fAutoMnemonicEnabled;
    }

    @Override
    public void setAction(Action action) {
        String string;
        Action action2 = this.getAction();
        if (action2 != null) {
            WeakPropertyChangeCoupler.detach(action2, this.fActionPropertyHandler);
        }
        if (action2 instanceof MJAbstractAction) {
            this.removeItemListener((ItemListener)((Object)action2));
        }
        super.setAction(action);
        if (action == null) {
            if (action2 instanceof MJAbstractAction) {
                this.setName(BASE_NAME);
            }
            return;
        }
        if (this.fActionPropertyHandler == null) {
            this.fActionPropertyHandler = new ActionPropertyHandler();
        }
        WeakPropertyChangeCoupler.attach(action, this.fActionPropertyHandler);
        Integer n = (Integer)action.getValue("MnemonicIndex");
        if (n != null) {
            this.setDisplayedMnemonicIndex(n);
        }
        if ((string = (String)action.getValue("ComponentName")) != null) {
            this.setName(string + BASE_NAME);
        }
        if (action instanceof MJAbstractAction) {
            this.setSelected(((MJAbstractAction)action).isSelected());
            this.addItemListener((ItemListener)((Object)action));
        }
    }

    @Override
    public void setModel(ButtonModel buttonModel) {
        if (this.fSelectionSafetyListener != null) {
            ButtonModel buttonModel2 = this.getModel();
            buttonModel2.removeItemListener(this.fSelectionSafetyListener);
            buttonModel.addItemListener(this.fSelectionSafetyListener);
        }
        super.setModel(buttonModel);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = this.isEnabled() && PlatformInfo.isMacintosh() && mouseEvent.isPopupTrigger();
        if (bl) {
            this.setEnabled(false);
        }
        super.processMouseEvent(mouseEvent);
        if (bl) {
            this.setEnabled(true);
        }
    }

    class ActionPropertyHandler
    implements PropertyChangeListener {
        ActionPropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("checked")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                MJCheckBox.this.setSelected(bl);
            }
        }
    }
}

