/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

class RestrictedFileSystemView
extends FileSystemView {
    private static final String newFolderString = UIManager.getString("FileChooser.other.newFolder");
    private File _defaultDirectory;

    public RestrictedFileSystemView() {
        this(null);
    }

    public RestrictedFileSystemView(File file) {
        this._defaultDirectory = file;
    }

    @Override
    public boolean isRoot(File file) {
        if (file == null || !file.isAbsolute()) {
            return false;
        }
        File[] fileArray = this.getRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].equals(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean isTraversable(File file) {
        return file.isDirectory();
    }

    @Override
    public String getSystemDisplayName(File file) {
        String string = null;
        if (file != null) {
            string = this.isRoot(file) ? file.getAbsolutePath() : file.getName();
        }
        return string;
    }

    @Override
    public String getSystemTypeDescription(File file) {
        return null;
    }

    @Override
    public Icon getSystemIcon(File file) {
        if (file != null) {
            return UIManager.getIcon(file.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
        }
        return null;
    }

    @Override
    public boolean isParent(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        return file.equals(file2.getParentFile());
    }

    @Override
    public File getChild(File file, String string) {
        return this.createFileObject(file, string);
    }

    @Override
    public boolean isFileSystem(File file) {
        return true;
    }

    @Override
    public boolean isHiddenFile(File file) {
        return file.isHidden();
    }

    @Override
    public boolean isFileSystemRoot(File file) {
        return this.isRoot(file);
    }

    @Override
    public boolean isDrive(File file) {
        return false;
    }

    @Override
    public boolean isFloppyDrive(File file) {
        return false;
    }

    @Override
    public boolean isComputerNode(File file) {
        return false;
    }

    @Override
    public File[] getRoots() {
        return File.listRoots();
    }

    @Override
    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    @Override
    public File getDefaultDirectory() {
        if (this._defaultDirectory == null) {
            try {
                File file = File.createTempFile("filesystemview", "restricted");
                file.deleteOnExit();
                this._defaultDirectory = file.getParentFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this._defaultDirectory;
    }

    @Override
    public File createFileObject(File file, String string) {
        if (file == null) {
            return new File(string);
        }
        return new File(file, string);
    }

    @Override
    public File createFileObject(String string) {
        File file = new File(string);
        if (this.isFileSystemRoot(file)) {
            file = this.createFileSystemRoot(file);
        }
        return file;
    }

    @Override
    public File[] getFiles(File file, boolean bl) {
        Vector<File> vector = new Vector<File>();
        File[] fileArray = file.listFiles();
        int n = fileArray == null ? 0 : fileArray.length;
        for (int i = 0; i < n && !Thread.currentThread().isInterrupted(); ++i) {
            File file2 = fileArray[i];
            if (bl && this.isHiddenFile(file2)) continue;
            vector.addElement(file2);
        }
        return vector.toArray(new File[vector.size()]);
    }

    @Override
    public File getParentDirectory(File file) {
        File file2;
        if (file != null && file.exists() && (file2 = file.getParentFile()) != null) {
            if (this.isFileSystem(file2)) {
                File file3;
                File file4 = file2;
                if (!(file4 == null || file4.exists() || (file3 = file2.getParentFile()) != null && this.isFileSystem(file3))) {
                    file4 = this.createFileSystemRoot(file4);
                }
                return file4;
            }
            return file2;
        }
        return null;
    }

    @Override
    protected File createFileSystemRoot(File file) {
        return new FileSystemRoot(file);
    }

    @Override
    public File createNewFolder(File file) throws IOException {
        if (file == null) {
            throw new IOException("Containing directory is null:");
        }
        File file2 = null;
        file2 = this.createFileObject(file, newFolderString);
        for (int i = 2; file2.exists() && i < 100; ++i) {
            file2 = this.createFileObject(file, MessageFormat.format(newFolderString, new Integer(i)));
        }
        if (file2.exists()) {
            throw new IOException("Directory already exists:" + file2.getAbsolutePath());
        }
        file2.mkdirs();
        return file2;
    }

    static class FileSystemRoot
    extends File {
        public FileSystemRoot(File file) {
            super(file, "");
        }

        public FileSystemRoot(String string) {
            super(string);
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public String getName() {
            return this.getPath();
        }
    }
}

