/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.IconSet;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MPopup;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.AWTEventListenerProxy;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventListenerProxy;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ScrollablePopupList
extends MJList {
    private MJScrollPane fScrolledList;
    private Component fInvoker;
    private MPopup fPopup;
    private PopupDismisser fPopupDismisser;
    private KeyDispatcher fKeyDispatcher;
    private AWTEventListener fSavedMouseGrabber;
    private long fSavedGrabberMask;
    private AWTEventListener fMouseGrabber;
    private Window fInvokerWindow;
    private static final int SCROLL_THRESHOLD = 20;
    private static final int BASIC_ITEM = 1;
    private static final int CHECKBOX_ITEM = 2;
    private static final int RADIOBUTTON_ITEM = 3;
    private Point fDisplayAreaLocation = new Point(0, 0);

    public ScrollablePopupList() {
        super((ListModel)new DefaultListModel());
        this.setSelectionMode(0);
        this.fScrolledList = new MJScrollPane(this);
        this.fScrolledList.setHorizontalScrollBarPolicy(31);
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ScrollablePopupList.this.highlightItem(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                ScrollablePopupList.this.highlightItem(mouseEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    ScrollablePopupList.this.fireAction(ScrollablePopupList.this.getSelectedIndex());
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ScrollablePopupList.this.clearSelection();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ScrollablePopupList.this.highlightItem(mouseEvent);
            }
        });
        this.setCellRenderer(new MenuRenderer());
        this.setVisibleRowCount(20);
    }

    public ScrollablePopupList(Action[] actionArray) {
        this();
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        for (Action action : actionArray) {
            ItemData itemData = new ItemData();
            itemData.iAction = action;
            defaultListModel.addElement(itemData);
        }
    }

    public void addItem(Action action) {
        ItemData itemData = new ItemData();
        itemData.iAction = action;
        ((DefaultListModel)this.getModel()).addElement(itemData);
    }

    public void addCheckBoxItem(Action action) {
        ItemData itemData = new ItemData();
        itemData.iAction = action;
        itemData.iType = 2;
        ((DefaultListModel)this.getModel()).addElement(itemData);
    }

    public void addRadioButtonItem(Action action) {
        ItemData itemData = new ItemData();
        itemData.iAction = action;
        itemData.iType = 3;
        ((DefaultListModel)this.getModel()).addElement(itemData);
    }

    public void addSeparator() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        ItemData itemData = (ItemData)defaultListModel.lastElement();
        if (itemData != null) {
            itemData.iAppendSeparator = true;
        }
    }

    public void removeSeparator() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        ItemData itemData = (ItemData)defaultListModel.lastElement();
        if (itemData != null) {
            itemData.iAppendSeparator = false;
        }
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(PopupMenuListener.class, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(PopupMenuListener.class, popupMenuListener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(PopupMenuListener.class);
    }

    public void showPopup(Component component, int n, int n2) {
        Border border = UIManager.getBorder("PopupMenu.border");
        if (border != null) {
            this.fScrolledList.setBorder(border);
        }
        Point point = WindowUtils.getPopupLocation(component, this.fScrolledList.getPreferredSize(), new Point(n, n2));
        this.setDisplayAreaLocation(point);
        this.fInvoker = component;
        this.fPopup = MPopup.getPopup(component, this.fScrolledList, point.x, point.y);
        this.firePopupMenuWillBecomeVisible();
        this.fInvokerWindow = SwingUtilities.windowForComponent(component);
        Window window = SwingUtilities.windowForComponent(this);
        if (window != null && window != this.fInvokerWindow) {
            window.setFocusableWindowState(!PlatformInfo.isMacintosh());
        }
        this.fPopup.show();
        this.requestFocus();
        this.fPopupDismisser = new PopupDismisser();
        this.fInvokerWindow.addWindowListener(this.fPopupDismisser);
        this.fInvokerWindow.addComponentListener(this.fPopupDismisser);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.fPopupDismisser, 24L);
    }

    private void hidePopup() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fPopupDismisser);
        this.firePopupMenuWillBecomeInvisible();
        this.fInvokerWindow.removeWindowListener(this.fPopupDismisser);
        this.fInvokerWindow.removeComponentListener(this.fPopupDismisser);
        this.fInvokerWindow = null;
        this.fPopup.hide();
        this.fPopup = null;
        this.fPopupDismisser = null;
        this.fInvoker = null;
    }

    public void addToMenu(JMenu jMenu) {
        this.fScrolledList.setBorder(BorderFactory.createEmptyBorder());
        jMenu.add(this.fScrolledList);
        this.fInvoker = jMenu;
        JPopupMenu jPopupMenu = (JPopupMenu)this.fScrolledList.getParent();
        Dimension dimension = this.fScrolledList.getPreferredSize();
        Insets insets = jPopupMenu.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        jPopupMenu.setPopupSize(dimension);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        AWTEventListener[] aWTEventListenerArray = toolkit.getAWTEventListeners();
        for (AWTEventListener aWTEventListener : aWTEventListenerArray) {
            Object t;
            if (!(aWTEventListener instanceof AWTEventListenerProxy) || !"javax.swing.plaf.basic.BasicPopupMenuUI$MouseGrabber".equals((t = ((EventListenerProxy)((Object)aWTEventListener)).getListener()).getClass().getName())) continue;
            this.fSavedMouseGrabber = aWTEventListener;
            this.fSavedGrabberMask = ((AWTEventListenerProxy)aWTEventListener).getEventMask();
            toolkit.removeAWTEventListener(this.fSavedMouseGrabber);
            this.fMouseGrabber = new MouseGrabber();
            toolkit.addAWTEventListener(this.fMouseGrabber, 48L);
        }
        this.fKeyDispatcher = new KeyDispatcher();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(this.fKeyDispatcher);
    }

    public void removeFromMenu(JMenu jMenu) {
        Object object;
        jMenu.remove(this.fScrolledList);
        if (this.fSavedMouseGrabber != null) {
            object = Toolkit.getDefaultToolkit();
            ((Toolkit)object).removeAWTEventListener(this.fMouseGrabber);
            ((Toolkit)object).addAWTEventListener(this.fSavedMouseGrabber, this.fSavedGrabberMask);
            this.fSavedMouseGrabber = null;
        }
        if (this.fKeyDispatcher != null) {
            object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            ((KeyboardFocusManager)object).removeKeyEventDispatcher(this.fKeyDispatcher);
            this.fKeyDispatcher = null;
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            int n = this.getSelectedIndex();
            int n2 = keyEvent.getKeyCode();
            if (n2 == 10 && n != -1) {
                this.fireAction(n);
                keyEvent.consume();
            } else {
                DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
                for (n = 0; n < defaultListModel.getSize(); ++n) {
                    ItemData itemData = (ItemData)defaultListModel.getElementAt(n);
                    Integer n3 = (Integer)itemData.iAction.getValue("MnemonicKey");
                    if (n3 != n2) continue;
                    this.fireAction(n);
                    keyEvent.consume();
                    break;
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        int n;
        Dimension dimension = this.getPreferredSize();
        int n2 = this.getVisibleRowCount();
        if (this.getModel().getSize() > n2) {
            Rectangle rectangle = this.getCellBounds(0, n2 - 1);
            dimension.height = rectangle.height;
        }
        if (dimension.height > (n = WindowUtils.getScreenBounds().height - 10)) {
            dimension.height = n;
        }
        return dimension;
    }

    private void setDisplayAreaLocation(Point point) {
        double d = this.fScrolledList.getBorder().getBorderInsets((Component)this.fScrolledList).left;
        double d2 = this.fScrolledList.getBorder().getBorderInsets((Component)this.fScrolledList).top;
        this.fDisplayAreaLocation.setLocation(point.getX() + d, point.getY() + d2);
    }

    public Point getDisplayAreaLocation() {
        return this.fDisplayAreaLocation;
    }

    public void cleanup() {
        ((MenuRenderer)this.getCellRenderer()).cleanup();
    }

    private void fireAction(int n) {
        Component component = this.fInvoker;
        if (this.fPopup != null) {
            this.hidePopup();
        } else {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            this.fInvoker = null;
        }
        ItemData itemData = (ItemData)this.getModel().getElementAt(n);
        if ((itemData.iType == 2 || itemData.iType == 3) && itemData.iAction instanceof MJAbstractAction) {
            MJAbstractAction mJAbstractAction;
            mJAbstractAction.setSelected(!(mJAbstractAction = (MJAbstractAction)itemData.iAction).isSelected());
        }
        itemData.iAction.actionPerformed(new ActionEvent(component, n, "Value accepted"));
    }

    private void highlightItem(MouseEvent mouseEvent) {
        int n = this.locationToIndex(mouseEvent.getPoint());
        if (n != -1) {
            this.setSelectedIndex(n);
        }
    }

    protected void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
        }
    }

    protected void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuCanceled(popupMenuEvent);
        }
    }

    private class MouseGrabber
    implements AWTEventListener {
        private MouseGrabber() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mouseEvent;
            Point point;
            if (!ScrollablePopupList.this.isShowing()) {
                return;
            }
            if (aWTEvent.getID() == 501) {
                if (!this.isInPopup((Component)aWTEvent.getSource())) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            } else if ((aWTEvent.getID() == 506 || aWTEvent.getID() == 502) && aWTEvent.getSource() instanceof JMenuItem && ScrollablePopupList.this.contains(point = SwingUtilities.convertPoint((mouseEvent = (MouseEvent)aWTEvent).getComponent(), mouseEvent.getX(), mouseEvent.getY(), ScrollablePopupList.this))) {
                MouseEvent mouseEvent2 = new MouseEvent(ScrollablePopupList.this, aWTEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                if (aWTEvent.getID() == 502) {
                    ScrollablePopupList.this.processMouseEvent(mouseEvent2);
                } else if (aWTEvent.getID() == 506) {
                    ScrollablePopupList.this.processMouseMotionEvent(mouseEvent2);
                }
            }
        }

        boolean isInPopup(Component component) {
            for (Component component2 = component; component2 != null && !(component2 instanceof Window); component2 = component2.getParent()) {
                if (!(component2 instanceof JPopupMenu)) continue;
                return true;
            }
            return false;
        }
    }

    private class KeyDispatcher
    implements KeyEventDispatcher {
        private KeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (!ScrollablePopupList.this.isShowing() || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 27) {
                return false;
            }
            ScrollablePopupList.this.processKeyEvent(new KeyEvent(ScrollablePopupList.this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
            return true;
        }
    }

    private class PopupDismisser
    extends WindowAdapter
    implements AWTEventListener,
    ComponentListener {
        private PopupDismisser() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Component component;
            if (ScrollablePopupList.this.fPopup == null) {
                return;
            }
            if (aWTEvent.getID() == 401) {
                if (((KeyEvent)aWTEvent).getKeyCode() == 27) {
                    ScrollablePopupList.this.firePopupMenuCanceled();
                    ScrollablePopupList.this.hidePopup();
                }
            } else if (aWTEvent.getID() == 501 && (component = ((ComponentEvent)aWTEvent).getComponent()) != ScrollablePopupList.this.fScrolledList && !SwingUtilities.isDescendingFrom(component, ScrollablePopupList.this.fScrolledList)) {
                ScrollablePopupList.this.firePopupMenuCanceled();
                ScrollablePopupList.this.hidePopup();
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            if (ScrollablePopupList.this.fPopup != null) {
                ScrollablePopupList.this.firePopupMenuCanceled();
                ScrollablePopupList.this.hidePopup();
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (ScrollablePopupList.this.fPopup != null) {
                ScrollablePopupList.this.hidePopup();
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            if (ScrollablePopupList.this.fPopup != null) {
                ScrollablePopupList.this.hidePopup();
            }
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    private static class ItemPanel
    extends MJPanel {
        final JMenuItem iMenuItem;
        final Component iSeparator;

        ItemPanel(JMenuItem jMenuItem) {
            this.setLayout(new BorderLayout());
            this.iMenuItem = jMenuItem;
            this.add((Component)this.iMenuItem, "Center");
            this.iSeparator = new JPopupMenu.Separator();
            this.add(this.iSeparator, "South");
        }
    }

    private static class MenuRenderer
    implements ListCellRenderer {
        private ItemPanel fItemPanel;
        private ItemPanel fCheckBoxItemPanel;
        private ItemPanel fRadioButtonItemPanel;

        private MenuRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ItemData itemData = (ItemData)object;
            ItemPanel itemPanel = this.getPanel(itemData.iType);
            itemPanel.iMenuItem.setAction(itemData.iAction);
            itemPanel.iSeparator.setVisible(itemData.iAppendSeparator);
            Icon icon = null;
            if (itemData.iAction instanceof ExtendedAction) {
                icon = ((ExtendedAction)itemData.iAction).getButtonOnlyIcon();
            }
            if (icon == null) {
                icon = (Icon)itemData.iAction.getValue("SmallIcon");
            }
            if (icon instanceof IconSet) {
                icon = ((IconSet)icon).getSmallestIcon();
            }
            itemPanel.iMenuItem.setIcon(icon);
            itemPanel.iMenuItem.getModel().setArmed(bl);
            String string = (String)itemData.iAction.getValue("ShortDescription");
            if (string != null && !string.equals(itemData.iAction.getValue("Name"))) {
                itemPanel.setToolTipText(string);
            } else {
                itemPanel.setToolTipText(null);
            }
            return itemPanel;
        }

        ItemPanel getPanel(int n) {
            switch (n) {
                case 1: {
                    if (this.fItemPanel == null) {
                        this.fItemPanel = new ItemPanel(new MJMenuItem(){

                            @Override
                            public void setText(String string) {
                                if (string != null) {
                                    string = MJUtilities.exciseBracketMnemonic(string);
                                }
                                super.setText(string);
                            }
                        });
                    }
                    return this.fItemPanel;
                }
                case 2: {
                    if (this.fCheckBoxItemPanel == null) {
                        this.fCheckBoxItemPanel = new ItemPanel(new MJCheckBoxMenuItem(){

                            @Override
                            public void setText(String string) {
                                if (string != null) {
                                    string = MJUtilities.exciseBracketMnemonic(string);
                                }
                                super.setText(string);
                            }
                        });
                    }
                    return this.fCheckBoxItemPanel;
                }
                case 3: {
                    if (this.fRadioButtonItemPanel == null) {
                        this.fRadioButtonItemPanel = new ItemPanel(new MJRadioButtonMenuItem(){

                            @Override
                            public void setText(String string) {
                                if (string != null) {
                                    string = MJUtilities.exciseBracketMnemonic(string);
                                }
                                super.setText(string);
                            }
                        });
                    }
                    return this.fRadioButtonItemPanel;
                }
            }
            return null;
        }

        void cleanup() {
            if (this.fItemPanel != null) {
                this.fItemPanel.iMenuItem.setAction(null);
            }
            if (this.fCheckBoxItemPanel != null) {
                this.fCheckBoxItemPanel.iMenuItem.setAction(null);
            }
            if (this.fRadioButtonItemPanel != null) {
                this.fRadioButtonItemPanel.iMenuItem.setAction(null);
            }
        }
    }

    private static class ItemData {
        Action iAction;
        int iType = 1;
        boolean iAppendSeparator;

        private ItemData() {
        }
    }
}

