/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.AbstractNamedUniqueID;
import com.mathworks.mwswing.binding.ActionDataID;
import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.DefaultKeyBindingSetID;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.util.InitializationHelper;
import com.mathworks.util.InitializeBeforeAccess;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ActionData
extends AbstractNamedUniqueID
implements InitializeBeforeAccess,
ActionDataID {
    private final String fLabel;
    private final String fCategory;
    private final String fDescription;
    private final String fTooltip;
    private final String fIcon;
    private final String fIconPackage;
    private final String fPreferencePanelLabel;
    private final boolean fHidden;
    private final Set<String> fAlternateIDs = new HashSet<String>();
    private final List<KeyStrokeList> fUnspecifiedBindings = new LinkedList<KeyStrokeList>();
    private final Map<String, List<KeyStrokeList>> fKeyBindingsBySet = new HashMap<String, List<KeyStrokeList>>();
    private final InitializeBeforeAccess fInitializationHelper = new InitializationHelper();
    private static final List<KeyStrokeList> EMPTY_LIST = Collections.emptyList();

    ActionData(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        super(string, MJUtilities.exciseMnemonic(string2));
        this.fLabel = string2;
        assert (this.fLabel != null) : "Label cannot be null.";
        this.fCategory = string3;
        assert (this.fCategory != null) : "Category cannot be null.";
        this.fDescription = string4;
        assert (this.fDescription != null) : "Description cannot be null";
        this.fTooltip = string5 == null ? MJUtilities.exciseMnemonic(this.fLabel) : string5;
        this.fIcon = string6;
        this.fIconPackage = string7;
        this.fPreferencePanelLabel = string8 == null ? this.getName() : string8;
        this.fHidden = bl;
        this.setNoBindingsForDefaultSet(DefaultKeyBindingSet.EMPTY);
    }

    void addUnspecifiedBinding(KeyStrokeList keyStrokeList) {
        this.checkMutable();
        KeyStrokeUtils.addAllBindingVariations(keyStrokeList, this.fUnspecifiedBindings);
    }

    void setNoBindingsForDefaultSet(DefaultKeyBindingSetID defaultKeyBindingSetID) {
        this.checkMutable();
        assert (this.fKeyBindingsBySet.get(defaultKeyBindingSetID.getID()) == null) : "Cannot call this method after addDefaultSetBinding has been called";
        this.fKeyBindingsBySet.put(defaultKeyBindingSetID.getID(), EMPTY_LIST);
    }

    void addDefaultSetBinding(DefaultKeyBindingSetID defaultKeyBindingSetID, KeyStrokeList keyStrokeList) {
        this.checkMutable();
        assert (keyStrokeList != null) : "Call setNoBindingsForDefaultSet to signify no keybindings for this set";
        List<KeyStrokeList> list = this.fKeyBindingsBySet.get(defaultKeyBindingSetID.getID());
        assert (!EMPTY_LIST.equals(list));
        if (list == null) {
            list = new LinkedList<KeyStrokeList>();
            this.fKeyBindingsBySet.put(defaultKeyBindingSetID.getID(), list);
        }
        KeyStrokeUtils.addAllBindingVariations(keyStrokeList, list);
    }

    void addAlternateID(String string) {
        assert (string != null) : "Alternate ID, if specified, must be non-null.";
        this.checkMutable();
        this.fAlternateIDs.add(string);
    }

    public List<KeyStrokeList> getBindings(DefaultKeyBindingSetID defaultKeyBindingSetID) {
        this.checkImmutable();
        List<KeyStrokeList> list = this.fKeyBindingsBySet.get(defaultKeyBindingSetID.getID());
        if (list == null) {
            list = this.fUnspecifiedBindings;
        }
        return Collections.unmodifiableList(list);
    }

    public String getLabel() {
        return this.fLabel;
    }

    public String getCategory() {
        return this.fCategory;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getTooltip() {
        return this.fTooltip;
    }

    public Icon getIcon() {
        ImageIcon imageIcon = null;
        if (this.fIcon != null) {
            imageIcon = this.fIconPackage == null ? IconEnumerationUtils.findCommonIcon((String)this.fIcon) : IconEnumerationUtils.findIcon((String)this.fIconPackage, (String)this.fIcon);
        }
        return imageIcon;
    }

    public String getIconName() {
        return this.fIcon;
    }

    public String getPreferencePanelLabel() {
        return this.fPreferencePanelLabel;
    }

    public boolean isHidden() {
        return this.fHidden;
    }

    public Set<String> getAlternateIDs() {
        return Collections.unmodifiableSet(this.fAlternateIDs);
    }

    public boolean equals(Object object) {
        this.checkImmutable();
        if (!(object instanceof ActionData)) {
            return false;
        }
        ActionData actionData = (ActionData)object;
        return actionData.getID().equals(this.getID());
    }

    public int hashCode() {
        this.checkImmutable();
        return 629 + this.getID().hashCode();
    }

    public void initializationFinished() {
        this.fInitializationHelper.initializationFinished();
    }

    public void checkMutable() throws IllegalStateException {
        this.fInitializationHelper.checkMutable();
    }

    public void checkImmutable() throws IllegalStateException {
        this.fInitializationHelper.checkImmutable();
    }

    static boolean areCompletelyEquivalent(ActionData actionData, ActionData actionData2) {
        actionData.checkImmutable();
        actionData2.checkImmutable();
        return actionData.getID().equals(actionData2.getID()) && actionData.getCategory().equals(actionData2.getCategory()) && actionData.getDescription().equals(actionData2.getDescription()) && (actionData.getIcon() == null && actionData2.getIcon() == null || actionData.getIconName().equals(actionData2.getIconName())) && actionData.getLabel().equals(actionData2.getLabel()) && actionData.getTooltip().equals(actionData2.getTooltip()) && actionData.fUnspecifiedBindings.equals(actionData2.fUnspecifiedBindings) && actionData.fKeyBindingsBySet.equals(actionData2.fKeyBindingsBySet) && (actionData.getAlternateIDs() == null && actionData2.getAlternateIDs() == null || actionData.getAlternateIDs().equals(actionData2.getAlternateIDs()) && actionData.getPreferencePanelLabel().equals(actionData2.getPreferencePanelLabel()) && actionData.isHidden() == actionData2.isHidden());
    }
}

