/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.plaf;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class XORSplitPaneUI
extends BasicSplitPaneUI {
    private Rectangle fLastDrawRectangle;
    private boolean fUseXORDrawing = false;
    private final Color fDividerDragColor = UIManager.getColor("SplitPaneDivider.draggingColor");
    private final Color fBackgroundColor;

    public XORSplitPaneUI(Color color) {
        this.setContinuousLayout(false);
        this.fBackgroundColor = color;
    }

    @Override
    public void setContinuousLayout(boolean bl) {
        if (bl) {
            throw new IllegalArgumentException("This UI class does not support continuous layout.");
        }
        super.setContinuousLayout(bl);
    }

    @Override
    protected void startDragging() {
        this.fUseXORDrawing = this.isInNonFrameHeavyweightAncestor();
        this.fLastDrawRectangle = null;
        super.startDragging();
    }

    @Override
    protected void finishDraggingTo(int n) {
        super.finishDraggingTo(n);
        this.clearRect();
        this.fLastDrawRectangle = null;
    }

    @Override
    protected void dragDividerTo(int n) {
        if (this.fUseXORDrawing) {
            if (this.getLastDragLocation() != n) {
                this.clearRect();
                this.fLastDrawRectangle = this.getOrientation() == 1 ? new Rectangle(n, 0, this.dividerSize, this.splitPane.getHeight()) : new Rectangle(0, n, this.splitPane.getWidth(), this.dividerSize);
                this.drawLastRect();
            }
        } else {
            super.dragDividerTo(n);
        }
    }

    private void clearRect() {
        this.drawLastRect();
    }

    private void drawLastRect() {
        if (this.fLastDrawRectangle != null && this.fUseXORDrawing) {
            Graphics2D graphics2D = (Graphics2D)this.splitPane.getGraphics();
            if (this.fBackgroundColor != null) {
                graphics2D.setColor(this.fBackgroundColor);
            }
            graphics2D.setXORMode(this.fDividerDragColor);
            graphics2D.fillRect(this.fLastDrawRectangle.x, this.fLastDrawRectangle.y, this.fLastDrawRectangle.width, this.fLastDrawRectangle.height);
            graphics2D.dispose();
        }
    }

    private boolean isInNonFrameHeavyweightAncestor() {
        boolean bl = true;
        for (Container container = this.splitPane; container != null && !(container instanceof Window) && bl; container = container.getParent()) {
            bl = container.isLightweight();
        }
        return !bl;
    }
}

