/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class ChunkFileRecordReader
extends FileInputFormat<Text, Text> {
    public static int chunkSize = 0;
    private static final int DEFAULT_CHUNK_SIZE = 0x800000;
    private byte[] m_delimBytes = null;

    private int find_sub_array(byte[] searchArr, byte[] byteSequenceToFind) {
        int posFound = -1;
        for (int searchArrIdx = 0; searchArrIdx < searchArr.length - byteSequenceToFind.length; ++searchArrIdx) {
            int toFindArrIdx;
            int currSearchIdx = searchArrIdx;
            for (toFindArrIdx = 0; toFindArrIdx < byteSequenceToFind.length && searchArr[searchArrIdx++] == byteSequenceToFind[toFindArrIdx]; ++toFindArrIdx) {
            }
            if (toFindArrIdx == byteSequenceToFind.length) {
                posFound = currSearchIdx;
                break;
            }
            searchArrIdx = currSearchIdx;
        }
        return posFound;
    }

    private int reverse_find_sub_array(byte[] searchArr, byte[] byteSequenceToFind) {
        int posFound = -1;
        for (int searchArrIdx = searchArr.length - 1; searchArrIdx >= byteSequenceToFind.length - 1; --searchArrIdx) {
            int toFindArrIdx;
            int currSearchIdx = searchArrIdx;
            for (toFindArrIdx = byteSequenceToFind.length - 1; toFindArrIdx >= 0 && searchArr[searchArrIdx--] == byteSequenceToFind[toFindArrIdx]; --toFindArrIdx) {
            }
            if (toFindArrIdx == -1) {
                posFound = currSearchIdx;
                break;
            }
            searchArrIdx = currSearchIdx;
        }
        return posFound;
    }

    public RecordReader<Text, Text> createRecordReader(InputSplit fileSplit, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        if (chunkSize == 0) {
            chunkSize = 0x800000;
        }
        this.m_delimBytes = new byte[]{10};
        ChunkedReader reader = new ChunkedReader();
        reader.initialize(fileSplit, taskContext);
        return reader;
    }

    class ChunkedReader
    extends RecordReader<Text, Text> {
        private FileSystem m_fileSys = null;
        private Path m_filePath = null;
        private long m_nOrigStartOffset = 0L;
        private long m_nKeyOffset = 0L;
        private long m_nStartOffset = 0L;
        private long m_nEndOffset = 0L;
        private long m_nTotalFileSize = 0L;
        private boolean m_bInitialized = false;
        private boolean m_bProcessed = false;
        private Text m_textKey = new Text();
        private Text m_textValue = new Text();
        private final int FirstDelimiterBuffSize = 2048;

        ChunkedReader() {
        }

        public void close() throws IOException {
        }

        public Text getCurrentKey() throws IOException, InterruptedException {
            return this.m_textKey;
        }

        public Text getCurrentValue() throws IOException, InterruptedException {
            return this.m_textValue;
        }

        public float getProgress() throws IOException, InterruptedException {
            return (float)(this.m_nStartOffset - this.m_nOrigStartOffset) / (float)(this.m_nEndOffset - this.m_nOrigStartOffset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void initialize(InputSplit fileSplit, TaskAttemptContext taskContext) throws IOException, InterruptedException {
            if (!this.m_bInitialized) {
                FileSplit l_fileSplit = (FileSplit)fileSplit;
                this.m_filePath = l_fileSplit.getPath();
                this.m_fileSys = this.m_filePath.getFileSystem(taskContext.getConfiguration());
                this.m_nStartOffset = l_fileSplit.getStart();
                this.m_nEndOffset = this.m_nStartOffset + l_fileSplit.getLength();
                this.m_nTotalFileSize = this.m_fileSys.getFileStatus(this.m_filePath).getLen();
                if (this.m_nStartOffset != 0L) {
                    FSDataInputStream inStream = null;
                    try {
                        inStream = this.m_fileSys.open(this.m_filePath);
                        inStream.seek(this.m_nStartOffset);
                        byte[] buffer = new byte[2048];
                        int posFound = -1;
                        while (true) {
                            inStream.readFully(buffer, 0, 2048);
                            posFound = ChunkFileRecordReader.this.find_sub_array(buffer, ChunkFileRecordReader.this.m_delimBytes);
                            if (posFound != -1) {
                                this.m_nStartOffset += (long)(posFound + ChunkFileRecordReader.this.m_delimBytes.length);
                                break;
                            }
                            this.m_nStartOffset += 2048L;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeStream(inStream);
                        throw throwable;
                    }
                    IOUtils.closeStream((Closeable)inStream);
                }
                this.m_nOrigStartOffset = this.m_nStartOffset;
                this.m_bInitialized = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean nextKeyValue() throws IOException, InterruptedException {
            block8: {
                FSDataInputStream inStream;
                block7: {
                    if (this.m_bProcessed) break block8;
                    this.m_nKeyOffset = this.m_nStartOffset;
                    inStream = null;
                    try {
                        inStream = this.m_fileSys.open(this.m_filePath);
                        inStream.seek(this.m_nStartOffset);
                        boolean bLastChunkForSplit = this.m_nEndOffset - this.m_nStartOffset <= (long)chunkSize;
                        boolean bLastChunkInFile = this.m_nEndOffset == this.m_nTotalFileSize;
                        this.m_textKey.set(this.m_filePath.getName() + "_" + this.m_nKeyOffset);
                        if (bLastChunkForSplit) {
                            byte[] buffer = new byte[(int)(this.m_nEndOffset - this.m_nStartOffset)];
                            inStream.readFully(buffer, 0, buffer.length);
                            if (bLastChunkInFile) {
                                this.m_textValue.set(buffer, 0, buffer.length);
                            } else {
                                int posFound;
                                ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(buffer.length);
                                byteBuffer.write(buffer, 0, buffer.length);
                                buffer = new byte[2048];
                                while (true) {
                                    inStream.readFully(buffer, 0, 2048);
                                    posFound = ChunkFileRecordReader.this.find_sub_array(buffer, ChunkFileRecordReader.this.m_delimBytes);
                                    if (posFound != -1) break;
                                    byteBuffer.write(buffer, 0, 2048);
                                }
                                byteBuffer.write(buffer, 0, posFound + ChunkFileRecordReader.this.m_delimBytes.length);
                                byte[] bytesToSet = byteBuffer.toByteArray();
                                this.m_textValue.set(bytesToSet, 0, bytesToSet.length);
                            }
                            this.m_nStartOffset = this.m_nEndOffset;
                            this.m_bProcessed = true;
                            break block7;
                        }
                        byte[] buffer = new byte[chunkSize];
                        inStream.readFully(buffer, 0, buffer.length);
                        int posFound = ChunkFileRecordReader.this.reverse_find_sub_array(buffer, ChunkFileRecordReader.this.m_delimBytes);
                        if (posFound == -1) {
                            throw new IOException("Could not find delimiter in the chunk. Recheck delimiter, or the chunk size");
                        }
                        this.m_nStartOffset += (long)(posFound + 1);
                        this.m_textValue.set(buffer, 0, posFound + 1);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeStream(inStream);
                        throw throwable;
                    }
                }
                IOUtils.closeStream((Closeable)inStream);
                return true;
            }
            return false;
        }
    }
}

