/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.logger;

import com.mathworks.util.logger.Logger;
import com.mathworks.util.logger.LoggerFactory;
import com.mathworks.util.logger.impl.LegacyLoggerFactory;

public class Log {
    private static boolean sThrowExceptionsOnErrors = false;
    private static volatile LoggerFactory sLoggerFactory = new LegacyLoggerFactory();
    private Logger fLogger;
    private final String fName;

    public Log(String string) {
        this.fName = string;
    }

    public Log(Class clazz) {
        this(clazz.getName());
    }

    private synchronized Logger getLogger() {
        if (this.fLogger == null) {
            this.fLogger = sLoggerFactory.createLogger(this.fName);
        }
        return this.fLogger;
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public void debug(String string, Object ... objectArray) {
        Logger logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(this.format(string, objectArray));
        }
    }

    public void debug(Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger.isDebugEnabled() && throwable != null) {
            logger.debug(throwable, "");
        }
    }

    public void debug(Throwable throwable, String string, Object ... objectArray) {
        Logger logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(this.format(string, objectArray));
            if (throwable != null) {
                logger.debug(throwable, "");
            }
        }
    }

    public void error(String string, Object ... objectArray) {
        if (this.getLogger().isErrorEnabled()) {
            String string2 = this.format(string, objectArray);
            this.error((Throwable)null, string2, new Object[0]);
        }
    }

    public void error(Throwable throwable) {
        this.error(throwable, "", new Object[0]);
    }

    public void error(Throwable throwable, String string, Object ... objectArray) {
        Logger logger = this.getLogger();
        if (logger.isErrorEnabled()) {
            String string2 = this.format(string, objectArray);
            if (throwable == null) {
                logger.error(string2);
            } else {
                logger.error(throwable, string2);
            }
            if (Log.isThrowExceptionsOnErrors()) {
                throw new RuntimeException(string2, throwable);
            }
        }
    }

    public void info(String string, Object ... objectArray) {
        Logger logger = this.getLogger();
        if (logger.isInfoEnabled()) {
            logger.info(this.format(string, objectArray));
        }
    }

    public void info(Throwable throwable, String string, Object ... objectArray) {
        Logger logger = this.getLogger();
        if (logger.isInfoEnabled()) {
            logger.info(throwable, this.format(string, objectArray));
        }
    }

    public void info(Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger.isInfoEnabled() && throwable != null) {
            logger.info(throwable, "");
        }
    }

    public void warn(String string, Object ... objectArray) {
        Logger logger = this.getLogger();
        if (logger.isWarnEnabled()) {
            logger.warn(this.format(string, objectArray));
        }
    }

    public void warn(Throwable throwable, String string, Object ... objectArray) {
        Logger logger = this.getLogger();
        if (logger.isWarnEnabled()) {
            logger.warn(throwable, this.format(string, objectArray));
        }
    }

    public void warn(Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger.isWarnEnabled() && throwable != null) {
            logger.warn(throwable, "");
        }
    }

    private String format(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return string;
        }
        return String.format(string, objectArray);
    }

    public static boolean isThrowExceptionsOnErrors() {
        return sThrowExceptionsOnErrors;
    }

    public static void setThrowExceptionsOnErrors(boolean bl) {
        sThrowExceptionsOnErrors = bl;
    }

    public static void setLoggerFactory(LoggerFactory loggerFactory) {
        sLoggerFactory = loggerFactory;
    }

    public static Log getInstance(String string) {
        return new Log(string);
    }

    public static Log getInstance(Class clazz) {
        return new Log(clazz);
    }
}

