/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.MWBaseCodeMapBuilder;
import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.product.BaseCodeMapBuilder;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetParser;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.SimpleDocProduct;
import com.mathworks.helpsearch.product.SimpleDocumentationSet;
import java.io.File;
import java.io.IOException;

public class LocalDocSetParser
extends DocSetParser<SimpleDocumentationSet> {
    private static final String PROPERTIES_FILE_NAME = "basecodes.properties";
    private static final String DOCSET_FILE_NAME = "docset.xml";
    private final File fDocSetDir;
    private final DocLanguage fLanguage;

    public LocalDocSetParser(File file, DocLanguage docLanguage) {
        super(LocalDocSetParser.getBaseCodeMapBuilder(file));
        this.fDocSetDir = file;
        this.fLanguage = docLanguage;
    }

    private static BaseCodeMapBuilder getBaseCodeMapBuilder(File file) {
        try {
            return new MWBaseCodeMapBuilder(new File(file, PROPERTIES_FILE_NAME));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static DocumentationSet parseDocumentationSet(String string, DocLanguage docLanguage) {
        return LocalDocSetParser.parseDocumentationSet(new File(string), docLanguage);
    }

    public static DocumentationSet parseDocumentationSet(File file, DocLanguage docLanguage) {
        LocalDocSetParser localDocSetParser = new LocalDocSetParser(file, docLanguage);
        SimpleDocumentationSet simpleDocumentationSet = localDocSetParser.getDocSet();
        return simpleDocumentationSet == null ? localDocSetParser.createNewDocSet(ContentFormat.DOC_CENTER_DOC) : simpleDocumentationSet;
    }

    protected File getDocSetConfigFile() {
        return new File(this.fDocSetDir, DOCSET_FILE_NAME);
    }

    protected SimpleDocumentationSet createNewDocSet(ContentFormat contentFormat) {
        return new SimpleDocumentationSet(contentFormat, this.fLanguage);
    }

    protected DocProduct createNewProduct(SimpleDocumentationSet simpleDocumentationSet, String string, String string2, String string3) {
        return new SimpleDocProduct((DocumentationSet)simpleDocumentationSet, string, string2, string3);
    }

    public SimpleDocumentationSet getDocSet() {
        return (SimpleDocumentationSet)super.getDocSet();
    }
}

