/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.AbstractDocConfig;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.DocUrlNavigationRule;
import com.mathworks.help.helpui.WebDocUrlConfig;
import com.mathworks.help.helpui.WebTemplateDocUrlRule;
import com.mathworks.html.Url;
import com.mathworks.html.WebUrl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public abstract class WebDocConfig
extends AbstractDocConfig<WebUrl> {
    private final DocRoot<WebUrl> fDocUrlBuilder;
    private final WebDocUrlConfig fWebDocUrlConfig;

    public WebDocConfig(WebUrl webUrl, WebDocUrlConfig webDocUrlConfig, File file) {
        super(file, webDocUrlConfig.getLanguage());
        this.fDocUrlBuilder = DocRoot.create(webUrl, webDocUrlConfig);
        this.fWebDocUrlConfig = webDocUrlConfig;
    }

    @Override
    public DocRoot<WebUrl> getDocRoot() {
        return this.fDocUrlBuilder;
    }

    @Override
    public Url.UrlType getUrlType() {
        return Url.UrlType.WEB;
    }

    @Override
    public Collection<DocUrlNavigationRule> getDocUrlNavigationRules() {
        Collection<DocUrlNavigationRule> collection = super.getDocUrlNavigationRules();
        if (this.fWebDocUrlConfig.getUseInProductWebTemplate()) {
            collection = new ArrayList<DocUrlNavigationRule>(collection);
            WebTemplateDocUrlRule webTemplateDocUrlRule = new WebTemplateDocUrlRule(this.fWebDocUrlConfig.getRelease());
            collection.add(webTemplateDocUrlRule);
        }
        return collection;
    }
}

