/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.search.FacetJsonBuilder;
import com.mathworks.help.helpui.search.LocalDocSearchPage;
import com.mathworks.help.helpui.search.PageDataJsonBuilder;
import com.mathworks.help.helpui.search.SearchResultJsonBuilder;
import com.mathworks.helpsearch.DocumentationQuery;
import com.mathworks.helpsearch.DocumentationSearchResult;
import com.mathworks.helpsearch.facets.DocFacetResults;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.html.FileUrl;
import com.mathworks.search.SearchResults;
import java.util.List;

public class DocSearchResultPage {
    private final PageDataJsonBuilder fPageDataJsonBuilder;
    private final FacetJsonBuilder fFacetJsonBuilder;
    private final SearchResultJsonBuilder fSearchResultJsonBuilder;
    private final JsonEntity fJsonSearchTerm;

    public DocSearchResultPage(DocConfig<FileUrl> docConfig, LocalDocSearchPage localDocSearchPage, SearchResults<DocumentationSearchResult> searchResults, List<DocFacetResults> list) {
        DocumentationQuery documentationQuery = localDocSearchPage.getQuery();
        this.fJsonSearchTerm = DocSearchResultPage.getJsonSearchTerm(documentationQuery.getSearchText());
        DocRoot<FileUrl> docRoot = docConfig.getDocRoot();
        DocumentationSet documentationSet = docConfig.getDocumentationSet();
        String string = documentationSet.getLanguage().getLocale().getLanguage();
        JsonEntity jsonEntity = DocSearchResultPage.getJsonSearchTerm(documentationQuery.getFullSearchString());
        this.fPageDataJsonBuilder = new PageDataJsonBuilder(localDocSearchPage, searchResults, jsonEntity, docRoot, string);
        this.fFacetJsonBuilder = new FacetJsonBuilder(list, localDocSearchPage, docRoot);
        this.fSearchResultJsonBuilder = new SearchResultJsonBuilder(searchResults, docRoot, documentationSet);
    }

    public JsonEntity getJsonPageData() {
        return this.fPageDataJsonBuilder.getJsonPageData();
    }

    public JsonEntity getJsonFacetResults() {
        return this.fFacetJsonBuilder.getJsonFacetResults();
    }

    public JsonEntity getJsonFacetLabel() {
        return this.fFacetJsonBuilder.getJsonFacetLabel();
    }

    public JsonEntity getJsonSearchResults() {
        return this.fSearchResultJsonBuilder.getJsonSearchResults();
    }

    public JsonEntity getJsonSearchTerm() {
        return this.fJsonSearchTerm;
    }

    private static JsonEntity getJsonSearchTerm(String string) {
        JsonArray jsonArray = new JsonArray();
        if (string != null) {
            jsonArray.addString(string);
        }
        return jsonArray;
    }
}

