/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.suggestions;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.suggestions.FullSuggestionJsonEntity;
import com.mathworks.help.helpui.suggestions.SuggestionRequest;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.suggestion.DocumentationSuggestionProvider;
import com.mathworks.helpsearch.suggestion.FullSuggestionFinder;
import com.mathworks.helpsearch.suggestion.PageSuggestion;
import com.mathworks.html.FileUrl;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SearchSuggestions;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;

public class FullSuggestionRequest
implements SuggestionRequest {
    public static final MessageFormat FULL_SUGGESTIONS_FORMAT = new MessageFormat("suggestionsObj.displaySuggestions({0});");
    private final String fSearchText;
    private final FullSuggestionFinder fSuggestionFinder;
    private final DocRoot<FileUrl> fDocUrlBuilder;

    public FullSuggestionRequest(DocRoot<FileUrl> docRoot, DocumentationSuggestionProvider documentationSuggestionProvider, Collection<InformationType> collection, String string, int n) {
        this(docRoot, string, FullSuggestionRequest.createSuggestionFinder(documentationSuggestionProvider, collection, string, n));
    }

    public FullSuggestionRequest(DocRoot<FileUrl> docRoot, String string, FullSuggestionFinder fullSuggestionFinder) {
        this.fSearchText = string;
        this.fSuggestionFinder = fullSuggestionFinder;
        this.fDocUrlBuilder = docRoot;
    }

    private static FullSuggestionFinder createSuggestionFinder(DocumentationSuggestionProvider documentationSuggestionProvider, Collection<InformationType> collection, String string, int n) {
        return new FullSuggestionFinder(documentationSuggestionProvider, collection, string, n);
    }

    public Map<InformationType, SearchResults<PageSuggestion>> getPageSuggestions() throws SearchException {
        return this.fSuggestionFinder.getPageSuggestions();
    }

    public SearchSuggestions getWordSuggestions() throws SearchException {
        return this.fSuggestionFinder.getWordSuggestions();
    }

    public JsonEntity getSuggestionsJson(Map<InformationType, SearchResults<PageSuggestion>> map, SearchSuggestions searchSuggestions) {
        return new FullSuggestionJsonEntity(this.fSearchText, this.fDocUrlBuilder, map, searchSuggestions);
    }

    @Override
    public String getJavaScriptCallback() throws SearchException {
        Map<InformationType, SearchResults<PageSuggestion>> map = this.getPageSuggestions();
        SearchSuggestions searchSuggestions = this.getWordSuggestions();
        JsonEntity jsonEntity = this.getSuggestionsJson(map, searchSuggestions);
        Object[] objectArray = new Object[]{jsonEntity.getJsonString()};
        return FULL_SUGGESTIONS_FORMAT.format(objectArray);
    }
}

