/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.mathworks.install.ComponentContainerImpl;
import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.ContentOptimizerImplForDownloadFlow;
import com.mathworks.install.DownloaderBuilder;
import com.mathworks.install.DownloaderBuilderFactory;
import com.mathworks.install.DownloaderBuilderImpl;
import com.mathworks.install.InstallerDownloadInfoContainer;
import com.mathworks.install.ProductContainerImpl;
import com.mathworks.install.ProductDownloader;
import com.mathworks.install.XMLInstallationFileParserImpl;
import com.mathworks.install.XMLParseStrategyForDownload;
import com.mathworks.install.XMLParserFactoryImpl;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.archive.ArchiveInputStreamExtractor;
import com.mathworks.install.input.InputModule;
import com.mathworks.install.input.InstallationInputFileFactory;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.webproxy.ProxyConfiguration;
import java.util.Properties;

class DownloaderBuilderFactoryImpl
implements DownloaderBuilderFactory {
    private final Platform platform;
    private final ExecutorServiceManager executorServiceManager;
    private final AppLogger appLogger;
    private final Downloader downloader;
    private final ProxyConfiguration proxyConfiguration;
    private final ProductDownloader productDownloader;
    private final ArchiveFactory archiveFactory;
    private final IO io;
    private final Properties properties;
    private final InstallerDownloadInfoContainer installerDownloadInfoContainer;
    private ArchiveInputStreamExtractor archiveInputStreamExtractor;

    @Inject
    DownloaderBuilderFactoryImpl(Platform platform, ExecutorServiceManager executorServiceManager, AppLogger appLogger, Downloader downloader, ProxyConfiguration proxyConfiguration, ArchiveInputStreamExtractor archiveInputStreamExtractor, ProductDownloader productDownloader, ArchiveFactory archiveFactory, IO iO, Properties properties, InstallerDownloadInfoContainer installerDownloadInfoContainer) {
        this.platform = platform;
        this.executorServiceManager = executorServiceManager;
        this.appLogger = appLogger;
        this.downloader = downloader;
        this.proxyConfiguration = proxyConfiguration;
        this.archiveInputStreamExtractor = archiveInputStreamExtractor;
        this.productDownloader = productDownloader;
        this.archiveFactory = archiveFactory;
        this.io = iO;
        this.properties = properties;
        this.installerDownloadInfoContainer = installerDownloadInfoContainer;
    }

    @Override
    public DownloaderBuilder createDownloaderBuilder(final String[] stringArray, final String[] stringArray2) {
        ComponentContainerImpl componentContainerImpl = new ComponentContainerImpl();
        ProductContainerImpl productContainerImpl = new ProductContainerImpl(componentContainerImpl);
        XMLParserFactoryImpl xMLParserFactoryImpl = new XMLParserFactoryImpl(productContainerImpl, componentContainerImpl, new XMLParseStrategyForDownload());
        final XMLInstallationFileParserImpl xMLInstallationFileParserImpl = new XMLInstallationFileParserImpl(xMLParserFactoryImpl, this.platform);
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new InputModule()}).with(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(XMLInstallationFileParser.class).toInstance((Object)xMLInstallationFileParserImpl);
                this.bind(Downloader.class).toInstance((Object)DownloaderBuilderFactoryImpl.this.downloader);
                this.bind(ProxyConfiguration.class).toInstance((Object)DownloaderBuilderFactoryImpl.this.proxyConfiguration);
                this.bind(ContentOptimizer.class).toInstance((Object)new ContentOptimizerImplForDownloadFlow(stringArray, stringArray2));
                this.bind(ArchiveInputStreamExtractor.class).toInstance((Object)DownloaderBuilderFactoryImpl.this.archiveInputStreamExtractor);
                this.bind(ArchiveFactory.class).toInstance((Object)DownloaderBuilderFactoryImpl.this.archiveFactory);
                this.bind(IO.class).toInstance((Object)DownloaderBuilderFactoryImpl.this.io);
                this.bind(Properties.class).toInstance((Object)DownloaderBuilderFactoryImpl.this.properties);
                this.bind(InstallerDownloadInfoContainer.class).toInstance((Object)DownloaderBuilderFactoryImpl.this.installerDownloadInfoContainer);
            }
        }})});
        return new DownloaderBuilderImpl(stringArray, productContainerImpl, this.executorServiceManager, (InstallationInputFileFactory)injector.getInstance(InstallationInputFileFactory.class), this.appLogger, componentContainerImpl, xMLInstallationFileParserImpl, this.downloader, this.proxyConfiguration, this.archiveInputStreamExtractor, this.productDownloader, this.properties, this.installerDownloadInfoContainer);
    }
}

