/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.CorruptedArchivesException;
import com.mathworks.install.Downloader;
import com.mathworks.install.DownloaderBuilder;
import com.mathworks.install.DownloaderImpl;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.Installer;
import com.mathworks.install.InstallerDownloadInfoContainer;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductDownloader;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.archive.ArchiveInputStreamExtractor;
import com.mathworks.install.input.ComponentURLProvider;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.InstallationInputFileFactory;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.InstallerDownloadURLInfo;
import com.mathworks.instutil.VersionUtils;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.internal.dws.client.EntitledProduct;
import com.mathworks.webproxy.ProxyConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DownloaderBuilderImpl
implements DownloaderBuilder {
    private static final int ZIPFILE_LIST_SIZE = 100;
    private final String[] archStrings;
    private final ProductContainer productContainer;
    private final Map<File, Exception> corruptedArchives = Collections.synchronizedMap(new HashMap());
    private final Map<Future<?>, File> currentlyReadingArchives = new HashMap();
    private final ProductDownloader productDownloader;
    private final Properties properties;
    private boolean readingArchives = false;
    private final ExecutorServiceManager executorServiceManager;
    private final InstallationInputFileFactory installationInputFileFactory;
    private final AppLogger appLogger;
    private Future<?> archivesListFilesFuture;
    private final ComponentContainer componentContainer;
    private final com.mathworks.instutil.Downloader downloader;
    private final ProxyConfiguration proxyConfiguration;
    private final ArchiveInputStreamExtractor archiveInputStreamExtractor;
    private XMLInstallationFileParser xmlInstallationFileParser;
    private final InstallerDownloadInfoContainer installerDownloadInfoContainer;

    DownloaderBuilderImpl(String[] stringArray, ProductContainer productContainer, ExecutorServiceManager executorServiceManager, InstallationInputFileFactory installationInputFileFactory, AppLogger appLogger, ComponentContainer componentContainer, XMLInstallationFileParser xMLInstallationFileParser, com.mathworks.instutil.Downloader downloader, ProxyConfiguration proxyConfiguration, ArchiveInputStreamExtractor archiveInputStreamExtractor, ProductDownloader productDownloader, Properties properties, InstallerDownloadInfoContainer installerDownloadInfoContainer) {
        this.archStrings = stringArray;
        this.productContainer = productContainer;
        this.executorServiceManager = executorServiceManager;
        this.installationInputFileFactory = installationInputFileFactory;
        this.appLogger = appLogger;
        this.componentContainer = componentContainer;
        this.downloader = downloader;
        this.proxyConfiguration = proxyConfiguration;
        this.archiveInputStreamExtractor = archiveInputStreamExtractor;
        this.productDownloader = productDownloader;
        this.xmlInstallationFileParser = xMLInstallationFileParser;
        this.installerDownloadInfoContainer = installerDownloadInfoContainer;
        this.properties = properties;
    }

    @Override
    public void startReadingArchives(final File[] fileArray) {
        this.readingArchives = true;
        this.archivesListFilesFuture = this.executorServiceManager.submitToSingleThreadedExecutorService((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DownloaderBuilderImpl.this.appLogger.logMsg("Starting local product/component search in download directory");
                DownloaderBuilderImpl.this.startParsingInstallationInputFiles(DownloaderBuilderImpl.this.getFilesToReadIn(fileArray));
                return null;
            }
        });
    }

    @Override
    public void addArchives(File[] fileArray, Installer installer, ValidatedFik validatedFik) {
    }

    @Override
    public String[] getAllInstallerNames() {
        return this.installerDownloadInfoContainer.getAllInstallerNames();
    }

    @Override
    public void finishReadingArchives() throws CorruptedArchivesException {
        if (!this.readingArchives) {
            throw new IllegalStateException("startReadingArchives must be called prior to calling finishReadingArchives");
        }
        try {
            this.archivesListFilesFuture.get();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
            return;
        }
        for (Future<?> future : this.currentlyReadingArchives.keySet()) {
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (ExecutionException executionException) {
                this.corruptedArchives.put(this.currentlyReadingArchives.get(future), executionException);
            }
        }
        if (!this.corruptedArchives.isEmpty()) {
            HashMap hashMap = new HashMap();
            hashMap.putAll(this.corruptedArchives);
            this.corruptedArchives.clear();
            throw new CorruptedArchivesException(hashMap);
        }
    }

    @Override
    public boolean isFinishedReadingArchives() {
        if (this.archivesListFilesFuture != null && !this.archivesListFilesFuture.isDone()) {
            return false;
        }
        if (this.archivesListFilesFuture == null) {
            return false;
        }
        for (Future<?> future : this.currentlyReadingArchives.keySet()) {
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addReleaseData(File file, ComponentURLProvider componentURLProvider) {
        ArrayList<InstallationInputFile> arrayList = new ArrayList<InstallationInputFile>();
        arrayList.add(this.installationInputFileFactory.createInstallationFileWithXMLFileParser(file, componentURLProvider, this.xmlInstallationFileParser));
        this.startParsingInstallationInputFiles(arrayList);
        try {
            this.finishReadingArchives();
        }
        catch (CorruptedArchivesException corruptedArchivesException) {
            // empty catch block
        }
    }

    private Collection<InstallationInputFile> getFilesToReadIn(File[] fileArray) throws IOException {
        ArrayList<InstallationInputFile> arrayList = new ArrayList<InstallationInputFile>(100);
        for (File file : fileArray) {
            if (!file.isDirectory()) continue;
            this.appLogger.logMsg("Reading " + file.getPath());
            arrayList.addAll(Arrays.asList(this.installationInputFileFactory.createInstallationFiles(file, this.xmlInstallationFileParser)));
        }
        return arrayList;
    }

    private void startParsingInstallationInputFiles(Collection<InstallationInputFile> collection) {
        for (final InstallationInputFile installationInputFile : collection) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        installationInputFile.parse();
                    }
                    catch (XMLParseException | IOException exception) {
                        DownloaderBuilderImpl.this.corruptedArchives.put(installationInputFile.getFile(), exception);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    return null;
                }
            };
            this.currentlyReadingArchives.put(this.executorServiceManager.submitToSingleThreadedExecutorService((Callable)callable), installationInputFile.getFile());
        }
        this.executorServiceManager.submitToSingleThreadedExecutorService((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DownloaderBuilderImpl.this.appLogger.logMsg("Completed local product/component search");
                return null;
            }
        });
    }

    @Override
    public Downloader buildDownloader(InstallerDownloadURLInfo[] installerDownloadURLInfoArray, EntitledProduct[] entitledProductArray) {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProduct installableProduct : this.productContainer.getInstallableProductsForMultiplePlatforms(this.archStrings)) {
            this.addOnlyEntitledProducts(entitledProductArray, arrayList, installableProduct);
        }
        this.installerDownloadInfoContainer.matchURL(installerDownloadURLInfoArray);
        DownloaderImpl downloaderImpl = new DownloaderImpl(this.archStrings, arrayList.toArray(new InstallableProduct[arrayList.size()]), this.productContainer, this.appLogger, this.componentContainer, this.downloader, this.proxyConfiguration, this.archiveInputStreamExtractor, this.productDownloader, this.properties, this.installerDownloadInfoContainer);
        DownloaderBuilderImpl.deselectOlderVersionsOfSelectedProducts(downloaderImpl);
        return downloaderImpl;
    }

    private void addOnlyEntitledProducts(EntitledProduct[] entitledProductArray, Collection<InstallableProduct> collection, InstallableProduct installableProduct) {
        for (EntitledProduct entitledProduct : entitledProductArray) {
            if (entitledProduct.getBitNumber() != installableProduct.getProductData().getProductNumber() || VersionUtils.compareVersionNumbers((String)entitledProduct.getVersion(), (String)installableProduct.getProductData().getVersion()) <= -1) continue;
            collection.add(installableProduct);
        }
    }

    private static void deselectOlderVersionsOfSelectedProducts(Downloader downloader) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (AvailableProduct availableProduct : downloader.getAvailableProducts()) {
            int n = availableProduct.getProductNumber();
            if (hashSet.contains(n)) {
                availableProduct.setSelected(false);
                continue;
            }
            hashSet.add(n);
        }
    }
}

