/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentContainerHandler;
import com.mathworks.install.ComponentData;
import com.mathworks.install.Product;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.XMLParseStrategy;
import com.mathworks.install.XMLParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

final class XMLParserImpl
implements XMLParser {
    private static final String INSTALLER_TYPE_PROFESSIONAL = "professional";
    private final SAXBuilder saxBuilder = new SAXBuilder();
    private final ComponentContainerHandler componentContainerHandler;
    private final XMLParseStrategy xmlParseStrategy;
    private ProductContainer productContainer;
    private ComponentContainer componentContainer;

    XMLParserImpl(ProductContainer productContainer, ComponentContainer componentContainer, ComponentContainerHandler componentContainerHandler, XMLParseStrategy xMLParseStrategy) {
        this.productContainer = productContainer;
        this.componentContainer = componentContainer;
        this.componentContainerHandler = componentContainerHandler;
        this.xmlParseStrategy = xMLParseStrategy;
    }

    public void addToProductContainer(Product product, ComponentData[] componentDataArray, String string, String string2, String[] stringArray, boolean bl, Document document) throws IOException {
        this.productContainer.add(product, componentDataArray, string, string2, stringArray, bl, XMLParserImpl.getXML(document));
    }

    @Override
    public void parse(byte[] byArray, String string) throws IOException, XMLParseException {
        this.parseRootElement(this.getDocument(new ByteArrayInputStream(byArray)), string);
    }

    void parseRootElement(Document document, String string) throws IOException {
        Element element = document.getRootElement();
        if ("productData".equalsIgnoreCase(element.getName())) {
            this.xmlParseStrategy.parseProductData(document, string, this, element);
        } else if ("productAdditionalComps".equalsIgnoreCase(element.getName())) {
            this.xmlParseStrategy.parseProductAdditionalComponents(document, string, this, element);
        } else if ("productOptionalComps".equalsIgnoreCase(element.getName())) {
            this.xmlParseStrategy.parseProductOptionalComponents(document, string, this, element);
        } else if ("componentData".equalsIgnoreCase(element.getName())) {
            for (Object e : element.getChildren()) {
                Element element2 = (Element)e;
                this.buildComponent(element2, document);
            }
        }
    }

    private Document getDocument(InputStream inputStream) throws IOException, XMLParseException {
        Document document;
        try {
            document = this.saxBuilder.build(inputStream);
        }
        catch (JDOMException jDOMException) {
            throw new XMLParseException(jDOMException);
        }
        return document;
    }

    void buildComponent(Element element, Document document) throws IOException {
        String string = element.getChildText("componentBaseName");
        String string2 = element.getChildText("componentFileName");
        String[] stringArray = XMLParserImpl.getPlatformListFromElement(element);
        String string3 = element.getChildText("componentVersion");
        long l = new Long(element.getChildText("numFiles"));
        String string4 = element.getChildText("releaseFamily");
        String string5 = element.getChildText("type");
        long l2 = XMLParserImpl.getSize(element);
        long l3 = new Long(element.getChildText("uncompressedBytes"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        Element element2 = element.getChild("componentFileName");
        Attribute attribute = element2.getAttribute("manifest");
        if (attribute != null) {
            arrayList.add(attribute.getValue());
        }
        String string6 = XMLParserImpl.getLocale(element);
        String string7 = element.getChildText("componentName");
        ComponentData componentData = this.componentContainer.createComponent(XMLParserImpl.getBackwardCompatibleComponentName(string2, string7), string3, string6, stringArray);
        this.componentContainerHandler.addComponent(componentData, XMLParserImpl.getXML(document), string2, string, l, string4, string5, l3, l2, arrayList.toArray(new String[arrayList.size()]));
    }

    private static String getBackwardCompatibleComponentName(String string, String string2) {
        return string2 == null ? FilenameUtils.removeExtension((String)string) : string2;
    }

    private static String getLocale(Element element) {
        String string = element.getChildText("locale");
        return string == null ? "" : string;
    }

    static String getXML(Document document) throws IOException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setFormat(Format.getPrettyFormat());
        xMLOutputter.output(document, (Writer)stringWriter);
        return stringWriter.toString();
    }

    private static long getSize(Element element) {
        String string = element.getChildText("size");
        if (string == null) {
            return 0L;
        }
        return new Long(string);
    }

    Product getCoreProductData(Element element, String string) throws IOException {
        String string2 = element.getChildText("productName");
        int n = new Integer(element.getChildText("productNumber"));
        String string3 = element.getChildText("productVersion");
        boolean bl = Boolean.valueOf(element.getChildText("isControllingProduct"));
        String string4 = element.getChildText("releaseFamily");
        String string5 = "NO_DESCRIPTION";
        if (element.getChildText("releaseDescription") != null) {
            string5 = element.getChildText("releaseDescription");
        }
        return this.productContainer.createProduct(string2, n, string3, bl, string, string4, string5);
    }

    ComponentData[] getDependsOnComponents(Element element) {
        ArrayList<ComponentData> arrayList = new ArrayList<ComponentData>();
        Element element2 = element.getChild("dependsOn");
        for (Object e : element2.getChildren()) {
            Element element3 = (Element)e;
            String[] stringArray = XMLParserImpl.getPlatformListFromElement(element3);
            ComponentData componentData = this.componentContainer.createComponent(FilenameUtils.removeExtension((String)element3.getChildText("name")), element3.getChildText("version"), XMLParserImpl.getLocale(element3), stringArray);
            arrayList.add(componentData);
        }
        return arrayList.toArray(new ComponentData[arrayList.size()]);
    }

    void mergeAdditionalProductData(Product product, Element element, String string) throws IOException {
        Object object;
        Object object22;
        String[] stringArray = XMLParserImpl.getPlatformListFromElement(element);
        ComponentData[] componentDataArray = this.getDependsOnComponents(element);
        ArrayList<Product> arrayList = new ArrayList<Product>();
        for (Object object22 : element.getChild("requiredProducts").getChildren()) {
            object = (Element)object22;
            Product product2 = this.getCoreProductData((Element)object, string);
            arrayList.add(product2);
        }
        String[] stringArray2 = XMLParserImpl.getUsageListFromElement(element);
        object22 = element.getChildText("releaseFamily");
        object = "NO_DESCRIPTION";
        if (element.getChildText("releaseDescription") != null) {
            object = element.getChildText("releaseDescription");
        }
        this.productContainer.merge(product, componentDataArray, arrayList.toArray(new Product[arrayList.size()]), stringArray, stringArray2, (String)object22, (String)object);
    }

    private static String[] getUsageListFromElement(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element2 = element.getChild("installerUsage");
        if (element2 == null) {
            arrayList.add(INSTALLER_TYPE_PROFESSIONAL);
        } else {
            for (Object e : element2.getChildren()) {
                Element element3 = (Element)e;
                arrayList.add(element3.getText());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static String[] getPlatformListFromElement(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element2 = element.getChild("platformList");
        String string = element.getChildText("platform");
        if (element2 != null) {
            List list = element2.getChildren("platform");
            for (Element element3 : list) {
                arrayList.add(element3.getText());
            }
        } else if (string != null) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

