/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;

abstract class AbstractRegisterUninstaller
implements Command {
    private static final String INSTALL_LOCATION_NAME = "InstallLocation";
    private static final String UNINSTALL_STRING_NAME = "UninstallString";
    private static final String DISPLAY_NAME_NAME = "DisplayName";
    private static final String DISPLAY_VERSION_NAME = "DisplayVersion";
    private static final String URLINFO_ABOUT_NAME = "URLInfoAbout";
    private static final String DISPLAY_ICON_NAME = "DisplayIcon";
    private static final String PUBLISHER_NAME = "Publisher";
    private static final String HELP_LINK_NAME = "HelpLink";
    private static final String COMMENTS_NAME = "Comments";
    private final Registry registry;
    private final AppLogger appLogger;

    AbstractRegisterUninstaller(Registry registry, AppLogger appLogger) {
        this.registry = registry;
        this.appLogger = appLogger;
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.appLogger.logMsg("Registering Uninstaller");
        this.setDisplayName();
        this.setUninstallString(file);
        this.setDisplayIcon(file);
        this.setInstallLocation(file);
        this.setDisplayVersion();
        this.setURLInfoAbout();
        this.setPublisher();
        this.setHelpLink();
        this.setComments();
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.appLogger.logMsg("Unregistering Uninstaller");
        this.appLogger.logMsg("removing registry key HKEY_LOCAL_MACHINE\\" + this.getUninstallVersionSubKey());
        this.registry.deleteRegKeyIfValueMatches("HKEY_LOCAL_MACHINE", this.getUninstallVersionSubKey(), INSTALL_LOCATION_NAME, file.getAbsolutePath());
    }

    abstract String getUninstallVersionSubKey();

    protected void setUninstallKeyValue(String string, String string2) {
        this.appLogger.logMsg("setting registry key HKEY_LOCAL_MACHINE\\" + this.getUninstallVersionSubKey() + "\\" + string + " to " + string2);
        this.registry.setRegKeyValue("HKEY_LOCAL_MACHINE", this.getUninstallVersionSubKey(), string, string2);
    }

    private void setComments() {
        String string = this.getComments();
        if (!string.equals("")) {
            this.setUninstallKeyValue(COMMENTS_NAME, string);
        }
    }

    private void setHelpLink() {
        String string = this.getHelpLink();
        if (!string.equals("")) {
            this.setUninstallKeyValue(HELP_LINK_NAME, string);
        }
    }

    private void setPublisher() {
        this.setUninstallKeyValue(PUBLISHER_NAME, this.getPublisher());
    }

    private void setURLInfoAbout() {
        String string = this.getURLInfoAbout();
        if (!string.equals("")) {
            this.setUninstallKeyValue(URLINFO_ABOUT_NAME, string);
        }
    }

    private void setDisplayIcon(File file) {
        File file2 = AbstractRegisterUninstaller.getAbsoluteFile(file, this.getPathToIconFile());
        this.setUninstallKeyValue(DISPLAY_ICON_NAME, file2.getAbsolutePath());
    }

    private void setUninstallString(File file) {
        this.setUninstallKeyValue(UNINSTALL_STRING_NAME, this.getUninstallString(file));
    }

    protected static File getAbsoluteFile(File file, String string) {
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            return new File(file, string);
        }
        return file2;
    }

    private void setInstallLocation(File file) {
        this.setUninstallKeyValue(INSTALL_LOCATION_NAME, this.getInstallLocation(file));
    }

    private void setDisplayName() {
        this.setUninstallKeyValue(DISPLAY_NAME_NAME, this.getDisplayName());
    }

    private void setDisplayVersion() {
        this.setUninstallKeyValue(DISPLAY_VERSION_NAME, this.getDisplayVersion());
    }

    abstract String getUninstallString(File var1);

    abstract String getInstallLocation(File var1);

    abstract String getHelpLink();

    abstract String getPublisher();

    abstract String getURLInfoAbout();

    abstract String getDisplayVersion();

    abstract String getPathToIconFile();

    abstract String getPathToUninstallExe();

    abstract String getDisplayName();

    abstract String getComments();
}

