/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.DesktopShortcuts;
import com.mathworks.install.command.FileProcessor;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.filefilter.FileFilterUtils;

final class DesktopShortcutCreator
implements FileProcessor {
    private final String sc;
    private final AppLogger theLogger;
    private String appRelease;
    private final DesktopShortcuts desktopShortcuts;
    private String comments;
    private boolean isMATLAB;

    DesktopShortcutCreator(String string, String string2, AppLogger appLogger, DesktopShortcuts desktopShortcuts, String string3, boolean bl) {
        this.sc = string;
        this.theLogger = appLogger;
        this.appRelease = string2;
        this.desktopShortcuts = desktopShortcuts;
        this.comments = string3;
        this.isMATLAB = bl;
    }

    @Override
    public void processFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.theLogger.logMsg("Creating desktop shortcut");
        this.theLogger.debugMsg("Filename: " + file.getAbsolutePath() + "; shortcut name: " + this.sc);
        this.desktopShortcuts.createShortcutOnDesktop(file, this.sc, this.appRelease, this.comments, this.isMATLAB);
    }

    @Override
    public void undoProcessFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        File file3 = this.desktopShortcuts.getDesktopFolder();
        File file4 = new File(file3, this.sc);
        String string = this.desktopShortcuts.getShortcutTargetPath(file4);
        this.theLogger.logMsg("Found Desktop shortcut target path : " + string);
        if (string != null && file.getAbsolutePath().equalsIgnoreCase(string)) {
            this.theLogger.logMsg("Deleting desktop shortcut");
            file4.delete();
            this.theLogger.logMsg("Deleted target: " + file.getAbsolutePath() + "; location: " + file4.getAbsolutePath());
        }
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return FileFilterUtils.fileFileFilter();
    }
}

