/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.RegisterAppPath;
import com.mathworks.install.command.Command;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;

final class RegisterApplicationCommand
implements Command {
    private final Registry registry;
    private final AppLogger appLogger;
    private final RegisterAppPath registerAppPath;

    RegisterApplicationCommand(Registry registry, AppLogger appLogger, RegisterAppPath registerAppPath) {
        this.registry = registry;
        this.appLogger = appLogger;
        this.registerAppPath = registerAppPath;
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        String string2 = this.registerAppPath.getSubKey(file.getAbsolutePath());
        String string3 = this.registerAppPath.getName();
        String string4 = this.registerAppPath.getKeyVal(file.getAbsolutePath());
        this.appLogger.logMsg("setting HKEY_LOCAL_MACHINE\\" + string2 + " to " + string4);
        this.registry.setRegKeyValue("HKEY_LOCAL_MACHINE", string2, string3, string4);
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        String string2 = this.registerAppPath.getSubKey(file.getAbsolutePath());
        String string3 = this.registerAppPath.getName();
        String string4 = this.registerAppPath.getKeyVal(file.getAbsolutePath());
        this.appLogger.debugMsg("removing HKEY_LOCAL_MACHINE\\" + string2);
        this.registry.deleteRegKeyIfValueMatches("HKEY_LOCAL_MACHINE", string2, string3, string4);
    }
}

