/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocSetDocumentBuilder;
import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.InstutilResourceKeys;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.transform.JDOMSource;

class DocLandingPageCommand
implements SharedDocSubCommand {
    static final FilenameFilter LANDING_PAGE_FILTER = new LandingPageFilter();
    private final IO io;
    private final DocDestination destination;

    DocLandingPageCommand(IO iO, DocDestination docDestination) {
        this.io = iO;
        this.destination = docDestination;
    }

    @Override
    public void handleProductsFound(File file, DocSetItemList docSetItemList) throws IOException, InterruptedException {
        this.buildLandingPage(file, docSetItemList, "");
        for (String string : docSetItemList.getLocaleSuffixes()) {
            this.buildLandingPage(file, docSetItemList, string);
        }
    }

    @Override
    public void handleNoProducts(File file) throws IOException, InterruptedException {
        File[] fileArray;
        for (File file2 : fileArray = this.io.listFiles(file, LANDING_PAGE_FILTER)) {
            this.io.deleteFile(file2);
        }
    }

    void buildLandingPage(File file, DocSetItemList docSetItemList, String string) throws IOException, InterruptedException {
        File file2 = new File(file, "templates/documentation-center.xsl");
        if (!this.io.isFile(file2)) {
            return;
        }
        Map<String, String> map = this.createXslParameters(file, string);
        DocSetDocumentBuilder docSetDocumentBuilder = new DocSetDocumentBuilder(docSetItemList);
        Document document = docSetDocumentBuilder.getDocument();
        try {
            byte[] byArray = this.doXslTransform(file2, document, map);
            String string2 = DocLandingPageCommand.getLandingPageName(string);
            File file3 = new File(file, string2);
            this.writeLandingPageFile(byArray, file3);
        }
        catch (IOException | InterruptedException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IOException("Unable to create documentation-center.html page", exception);
        }
    }

    private static String getLandingPageName(String string) {
        return string == null || string.trim().isEmpty() ? "documentation-center.html" : "documentation-center_" + string + ".html";
    }

    private byte[] doXslTransform(File file, Document document, Map<String, String> map) throws IOException, TransformerException {
        try (InputStream inputStream = this.getInputStream(file);){
            byte[] byArray = this.doXslTransform(inputStream, file.toURI().toString(), document, map);
            return byArray;
        }
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    protected byte[] doXslTransform(InputStream inputStream, String string, Document document, Map<String, String> map) throws IOException, TransformerException {
        StreamSource streamSource = new StreamSource(inputStream);
        streamSource.setSystemId(string);
        try {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                Object object2;
                Transformer transformer = TransformerFactory.newInstance().newTransformer(streamSource);
                for (Object object2 : map.entrySet()) {
                    transformer.setParameter(object2.getKey(), object2.getValue());
                }
                JDOMSource jDOMSource = new JDOMSource(document);
                object2 = new StreamResult(byteArrayOutputStream);
                object2.setSystemId(string);
                transformer.transform((Source)jDOMSource, (Result)object2);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    Map<String, String> createXslParameters(File file, String string) throws IOException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (string != null && !string.trim().isEmpty()) {
            linkedHashMap.put("locale", string);
        }
        linkedHashMap.put("destination", this.destination.toString().toLowerCase(Locale.ENGLISH));
        linkedHashMap.put("docRoot", file.getAbsolutePath());
        String string2 = this.getResourceString(InstutilResourceKeys.RELEASE);
        linkedHashMap.put("releaseversion", string2);
        File file2 = new File(file, "templates/release_info.txt");
        if (this.io.isFile(file2)) {
            String string3 = this.io.readFileToString(file2).trim();
            linkedHashMap.put("phaseoftherelease", string3);
        }
        return linkedHashMap;
    }

    protected String getResourceString(InstutilResourceKeys instutilResourceKeys) {
        return instutilResourceKeys.getBundleString();
    }

    protected void writeLandingPageFile(byte[] byArray, File file) throws IOException, InterruptedException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.io.createFileFromStream((InputStream)byteArrayInputStream, file, System.currentTimeMillis(), 420, new IOObserver[0]);
    }

    protected InputStream getInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private static class LandingPageFilter
    implements FilenameFilter {
        private LandingPageFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.matches("^documentation-center(_\\w+)?.html$");
        }
    }
}

