/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.input;

import com.mathworks.install.ComponentData;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DownloadLocationUtility {
    private static final String COMMON_FOLDER = "common";
    private static final String ARCHIVES_FOLDER = "archives";

    private DownloadLocationUtility() {
    }

    public static File getPathForReadingArchives(File file) {
        return DownloadLocationUtility.getArchivesFolderPath(file);
    }

    protected static File getLocationForComponentArchives(File file, ComponentData componentData) {
        ArrayList<String> arrayList = componentData.getPlatforms();
        String string = componentData.getLocale();
        if (string.isEmpty()) {
            if (arrayList.size() == 1) {
                return new File(DownloadLocationUtility.getArchivesFolderPath(file), arrayList.get(0));
            }
            return new File(DownloadLocationUtility.getArchivesFolderPath(file), COMMON_FOLDER);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        return new File(DownloadLocationUtility.getArchivesFolderPath(file), "doc_" + stringTokenizer.nextToken());
    }

    public static File getLocationForProductdata(File file, String string) {
        if (string.equals(COMMON_FOLDER)) {
            return new File(DownloadLocationUtility.getArchivesFolderPath(file), COMMON_FOLDER);
        }
        return new File(DownloadLocationUtility.getArchivesFolderPath(file), string);
    }

    private static File getArchivesFolderPath(File file) {
        return new File(file.getPath() + File.separator + ARCHIVES_FOLDER);
    }
}

