/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class OutlinePainter {
    private LineComputer OEAB = new LineComputer(this);
    private Hashtable S = new Hashtable();
    private int addPointer = 0;
    private int black = 0;

    OutlinePainter() {
    }

    void clear() {
        this.OEAB = new LineComputer(this);
        this.S = new Hashtable();
        this.black = 0;
        this.addPointer = 0;
    }

    boolean hasOutline() {
        return !this.S.isEmpty();
    }

    void paint(Graphics graphics) {
        if (this.hasOutline()) {
            Enumeration enumeration = this.S.elements();
            while (enumeration.hasMoreElements()) {
                StyleNode styleNode = (StyleNode)enumeration.nextElement();
                Vector vector = styleNode.rectangles;
                Vector vector2 = this.computeOutline(vector);
                Vector vector3 = new Polygons(this, vector2).getPolygons();
                if (vector3 == null) {
                    return;
                }
                Polygon polygon = null;
                graphics.setColor(styleNode.color);
                if (styleNode.color == null) {
                    graphics.setColor(Color.black);
                }
                int n = styleNode.width;
                int n2 = styleNode.style;
                int n3 = 0;
                while (n3 < vector3.size()) {
                    polygon = (Polygon)vector3.elementAt(n3);
                    Vector vector4 = new Polygons(this).getPolyLines(polygon);
                    Enumeration enumeration2 = vector4.elements();
                    while (enumeration2.hasMoreElements()) {
                        int n4;
                        MyLine myLine = (MyLine)enumeration2.nextElement();
                        int n5 = myLine.getP1().x;
                        int n6 = myLine.getP2().x;
                        int n7 = myLine.getP1().y;
                        int n8 = myLine.getP2().y;
                        int n9 = 1;
                        int n10 = 1;
                        n = styleNode.width;
                        n2 = styleNode.style;
                        if (n > 1) {
                            if (n5 == n6) {
                                if (polygon.contains(n5 + 1, (n7 + n8) / 2)) {
                                    n9 = -1;
                                }
                            } else if (polygon.contains((n5 + n6) / 2, n7 + 1)) {
                                n10 = -1;
                            }
                        }
                        if ((n2 = styleNode.style) == 148 | n2 == 149) {
                            n4 = 0;
                            int n11 = 0;
                            if (n9 == -1) {
                                n4 = -n;
                            }
                            if (n10 == -1) {
                                n11 = -n;
                            }
                            n = styleNode.width;
                            CSSUtil.drawStyledLine(graphics, n5 + n4, n7 + n11, n6 + n4, n8 + n11, n2, n);
                            continue;
                        }
                        if (styleNode.color == null) {
                            graphics.setColor(Color.black);
                        } else {
                            graphics.setColor(styleNode.color);
                        }
                        n = styleNode.width;
                        n2 = styleNode.style;
                        CSSUtil.drawStyledLine(graphics, n5, n7, n6, n8, n2);
                        if (n <= 1) continue;
                        n4 = 1;
                        while (n4 < n) {
                            if (n5 == n6) {
                                n5 += n9;
                                n6 += n9;
                                if (n7 < n8) {
                                    if (!polygon.contains(n5, n7 - 1)) {
                                        --n7;
                                    }
                                    if (!polygon.contains(n6, n8 + 1)) {
                                        ++n8;
                                    }
                                } else {
                                    if (!polygon.contains(n5, n7 + 1)) {
                                        ++n7;
                                    }
                                    if (!polygon.contains(n6, n8 - 1)) {
                                        --n8;
                                    }
                                }
                            } else {
                                n7 += n10;
                                n8 += n10;
                                if (n5 < n6) {
                                    if (!polygon.contains(n5 - 1, n7)) {
                                        --n5;
                                    }
                                    if (!polygon.contains(n6 + 1, n8)) {
                                        ++n6;
                                    }
                                } else {
                                    if (!polygon.contains(n5 + 1, n7)) {
                                        ++n5;
                                    }
                                    if (!polygon.contains(n6 - 1, n8)) {
                                        --n6;
                                    }
                                }
                            }
                            if (styleNode.color == null) {
                                graphics.setColor(Color.black);
                            } else {
                                graphics.setColor(styleNode.color);
                            }
                            n2 = styleNode.style;
                            CSSUtil.drawStyledLine(graphics, n5, n7, n6, n8, n2);
                            ++n4;
                        }
                    }
                    vector4 = null;
                    ++n3;
                }
                vector3 = null;
            }
            this.S.clear();
        }
        this.clear();
    }

    void addRectangle(CSSBox cSSBox, int n, int n2, int n3, int n4) {
        if (cSSBox == null) {
            return;
        }
        CSSBox cSSBox2 = cSSBox.parentBox;
        while ((cSSBox2.css.misc & 2) != 0 && cSSBox2.css.outline_width == 0) {
            cSSBox2 = cSSBox2.parentBox;
        }
        int n5 = cSSBox2.css.outline_width;
        Color color = cSSBox2.css.outline_color;
        if (color == null) {
            color = Color.black;
        }
        short s = cSSBox2.css.outline_style;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        StyleNode styleNode = null;
        if (this.S != null) {
            styleNode = (StyleNode)this.S.get(cSSBox2);
        }
        if (styleNode == null) {
            if (this.S == null) {
                this.S = new Hashtable();
            }
            styleNode = new StyleNode(this, cSSBox2, s, color, n5);
            this.S.put(cSSBox2, styleNode);
        }
        styleNode.addPointer(rectangle);
        rectangle.x += this.addPointer;
        rectangle.y += this.black;
    }

    Vector computeOutline(Vector vector) {
        Vector vector2 = null;
        if (this.hasOutline()) {
            vector2 = this.OEAB.computeLines(this.OEAB.digest(vector));
            vector.removeAllElements();
        }
        return vector2;
    }

    void drawBox(Graphics graphics, CSSBox cSSBox, int n, int n2) {
        this.translate(graphics, n, n2);
        cSSBox.paint(graphics);
        this.translate(graphics, -n, -n2);
    }

    void translate(Graphics graphics, int n, int n2) {
        graphics.translate(n, n2);
        this.addPointer += n;
        this.black += n2;
    }

    class StyleNode {
        int style;
        Color color;
        int width;
        CSSBox initiator;
        Vector rectangles;
        private final OutlinePainter this$0;

        public StyleNode(OutlinePainter outlinePainter, CSSBox cSSBox, int n, Color color, int n2) {
            this.this$0 = outlinePainter;
            this.initiator = cSSBox;
            this.style = n;
            this.color = color;
            this.width = n2;
            this.rectangles = new Vector();
        }

        public void addPointer(Rectangle rectangle) {
            this.rectangles.addElement(rectangle);
        }

        public boolean equals(StyleNode styleNode) {
            return this.initiator.equals(styleNode.initiator);
        }
    }

    class Polygons {
        private Hashtable I;
        private Vector OEAB;
        private final OutlinePainter this$0;

        public Polygons(OutlinePainter outlinePainter, Vector vector) {
            this.this$0 = outlinePainter;
            if (vector != null) {
                this.OEAB(vector);
                this.I(vector);
            }
        }

        public Polygons(OutlinePainter outlinePainter) {
            this.this$0 = outlinePainter;
        }

        public Vector getPolygons() {
            return this.OEAB;
        }

        private void I(Vector vector) {
            this.OEAB = new Vector();
            Enumeration enumeration = vector.elements();
            if (!enumeration.hasMoreElements()) {
                return;
            }
            MyLine myLine = (MyLine)enumeration.nextElement();
            while (enumeration.hasMoreElements() && !this.I.isEmpty()) {
                boolean bl = true;
                while (bl && enumeration.hasMoreElements()) {
                    new String();
                    new String();
                    String string = String.valueOf(myLine.getP1().x).concat(String.valueOf(myLine.getP1().y));
                    if (this.I.containsKey(string) && ((PointNode)this.I.get((Object)string)).endpoints[0].equals(myLine.getP2())) {
                        bl = false;
                        continue;
                    }
                    myLine = (MyLine)enumeration.nextElement();
                }
                Point point = myLine.getP1();
                Point point2 = myLine.getP2();
                new String();
                new String();
                String string = String.valueOf(point.x).concat(String.valueOf(point.y));
                new String();
                new String();
                String string2 = String.valueOf(point2.x).concat(String.valueOf(point2.y));
                PointNode pointNode = (PointNode)this.I.get(string2);
                Polygon polygon = new Polygon();
                polygon.addPoint(point.x, point.y);
                this.I.remove(string);
                while (pointNode != null) {
                    polygon.addPoint(point2.x, point2.y);
                    this.I.remove(string2);
                    Point point3 = point2;
                    point2 = !pointNode.endpoints[0].equals(point) ? pointNode.endpoints[0] : pointNode.endpoints[1];
                    point = point3;
                    new String();
                    new String();
                    string2 = String.valueOf(point2.x).concat(String.valueOf(point2.y));
                    pointNode = (PointNode)this.I.get(string2);
                }
                this.OEAB.addElement(polygon);
            }
        }

        private void OEAB(Vector vector) {
            this.I = new Hashtable();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                PointNode pointNode;
                MyLine myLine = (MyLine)enumeration.nextElement();
                Point point = myLine.getP1();
                Point point2 = myLine.getP2();
                new String();
                new String();
                String string = String.valueOf(point.x).concat(String.valueOf(point.y));
                if (this.I.containsKey(string)) {
                    pointNode = (PointNode)this.I.get(string);
                    pointNode.endpoints[1] = point2;
                } else {
                    pointNode = new PointNode(this, string);
                    pointNode.endpoints[0] = point2;
                    this.I.put(string, pointNode);
                }
                new String();
                new String();
                String string2 = String.valueOf(point2.x).concat(String.valueOf(point2.y));
                pointNode = null;
                if (this.I.containsKey(string2)) {
                    pointNode = (PointNode)this.I.get(string2);
                    pointNode.endpoints[1] = point;
                    continue;
                }
                pointNode = new PointNode(this, string2);
                pointNode.endpoints[0] = point;
                this.I.put(string2, pointNode);
            }
        }

        Vector getPolyLines(Polygon polygon) {
            Vector<MyLine> vector = new Vector<MyLine>();
            if (polygon.npoints >= 2) {
                MyLine myLine;
                int n = 1;
                while (n < polygon.npoints) {
                    myLine = new MyLine(this.this$0, polygon.xpoints[n - 1], polygon.ypoints[n - 1], polygon.xpoints[n], polygon.ypoints[n]);
                    vector.addElement(myLine);
                    ++n;
                }
                myLine = new MyLine(this.this$0, polygon.xpoints[polygon.npoints - 1], polygon.ypoints[polygon.npoints - 1], polygon.xpoints[0], polygon.ypoints[0]);
                vector.addElement(myLine);
            }
            return vector;
        }

        class PointNode {
            String location;
            Point[] endpoints;
            private final Polygons this$1;

            public PointNode(Polygons polygons, String string) {
                this.this$1 = polygons;
                this.location = string;
                this.endpoints = new Point[2];
            }
        }
    }

    class LineComputer {
        Vector lines;
        Vector outline;
        int xoffset;
        int yoffset;
        private final OutlinePainter this$0;

        public LineComputer(OutlinePainter outlinePainter) {
            this.this$0 = outlinePainter;
            this.lines = null;
            this.xoffset = 5;
            this.yoffset = 5;
        }

        public LineComputer(OutlinePainter outlinePainter, Vector vector) {
            this.this$0 = outlinePainter;
            this.lines = null;
            this.xoffset = 5;
            this.yoffset = 5;
            if (vector != null) {
                this.lines = this.digest(vector);
                this.outline = this.computeLines(this.lines);
            } else if (Debug.trace) {
                Debug.trace((String)"WARNING: rectangle vector is null");
            }
        }

        Vector digest(Vector vector) {
            Rectangle rectangle = null;
            Vector<MyLine> vector2 = new Vector<MyLine>();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                rectangle = (Rectangle)enumeration.nextElement();
                vector2.addElement(new MyLine(this.this$0, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y));
                vector2.addElement(new MyLine(this.this$0, rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height));
                vector2.addElement(new MyLine(this.this$0, rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height));
                vector2.addElement(new MyLine(this.this$0, rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height));
            }
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                MyLine myLine = (MyLine)enumeration2.nextElement();
            }
            return vector2;
        }

        Vector computeLines(Vector vector) {
            this.outline = null;
            boolean bl = true;
            while (bl) {
                bl = false;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    MyLine myLine;
                    if (this.outline == null) {
                        this.outline = new Vector();
                        int n = 0;
                        while (n < 4) {
                            myLine = (MyLine)enumeration.nextElement();
                            this.outline.addElement(myLine);
                            ++n;
                        }
                    }
                    if (!enumeration.hasMoreElements()) break;
                    myLine = (MyLine)enumeration.nextElement();
                    MyLine[] myLineArray = new MyLine[4];
                    boolean bl2 = false;
                    Enumeration enumeration2 = this.outline.elements();
                    while (enumeration2.hasMoreElements() && !bl2) {
                        MyLine myLine2 = (MyLine)enumeration2.nextElement();
                        if (this.verticallyAligned(myLine, myLine2)) {
                            bl2 = true;
                            this.outline.removeElement(myLine2);
                            myLineArray = this.cutVerticalLines(myLine, myLine2);
                            continue;
                        }
                        if (!this.horizontallyAligned(myLine, myLine2)) continue;
                        bl2 = true;
                        this.outline.removeElement(myLine2);
                        myLineArray = this.cutHorizontalLines(myLine, myLine2);
                    }
                    if (!bl2) {
                        this.outline.insertElementAt(myLine, 0);
                        continue;
                    }
                    bl = true;
                    int n = 0;
                    while (n < myLineArray.length) {
                        if (myLineArray[n] != null) {
                            this.outline.insertElementAt(myLineArray[n], 0);
                        }
                        ++n;
                    }
                }
                if (!bl) continue;
                vector = this.outline;
                this.outline = new Vector();
            }
            return this.outline;
        }

        boolean verticallyAligned(MyLine myLine, MyLine myLine2) {
            if (myLine.getP1().x == myLine.getP2().x && myLine2.getP1().x == myLine2.getP2().x && Math.abs(myLine.getP1().x - myLine2.getP1().x) <= this.xoffset) {
                int n;
                int n2;
                int n3;
                int n4 = myLine.getP2().y;
                int n5 = myLine.getP1().y;
                if (n4 < n5) {
                    n3 = n4;
                    n4 = n5;
                    n5 = n3;
                }
                if ((n2 = myLine2.getP2().y) < (n = myLine2.getP1().y)) {
                    n3 = n2;
                    n2 = n;
                    n = n3;
                }
                if (n4 - n5 <= this.xoffset | n2 - n <= this.xoffset) {
                    return false;
                }
                if ((n5 <= n && n <= n4) | (n < n5 && n5 <= n2)) {
                    return this.xoffset <= 0 || myLine.getP1().x == myLine2.getP1().x || !(n == n4 | n5 == n2);
                }
            }
            return false;
        }

        boolean horizontallyAligned(MyLine myLine, MyLine myLine2) {
            if (myLine.getP1().y == myLine.getP2().y && myLine2.getP1().y == myLine2.getP2().y && Math.abs(myLine.getP1().y - myLine2.getP1().y) <= this.yoffset) {
                int n;
                int n2;
                int n3;
                int n4 = myLine.getP2().x;
                int n5 = myLine.getP1().x;
                if (n4 < n5) {
                    n3 = n4;
                    n4 = n5;
                    n5 = n3;
                }
                if ((n2 = myLine2.getP2().x) < (n = myLine2.getP1().x)) {
                    n3 = n2;
                    n2 = n;
                    n = n3;
                }
                if (n4 - n5 <= this.yoffset | n2 - n <= this.yoffset) {
                    return false;
                }
                if ((n5 <= n && n <= n4) | (n < n5 && n5 <= n2)) {
                    return this.yoffset <= 0 || myLine.getP1().y == myLine2.getP1().y || !(n == n4 | n5 == n2);
                }
            }
            return false;
        }

        MyLine[] cutVerticalLines(MyLine myLine, MyLine object) {
            Object object2;
            Object object3;
            MyLine[] myLineArray = new MyLine[4];
            if (Math.abs(myLine.getP2().y - myLine.getP1().y) < Math.abs(((MyLine)object).getP2().y - ((MyLine)object).getP1().y)) {
                object3 = myLine;
                myLine = object;
                object = object3;
            }
            object3 = myLine.getP1();
            Object object4 = myLine.getP2();
            Point point = ((MyLine)object).getP1();
            Object object5 = ((MyLine)object).getP2();
            if (((Point)object3).y > ((Point)object4).y) {
                object2 = object3;
                object3 = object4;
                object4 = object2;
            }
            if (point.y > ((Point)object5).y) {
                object2 = point;
                point = object5;
                object5 = object2;
            }
            int n = ((Point)object3).y;
            int n2 = ((Point)object4).y;
            int n3 = point.y;
            int n4 = ((Point)object5).y;
            myLineArray[0] = null;
            myLineArray[1] = null;
            myLineArray[2] = null;
            myLineArray[3] = null;
            if (n <= n3 && n3 <= n2) {
                if (n3 == n) {
                    if (n4 == n2) {
                        if (this.xoffset > 0 && ((Point)object3).x != point.x) {
                            myLineArray[0] = new MyLine(this.this$0, ((Point)object3).x, ((Point)object3).y, point.x, point.y);
                            myLineArray[1] = new MyLine(this.this$0, ((Point)object4).x, ((Point)object4).y, ((Point)object5).x, ((Point)object5).y);
                        }
                    } else if (this.xoffset > 0 && ((Point)object3).x != point.x) {
                        myLineArray[1] = new MyLine(this.this$0, ((Point)object3).x, ((Point)object3).y, point.x, point.y);
                        myLineArray[2] = new MyLine(this.this$0, ((Point)object5).x, ((Point)object5).y, ((Point)object4).x, ((Point)object5).y);
                        myLineArray[3] = new MyLine(this.this$0, ((Point)object3).x, ((Point)object5).y, ((Point)object4).x, ((Point)object4).y);
                    } else {
                        myLineArray[0] = new MyLine(this.this$0, (Point)object5, (Point)object4);
                    }
                } else if (n3 == n2) {
                    if (this.xoffset <= 0 || ((Point)object3).x == point.x) {
                        myLineArray[0] = new MyLine(this.this$0, (Point)object3, (Point)object5);
                    }
                } else if (this.xoffset > 0 && ((Point)object3).x != point.x) {
                    myLineArray[0] = new MyLine(this.this$0, ((Point)object3).x, ((Point)object3).y, ((Point)object3).x, point.y);
                    myLineArray[1] = new MyLine(this.this$0, point.x, point.y, ((Point)object3).x, point.y);
                    if (n2 > n4) {
                        myLineArray[2] = new MyLine(this.this$0, ((Point)object5).x, ((Point)object5).y, ((Point)object3).x, ((Point)object5).y);
                        myLineArray[3] = new MyLine(this.this$0, ((Point)object3).x, ((Point)object5).y, ((Point)object4).x, ((Point)object4).y);
                    } else {
                        myLineArray[2] = new MyLine(this.this$0, ((Point)object4).x, ((Point)object4).y, ((Point)object5).x, ((Point)object4).y);
                        if (n2 != n4) {
                            myLineArray[3] = new MyLine(this.this$0, ((Point)object5).x, ((Point)object4).y, ((Point)object5).x, ((Point)object5).y);
                        }
                    }
                } else {
                    myLineArray[0] = new MyLine(this.this$0, (Point)object3, point);
                    myLineArray[1] = n2 == n4 ? null : new MyLine(this.this$0, (Point)object4, (Point)object5);
                }
            } else if (n3 < n && n <= n4) {
                if (n == n4) {
                    if (this.xoffset <= 0 || ((Point)object3).x == point.x) {
                        myLineArray[0] = new MyLine(this.this$0, point, (Point)object4);
                    }
                } else if (this.yoffset > 0 && ((Point)object3).x != point.x) {
                    myLineArray[0] = new MyLine(this.this$0, point.x, point.y, point.x, ((Point)object3).y);
                    myLineArray[1] = new MyLine(this.this$0, point.x, ((Point)object3).y, ((Point)object3).x, ((Point)object3).y);
                    myLineArray[2] = new MyLine(this.this$0, ((Point)object5).x, ((Point)object5).y, ((Point)object4).x, ((Point)object5).y);
                    myLineArray[3] = new MyLine(this.this$0, ((Point)object4).x, ((Point)object5).y, ((Point)object4).x, ((Point)object4).y);
                } else {
                    myLineArray[0] = new MyLine(this.this$0, point, (Point)object3);
                    myLineArray[1] = new MyLine(this.this$0, (Point)object5, (Point)object4);
                }
            }
            return myLineArray;
        }

        MyLine[] cutHorizontalLines(MyLine myLine, MyLine object) {
            Object object2;
            Object object3;
            MyLine[] myLineArray = new MyLine[4];
            if (Math.abs(myLine.getP2().x - myLine.getP1().x) < Math.abs(((MyLine)object).getP2().x - ((MyLine)object).getP1().x)) {
                object3 = myLine;
                myLine = object;
                object = object3;
            }
            object3 = myLine.getP1();
            Object object4 = myLine.getP2();
            Point point = ((MyLine)object).getP1();
            Object object5 = ((MyLine)object).getP2();
            if (((Point)object3).x > ((Point)object4).x) {
                object2 = object3;
                object3 = object4;
                object4 = object2;
            }
            if (point.x > ((Point)object5).x) {
                object2 = point;
                point = object5;
                object5 = object2;
            }
            int n = ((Point)object3).x;
            int n2 = ((Point)object4).x;
            int n3 = point.x;
            int n4 = ((Point)object5).x;
            myLineArray[3] = null;
            myLineArray[2] = null;
            myLineArray[1] = null;
            myLineArray[0] = null;
            if (n <= n3 && n3 <= n2) {
                if (n3 == n) {
                    if (n4 == n2) {
                        if (this.yoffset > 0 && ((Point)object3).y != point.y) {
                            myLineArray[0] = new MyLine(this.this$0, ((Point)object3).x, ((Point)object3).y, point.x, point.y);
                            myLineArray[1] = new MyLine(this.this$0, ((Point)object4).x, ((Point)object4).y, ((Point)object5).x, ((Point)object5).y);
                        }
                    } else if (this.yoffset > 0 && ((Point)object3).y != point.y) {
                        myLineArray[1] = new MyLine(this.this$0, ((Point)object3).x, ((Point)object3).y, point.x, point.y);
                        myLineArray[2] = new MyLine(this.this$0, ((Point)object5).x, ((Point)object5).y, ((Point)object5).x, ((Point)object4).y);
                        myLineArray[3] = new MyLine(this.this$0, ((Point)object5).x, ((Point)object4).y, ((Point)object4).x, ((Point)object4).y);
                    } else {
                        myLineArray[0] = new MyLine(this.this$0, (Point)object5, (Point)object4);
                    }
                } else if (n3 != n2) {
                    if (this.yoffset > 0 && ((Point)object3).y != point.y) {
                        myLineArray[0] = new MyLine(this.this$0, ((Point)object3).x, ((Point)object3).y, point.x, ((Point)object3).y);
                        myLineArray[1] = new MyLine(this.this$0, point.x, ((Point)object3).y, point.x, point.y);
                        if (n2 > n4) {
                            myLineArray[2] = new MyLine(this.this$0, ((Point)object5).x, ((Point)object5).y, ((Point)object5).x, ((Point)object4).y);
                            myLineArray[3] = new MyLine(this.this$0, ((Point)object5).x, ((Point)object4).y, ((Point)object4).x, ((Point)object4).y);
                        } else {
                            myLineArray[2] = new MyLine(this.this$0, ((Point)object4).x, ((Point)object4).y, ((Point)object4).x, ((Point)object5).y);
                            if (n4 != n2) {
                                myLineArray[3] = new MyLine(this.this$0, ((Point)object4).x, ((Point)object5).y, ((Point)object5).x, ((Point)object5).y);
                            }
                        }
                    } else {
                        myLineArray[0] = new MyLine(this.this$0, (Point)object3, point);
                        myLineArray[1] = n2 == n4 ? null : new MyLine(this.this$0, (Point)object4, (Point)object5);
                    }
                } else if (n3 == n2 && (this.yoffset <= 0 || ((Point)object3).y == point.y)) {
                    myLineArray[0] = new MyLine(this.this$0, (Point)object3, (Point)object5);
                }
            } else if (n3 < n && n <= n4) {
                if (n == n4) {
                    if (this.yoffset > 0 && ((Point)object3).y != point.y) {
                        myLineArray[0] = myLine;
                        myLineArray[1] = object;
                    } else {
                        myLineArray[0] = new MyLine(this.this$0, point, (Point)object4);
                    }
                } else if (this.yoffset > 0 && ((Point)object3).y != point.y) {
                    myLineArray[0] = new MyLine(this.this$0, point.x, point.y, ((Point)object3).x, point.y);
                    myLineArray[1] = new MyLine(this.this$0, ((Point)object3).x, point.y, ((Point)object3).x, ((Point)object3).y);
                    myLineArray[2] = new MyLine(this.this$0, ((Point)object5).x, ((Point)object5).y, ((Point)object5).x, ((Point)object4).y);
                    myLineArray[3] = new MyLine(this.this$0, ((Point)object5).x, ((Point)object4).y, ((Point)object4).x, ((Point)object4).y);
                } else {
                    myLineArray[0] = new MyLine(this.this$0, point, (Point)object3);
                    myLineArray[1] = new MyLine(this.this$0, (Point)object5, (Point)object4);
                }
            }
            return myLineArray;
        }
    }

    class MyLine {
        private Point OEAB;
        private Point I;
        private final OutlinePainter this$0;

        public MyLine(OutlinePainter outlinePainter) {
            this.this$0 = outlinePainter;
            this.OEAB = null;
            this.I = null;
        }

        public MyLine(OutlinePainter outlinePainter, Point point, Point point2) {
            this.this$0 = outlinePainter;
            this.OEAB = point;
            this.I = point2;
        }

        public MyLine(OutlinePainter outlinePainter, int n, int n2, int n3, int n4) {
            this.this$0 = outlinePainter;
            this.OEAB = new Point(n, n2);
            this.I = new Point(n3, n4);
        }

        public Point getP1() {
            return this.OEAB;
        }

        public Point getP2() {
            return this.I;
        }
    }
}

