/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSManager;
import ice.pilots.html4.CSSMatcher;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.ComponentFactory;
import ice.pilots.html4.CoordsList;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DNodeListeners;
import ice.pilots.html4.DOM;
import ice.pilots.html4.DOMBuilder;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.DefaultActionHandler;
import ice.pilots.html4.DefaultEventHandler;
import ice.pilots.html4.DocAction;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.FormTypeElement;
import ice.pilots.html4.FramesDivider;
import ice.pilots.html4.FramesetData;
import ice.pilots.html4.Lex2;
import ice.pilots.html4.LexCallback;
import ice.pilots.html4.ObjectPool;
import ice.pilots.html4.OnresizeListener;
import ice.pilots.html4.RefreshItem;
import ice.pilots.html4.Search;
import ice.pilots.html4.StormData;
import ice.pilots.html4.ThePrinter;
import ice.pilots.html4.TheView;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Pilot;
import ice.storm.Scripter;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.ICEException;
import ice.util.alg.CharKit;
import ice.util.alg.HashArray;
import ice.util.io.IOKit;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventListener;

public class ThePilot
extends Pilot {
    private Object NO_SYNCHRONIZATION = new Object();
    private boolean OEAB = false;
    private boolean TRUE;
    StormData sdata;
    boolean isFromHistory = false;
    boolean isLoadedSynchronously = false;
    private DDocument addChild;
    private CSSLayout addColorDefinition;
    ObjectPool objectPool;
    private ComponentFactory addComponentListener;
    FramesetData framesetData;
    private boolean addElement = false;
    public static final boolean viewNoframes = Defs.booleanProperty((String)"ice.pilots.html4.view_noframes");
    private String addEventListener = null;
    private String addFramesetChild = null;
    private boolean addMouseListener = false;
    Object[] persistentDomListeners;
    DefaultEventHandler defaultEventHandler;
    private Lex2 addMouseMotionListener;
    private boolean allowedToRunHandler;
    private boolean append = true;
    volatile int noLayoutUpdate;
    HashArray tmpBodyEventHandlers;

    public void init(String string) {
        block3: {
            super.init(string);
            this.sdata = StormData.get(this.getStorm());
            this.addElement = this.sdata.getLoadSingleOnly();
            if (!"none".equalsIgnoreCase(string)) {
                try {
                    this.addComponentListener = (ComponentFactory)Class.forName("ice.pilots.html4." + string + ".TheFactory").newInstance();
                }
                catch (Exception exception) {
                    if (!Debug.ex) break block3;
                    Debug.ex((Throwable)exception);
                }
            }
        }
        this.addEventListener = Defs.sysProperty((String)"ice.pilots.html4.defaultEncoding");
        this.addChild = DOM.getInstance(this.sdata).createDDocument(this, true);
        this.objectPool = new ObjectPool(this);
        String string2 = this.addComponentListener == null ? "none" : this.addComponentListener.getMedia();
        this.addColorDefinition = this.createCSSLayout(string2, this.addChild);
        this.defaultEventHandler = new DefaultActionHandler(this);
    }

    public final boolean isDisposed() {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            boolean bl = this.TRUE;
            return bl;
        }
    }

    public void beforeUnload() {
        DElement dElement = !this.addChild.isFrameset ? this.addChild.getDBody() : ThePilot.NO_SYNCHRONIZATION(this.addChild.getDocumentDElement());
        this.addChild.processEvent(14, dElement);
    }

    private static DElement NO_SYNCHRONIZATION(DElement dElement) {
        DElement dElement2 = null;
        DNode dNode = dElement.getLastDChild();
        while (dNode != null) {
            if (dNode.getNameId() == 34) {
                DElement dElement3 = (DElement)dNode;
                dElement2 = ThePilot.NO_SYNCHRONIZATION(dElement3);
                if (dElement2 != null) break;
                String string = dElement3.getAttribute("onunload");
                if (string != null) {
                    dElement2 = dElement3;
                    break;
                }
            }
            dNode = dNode.prev;
        }
        return dElement2;
    }

    public void dispose() {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            if (this.TRUE) {
                if (Debug.trace) {
                    Debug.traceStack((String)"Double dispose, please report this to ICEsoft");
                }
                return;
            }
            this.TRUE = true;
        }
        FramesetData framesetData = this.framesetData;
        if (framesetData != null) {
            framesetData.dispose();
        }
        this.framesetData = null;
        this.persistentDomListeners = null;
        this.defaultEventHandler = null;
        if (this.addComponentListener != null) {
            this.addComponentListener.dispose();
        }
        this.addColorDefinition.clear();
        this.objectPool.dispose();
        this.addChild.clear();
        super.dispose();
    }

    protected CSSLayout createCSSLayout(String string, DDocument dDocument) {
        CSSMatcher cSSMatcher = new CSSMatcher(string, this.sdata, dDocument);
        CSSLayout cSSLayout = null;
        if (string.equals("screen") || string.equals("none")) {
            cSSLayout = new CSSLayout(this.sdata, dDocument, cSSMatcher);
        } else if (string.equals("print")) {
            cSSLayout = new ThePrinter(this.sdata, dDocument, cSSMatcher).getCSSLayout();
        } else {
            throw new IllegalArgumentException();
        }
        return cSSLayout;
    }

    public Dimension getDocumentDimension(Dimension dimension) {
        dimension.width = this.addColorDefinition.getWidth();
        dimension.height = this.addColorDefinition.getHeight();
        return dimension;
    }

    public Dimension getViewDimension(Dimension dimension) {
        if (this.addColorDefinition.docPane != null) {
            dimension.width = this.addColorDefinition.docPane.getPaneWidth();
            dimension.height = this.addColorDefinition.docPane.getPaneHeight();
        }
        return dimension;
    }

    public void setEncoding(String string) {
        this.addEventListener = string;
    }

    public String getEncoding() {
        return this.addEventListener;
    }

    public String getPageInfo(String string) {
        return this.addChild.getHttpProperty("_http_" + string);
    }

    public Component createComponent() {
        DocPaneXml docPaneXml;
        String string = (String)this.getViewportProperty("encoding");
        if (string != null) {
            this.addEventListener = string;
        }
        if (this.addComponentListener != null && (docPaneXml = this.addComponentListener.createDocPane()) != null) {
            int n = 0;
            String string2 = (String)this.getViewportProperty("scrolling");
            if (string2 != null) {
                if (string2.equalsIgnoreCase("yes")) {
                    n = 1;
                } else if (string2.equalsIgnoreCase("no")) {
                    n = 2;
                }
            }
            docPaneXml.init(n);
            docPaneXml.bind(this, this.addColorDefinition);
            return docPaneXml.getPaneComponent();
        }
        return null;
    }

    public StormPrinter createPrinter() {
        CSSLayout cSSLayout = this.createCSSLayout("print", this.addChild);
        return new ThePrinter(cSSLayout, this.getPilotViewport());
    }

    void putBaseUrl(String string) {
        this.getPilotViewport().setBaseUrl(string);
    }

    public boolean refExists(String string) {
        return this.addColorDefinition.refExists(string);
    }

    public void gotoRef(String string) {
        DocPaneXml docPaneXml = this.addColorDefinition.docPane;
        if (docPaneXml == null) {
            return;
        }
        DNode dNode = null;
        if (string == null) {
            docPaneXml.setScrollPosition(0, 0);
            dNode = this.addChild.getDBody();
        } else {
            int n = this.addColorDefinition.getRefPos(string);
            if (n >= 0) {
                docPaneXml.setScrollPosition(0, n);
                dNode = string != null ? this.addColorDefinition.getRefNode(string) : this.addChild.getDBody();
            } else if ("top".equalsIgnoreCase(string)) {
                docPaneXml.setScrollPosition(0, 0);
                dNode = this.addChild.getDBody();
            }
        }
        if (dNode != null) {
            this.addChild.processEvent(30, dNode);
        }
    }

    public final Document getDocument() {
        return this.getDDocument();
    }

    public DDocument getDDocument() {
        return this.addChild;
    }

    final CSSLayout getCSSLayout() {
        return this.addColorDefinition;
    }

    public TheView getView() {
        return this.addColorDefinition.theView;
    }

    public DocPane getDocPane() {
        return this.addColorDefinition.docPane;
    }

    public String getSelectedText() {
        return this.addColorDefinition.selection.toString();
    }

    public Search getSearch() {
        return new Search(this.addChild, this.addColorDefinition);
    }

    Object doScriptEval(String string, String string2, String string3, int n) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        Scripter scripter = this.getStorm().getScripter(string);
        if (scripter == null) {
            return null;
        }
        return scripter.eval(this.getPilotViewport(), string2, string3, n);
    }

    private boolean OEAB(String string, Object object, DynamicObject dynamicObject, DynamicObject dynamicObject2) {
        Scripter scripter = this.getStorm().getScripter(string);
        if (scripter == null) {
            return true;
        }
        return scripter.evalEventHandler(this.getPilotViewport(), dynamicObject2, object, dynamicObject);
    }

    void do_document_write(String string) {
        boolean bl = false;
        if (this.addMouseMotionListener == null) {
            Object object;
            Viewport viewport = this.getPilotViewport();
            Viewport viewport2 = viewport.getContextViewport();
            String string2 = null;
            if (viewport2 != null) {
                string2 = viewport2.getBaseUrl();
            }
            this.getStorm().clearViewportContent("text/html", viewport);
            if (viewport == viewport2) {
                object = this.NO_SYNCHRONIZATION;
                synchronized (object) {
                    this.OEAB = true;
                }
            }
            viewport.setLocationUrl(string2);
            object = new DOMBuilder(this.addChild, this);
            this.addMouseMotionListener = new Lex2((LexCallback)object);
            this.allowedToRunHandler = true;
            bl = true;
        }
        this.addMouseMotionListener.appendGeneratedContent(string);
        try {
            this.addMouseMotionListener.parse(bl, false);
        }
        catch (IOException iOException) {
            Debug.ex((Throwable)iOException);
        }
    }

    void do_document_close() {
        if (this.addMouseMotionListener != null && this.allowedToRunHandler) {
            block3: {
                this.allowedToRunHandler = false;
                try {
                    this.addMouseMotionListener.parse(false, true);
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block3;
                    Debug.ex((Throwable)iOException);
                }
            }
            this.addMouseMotionListener = null;
            this.addEventListener(null);
        }
    }

    private void TRUE() {
        this.addColorDefinition.doImageAnimation = Defs.sysPropertyBoolean((String)"ice.pilots.html4.imageAnimation", (boolean)true);
        try {
            int n;
            String string = Defs.sysProperty((String)"ice.pilots.html4.minFontSize");
            if (string != null && (n = CSSUtil.parseInt(string, -1)) >= 4) {
                this.sdata.fontCache.setMinFontSize(n);
            }
            if ((string = Defs.sysProperty((String)"ice.pilots.html4.baseFontSize")) != null && (n = CSSUtil.parseInt(string, -1)) >= 4) {
                this.sdata.fontCache.setBaseFontSize(n);
            }
            if ((string = Defs.sysProperty((String)"ice.pilots.html4.baseFontFamily")) != null) {
                this.sdata.fontCache.setBaseFontFamily(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void refresh() {
        this.TRUE();
        this.addChild.mutate();
        this.addColorDefinition.validateLayout();
    }

    protected void setZoom(int n) {
        this.addColorDefinition.setLayoutZoom(n);
    }

    public void suspend() {
        if (this.addColorDefinition != null) {
            this.addColorDefinition.clear();
        }
    }

    public void resume() {
        this.refresh();
    }

    public void clear(String string) {
        ThePilot thePilot;
        ThePilot thePilot2 = this;
        synchronized (thePilot2) {
            ++this.noLayoutUpdate;
        }
        try {
            this.addChild(string);
            Object var5_4 = null;
            thePilot = this;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ThePilot thePilot3 = this;
            synchronized (thePilot3) {
                --this.noLayoutUpdate;
            }
            throw throwable;
        }
        synchronized (thePilot) {
            --this.noLayoutUpdate;
        }
    }

    private void addChild(String string) {
        this.append = true;
        FramesetData framesetData = this.framesetData;
        if (framesetData != null) {
            framesetData.dispose();
        }
        this.framesetData = null;
        this.addColorDefinition.clear();
        this.objectPool.dispose();
        this.objectPool = new ObjectPool(this);
        this.addChild.clear();
        if (CSSLayout.forceGC) {
            System.gc();
        }
        String string2 = string.toLowerCase();
        if (Debug.trace) {
            Debug.trace((String)("contentType ==" + string + " tmp == " + string2));
        }
        if (string2.indexOf("html") > 0 || string2.indexOf("unknown") >= 0) {
            this.addChild.setHtmlMode(true);
        } else {
            this.addChild.setHtmlMode(false);
        }
        this.addFramesetChild = this.addEventListener;
        int n = string2.indexOf("charset");
        if (n > 0 && (n = string.indexOf(61, n)) > 0) {
            this.addFramesetChild = string.substring(n + 1).trim();
        }
        this.addMouseListener = false;
        this.TRUE();
        this.firePropertyChange("title", null, "");
    }

    public void stopImageAnimation() {
        this.addColorDefinition.doImageAnimation = false;
    }

    public void stopLoading() {
        this.append = false;
        this.objectPool.stopImageLoading();
    }

    public void onLowMemory() {
        this.stopLoading();
    }

    public void addPersistentDOMEventListener(String string, EventListener eventListener, boolean bl) {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            this.persistentDomListeners = DNodeListeners.addEventListener(this.persistentDomListeners, string, bl, eventListener);
        }
    }

    public void removePersistentDOMEventListener(String string, EventListener eventListener, boolean bl) {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            this.persistentDomListeners = DNodeListeners.removeEventListener(this.persistentDomListeners, string, bl, eventListener);
        }
    }

    public DefaultEventHandler getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public void setDefaultEventHandler(DefaultEventHandler defaultEventHandler) {
        if (defaultEventHandler == null) {
            throw new IllegalArgumentException();
        }
        this.defaultEventHandler = defaultEventHandler;
    }

    public void parse(ContentLoader contentLoader) throws IOException {
        ThePilot thePilot;
        this.isFromHistory = contentLoader.isFromHistory();
        ThePilot thePilot2 = this;
        synchronized (thePilot2) {
            ++this.noLayoutUpdate;
        }
        try {
            this.addColorDefinition(3);
            this.addComponentListener(contentLoader);
            Object var5_4 = null;
            thePilot = this;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ThePilot thePilot3 = this;
            synchronized (thePilot3) {
                --this.noLayoutUpdate;
            }
            throw throwable;
        }
        synchronized (thePilot) {
            --this.noLayoutUpdate;
        }
        if (!this.getPilotViewport().isStopRequested()) {
            this.addEventListener(contentLoader.getLocation());
        }
        this.addColorDefinition(0);
    }

    private void addColorDefinition(int n) {
        DocPane docPane = this.getDocPane();
        if (docPane == null) {
            return;
        }
        docPane.setCursor(n);
    }

    private void addComponentListener(ContentLoader contentLoader) throws IOException {
        Lex2 lex2;
        DOMBuilder dOMBuilder = new DOMBuilder(this.addChild, this);
        this.addMouseMotionListener = lex2 = new Lex2(dOMBuilder);
        this.addChild.cookieSet = contentLoader.getCookieSet();
        if (this.addChild.cookieSet == null) {
            this.addChild.cookieSet = this.sdata.getCookieSet();
        }
        try {
            String string;
            Object object;
            String string2 = this.addElement(contentLoader.getContentType());
            if (string2 != null) {
                this.addFramesetChild = string2;
                this.addMouseListener = true;
            }
            int n = 1;
            while (true) {
                object = contentLoader.getHeaderFieldKey(n);
                string = contentLoader.getHeaderField(n);
                if (object == null || string == null) break;
                if (((String)object).equalsIgnoreCase("set-cookie")) {
                    this.addChild.setCookie(string);
                } else {
                    String string3 = System.getProperty("http.useCharset");
                    if (string3 != null && string3.equalsIgnoreCase("true") && !this.addMouseListener && ((String)object).equalsIgnoreCase("content-type") && (string2 = this.addElement(string)) != null) {
                        this.addFramesetChild = string2;
                    }
                    this.addChild.setHttpProperty("_http_" + ((String)object).toLowerCase(), string);
                }
                ++n;
            }
            try {
                object = contentLoader.getRequestProperty("referer");
                if (object != null) {
                    this.addChild.setHttpProperty("_http_referer", (String)object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = contentLoader.getInputStream();
            if (object == null) {
                throw new IOException("Could not connect to: " + contentLoader.getLocation());
            }
            string = contentLoader.getLocation();
            if (string != null) {
                this.firePropertyChange("location", null, string);
            }
            this.addChild.setDefaultCharset(this.addFramesetChild);
            lex2.setInputStream((InputStream)object, this.addFramesetChild);
            lex2.setLockedEncoding(this.addMouseListener);
            try {
                block22: {
                    try {
                        lex2.parse();
                        if (Debug.trace && this.addChild == null) {
                            Debug.trace((String)"do_parse: Document is null");
                        }
                        if (this.addChild == null) break block22;
                        this.addChild.setDefaultCharset(lex2.getEncoding());
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new ICEException(1, 3, 2);
                    }
                    catch (RuntimeException runtimeException) {
                        if (Debug.ex) {
                            Debug.ex((Throwable)runtimeException);
                        }
                        if (Debug.trace) {
                            Debug.trace((String)"Do not be scared - this exception is caught!");
                        }
                        throw new IOException("Parsing problem");
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                ((InputStream)object).close();
                throw throwable;
            }
            ((InputStream)object).close();
            Object var14_16 = null;
            this.addMouseMotionListener = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            this.addMouseMotionListener = null;
            throw throwable;
        }
    }

    private String addElement(String string) {
        String string2 = null;
        int n = string.toLowerCase().indexOf("charset");
        if (n != -1 && (n = string.indexOf(61, n)) != -1 && n != string.length() - 1) {
            string2 = string.substring(++n).trim();
        }
        return string2;
    }

    public void parsingDone() {
        if (this.addChild != null && this.addChild.isFrameset) {
            this.firePropertyChange("contentRendering", null, "end");
            this.firePropertyChange("outstandingImages", null, "0");
        } else if (this.addChild != null) {
            this.addColorDefinition.refresh(true);
        }
    }

    private void addEventListener(String string) {
        DElement dElement;
        Object object;
        Object object2;
        if (Debug.trace && this.addChild == null) {
            Debug.trace((String)"finalize_parsing: Document is null");
        }
        if (this.addChild == null) {
            return;
        }
        if (this.addChild.isFrameset && !viewNoframes && !this.addElement) {
            this.processFrameset();
        } else {
            int n;
            if (string != null && (n = string.indexOf(35) + 1) > 0 && n < string.length()) {
                object2 = string.substring(n);
                this.addColorDefinition.setWaitForRef((String)object2);
            }
            object = (String)this.getViewportProperty("marginwidth");
            object2 = (String)this.getViewportProperty("marginheight");
            if ((object != null || object2 != null) && (dElement = this.addChild.getDBody()) != null) {
                if (object != null) {
                    dElement.setAttribute(58, (String)object);
                }
                if (object2 != null) {
                    dElement.setAttribute(57, (String)object2);
                }
                this.addChild.mutate();
            }
        }
        object = this.addChild.getHead();
        if (object != null) {
            object2 = ((DNode)object).getFirstDChild();
            while (object2 != null) {
                String string2;
                if (((DNode)object2).getNameId() == 57 && (string2 = (dElement = (DElement)object2).getAttribute(49)) != null && string2.equalsIgnoreCase("refresh") && (string2 = dElement.getAttribute(31)) != null) {
                    this.setupRefresh(string2);
                }
                object2 = ((DNode)object2).next;
            }
        }
    }

    void onLayoutEnd() {
        DElement dElement;
        this.firePropertyChange("contentRendering", null, "end");
        if (this.addMouseMotionListener == null && (dElement = this.addChild.getDBody()) != null && this.addColorDefinition.docPane != null) {
            this.addColorDefinition.docPane.updateScrollbars(this.addChild.isRTL());
        }
    }

    public void onLoadingDone() {
        this.firePropertyChange("contentRendering", null, "finished");
        this.objectPool.fireOutstandingImagesEvent();
        DElement dElement = this.addChild.getDBody();
        if (dElement != null) {
            this.addChild.processEvent(this.addChild.createDOMEvent(13, dElement));
        } else {
            FramesetData framesetData = this.framesetData;
            if (framesetData != null) {
                framesetData.sendFramesetOnload();
            }
        }
    }

    boolean canLoadImages() {
        return this.append;
    }

    void updateFrameset(DElement dElement) {
        if (dElement != null) {
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            Object object;
            FramesetData framesetData = this.framesetData;
            if (framesetData == null) {
                return;
            }
            String string = dElement.getAttribute(28);
            String string2 = dElement.getAttribute(92);
            if (string != null) {
                object = new CoordsList(string);
                nArray3 = ((CoordsList)object).getListOfValues();
                nArray2 = ((CoordsList)object).getListOfTypes();
            } else {
                nArray3 = new int[]{100};
                nArray2 = new int[]{1};
            }
            if (string2 != null) {
                CoordsList coordsList = new CoordsList(string2);
                object = coordsList.getListOfValues();
                nArray = coordsList.getListOfTypes();
            } else {
                object = new int[]{100};
                nArray = new int[]{1};
            }
            framesetData.updateFramesetInfo(dElement, nArray3, nArray2, (int[])object, nArray);
        }
    }

    protected void processFrameset() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        DNode dNode;
        NodeList nodeList = this.addChild.getElementsByTagName("frameset");
        if (nodeList.getLength() == 0) {
            return;
        }
        FramesetData framesetData = this.framesetData;
        if (framesetData != null) {
            framesetData.dispose();
        }
        framesetData = new FramesetData(this);
        StormBase stormBase = this.getStorm();
        Vector<String> vector = new Vector<String>();
        Vector<Object> vector2 = new Vector<Object>();
        DNode dNode2 = dNode = (DNode)nodeList.item(0);
        boolean bl = true;
        do {
            Object object6;
            String string;
            String string2;
            object5 = (DElement)dNode2;
            if (((DNode)object5).tagId == 34) {
                Object object7;
                Object object8;
                string2 = ((DElement)object5).getAttribute(123);
                if (string2 != null) {
                    this.getViewportContainer().addComponentListener(new OnresizeListener((DElement)object5, this.addChild));
                }
                string = ((DElement)object5).getAttribute(28);
                object4 = ((DElement)object5).getAttribute(92);
                if (string != null) {
                    object3 = new CoordsList(string);
                    object6 = ((CoordsList)object3).getListOfValues();
                    object2 = ((CoordsList)object3).getListOfTypes();
                } else {
                    object6 = new int[1];
                    object2 = new int[1];
                    object6[0] = 100;
                    object2[0] = 1;
                }
                if (object4 != null) {
                    object8 = new CoordsList((String)object4);
                    object3 = ((CoordsList)object8).getListOfValues();
                    object = ((CoordsList)object8).getListOfTypes();
                } else {
                    object3 = new int[1];
                    object = new int[1];
                    object3[0] = 100;
                    object[0] = 1;
                }
                object8 = null;
                if (bl) {
                    bl = false;
                } else {
                    DElement dElement;
                    object7 = this.addColorDefinition.docPane.createFramesDividerComponent();
                    object8 = new FramesDivider((Component)object7);
                    String string3 = ((DElement)object5).getAttribute(65);
                    if (object7 != null && (string3 == null || string3.equalsIgnoreCase("false"))) {
                        ((Component)object7).addMouseListener((MouseListener)object8);
                        ((Component)object7).addMouseMotionListener((MouseMotionListener)object8);
                    }
                    if ((string3 = (dElement = (DElement)((DNode)object5).getDParent()).getAttribute(43)) != null) {
                        ((FramesDivider)object8).setProperty("frameborder", string3);
                    }
                    if ((string3 = dElement.getAttribute(13)) != null) {
                        ((FramesDivider)object8).setProperty("border", string3);
                    }
                }
                object7 = this.getPilotViewport();
                framesetData.beginFrameset((DElement)object5, (int[])object6, (int[])object2, (int[])object3, (int[])object, (FramesDivider)object8, ((Viewport)object7).getName());
            } else if (((DNode)object5).tagId == 33) {
                string2 = ((DElement)object5).getAttribute(102);
                string = ((DElement)object5).getAttribute(63);
                if (string2 == null) {
                    string2 = "";
                }
                if (string2.length() > 0) {
                    string2 = this.addChild.resolveUrl(string2);
                }
                if (string != null && string.length() == 0) {
                    string = null;
                }
                object4 = new Viewport(this.getStorm(), string);
                ((Viewport)object4).setFrameArrayMember();
                object6 = this.addColorDefinition.docPane.createFramesDividerComponent();
                object2 = new FramesDivider((Component)object6);
                if (framesetData.addFramesetChild((Viewport)object4, (FramesDivider)object2)) {
                    vector2.addElement(object4);
                    vector.addElement(string2);
                    object3 = ((DElement)object5).getAttribute(97);
                    if (object3 != null) {
                        ((Viewport)object4).setProperty("scrolling", object3);
                    }
                    if ((object3 = ((DElement)object5).getAttribute(58)) != null) {
                        ((Viewport)object4).setProperty("marginwidth", object3);
                    }
                    if ((object3 = ((DElement)object5).getAttribute(57)) != null) {
                        ((Viewport)object4).setProperty("marginheight", object3);
                    }
                    if ((object3 = ((DElement)(object = (Object)((DElement)((DNode)object5).getDParent()))).getAttribute(43)) != null) {
                        ((FramesDivider)object2).setProperty("frameborder", (String)object3);
                    }
                    if ((object3 = ((DElement)object).getAttribute(13)) != null) {
                        ((FramesDivider)object2).setProperty("border", (String)object3);
                    }
                    object3 = ((DElement)object5).getAttribute(65);
                    if (object6 != null && (object3 == null || ((String)object3).equalsIgnoreCase("false"))) {
                        ((Component)object6).addMouseListener((MouseListener)object2);
                        ((Component)object6).addMouseMotionListener((MouseMotionListener)object2);
                    }
                }
            }
            if (((DNode)object5).tagId != 34 || dNode2.getFirstDChild() == null) {
                while (dNode2 != dNode && dNode2.next == null) {
                    dNode2 = dNode2.parent;
                    if (dNode2.getNameId() != 34) continue;
                    framesetData.endFrameset();
                }
                if (dNode2 == dNode) continue;
                dNode2 = dNode2.next;
                continue;
            }
            dNode2 = dNode2.getFirstDChild();
        } while (dNode2 != dNode);
        object5 = this.getPilotViewport();
        ((Viewport)object5).removePilotComponent();
        int n = 0;
        int n2 = vector2.size();
        while (n != n2) {
            object4 = (Viewport)vector2.elementAt(n);
            ((Viewport)object4).setContainer(((Viewport)object5).getContainer());
            ((Viewport)object5).addChild((Viewport)object4);
            ++n;
        }
        this.framesetData = framesetData;
        int n3 = 0;
        int n4 = vector2.size();
        while (n3 != n4) {
            object2 = (Viewport)vector2.elementAt(n3);
            object3 = (String)vector.elementAt(n3);
            stormBase.clearViewportContent("text/html", (Viewport)object2);
            if (((String)object3).length() != 0 && !this.isFromHistory) {
                object = this.getUrlMaster().createLoader((String)object3);
                ((ContentLoader)object).setReferer(this.addChild.getBaseUrl());
                if (this.isLoadedSynchronously) {
                    stormBase.renderViewportContentFully((ContentLoader)object, (Viewport)object2);
                } else {
                    stormBase.renderViewportContent((ContentLoader)object, (Viewport)object2);
                }
            }
            ++n3;
        }
        if (this.isFromHistory) {
            this.firePropertyChange("viewport", null, "childrenReady");
        }
    }

    protected boolean allowedToRunHandler(DOMEvent dOMEvent, DNode dNode) {
        switch (dOMEvent.getTypeId()) {
            case 19: {
                if (!(dNode instanceof DFormElement) || dOMEvent.getTarget() == dNode) break;
                return false;
            }
        }
        return true;
    }

    protected DynamicObject getScriptHandlerThis(DNode dNode, DOMEvent dOMEvent) {
        DNode dNode2 = dNode;
        if (!(dNode.tagId != 13 && dNode.tagId != 34 || dOMEvent.typeId != 13 && dOMEvent.typeId != 14)) {
            dNode2 = null;
        }
        return dNode2;
    }

    protected void evalScriptHandlerListeners(DNode dNode, DOMEvent dOMEvent, Object object) {
        if (object != null && this.allowedToRunHandler(dOMEvent, dNode)) {
            boolean bl;
            DynamicObject dynamicObject = this.getScriptHandlerThis(dNode, dOMEvent);
            Object object2 = this.NO_SYNCHRONIZATION;
            synchronized (object2) {
                if (this.OEAB) {
                    this.OEAB = false;
                }
                bl = this.OEAB("ECMAScript", object, dOMEvent, dynamicObject);
                if (this.OEAB) {
                    dOMEvent.cancel = true;
                    this.OEAB = false;
                }
            }
            if (dOMEvent.typeId == 5 || dOMEvent.typeId == 7) {
                boolean bl2 = bl = !bl;
            }
            if (!bl) {
                dOMEvent.preventDefault();
            }
        }
    }

    public static void addColorDefinition(String string, Color color) {
        CSSUtil.addColorDefinition(string, color);
    }

    public static DStyleSheet getUserStyleSheet(StormBase stormBase) {
        return CSSManager.getUserStyle(StormData.get(stormBase));
    }

    protected Object script_createOption(Object[] objectArray) {
        DOptionElement dOptionElement = (DOptionElement)this.addChild.createElement(63);
        if (objectArray.length >= 1) {
            Object object = objectArray[0];
            String string = object == null ? "" : object.toString();
            dOptionElement.setText(string);
            if (objectArray.length >= 2) {
                object = objectArray[1];
                String string2 = object == null ? "" : object.toString();
                dOptionElement.setValue(string2);
            }
        }
        return dOptionElement;
    }

    protected Object script_createActiveXObject(String string) {
        if ("Msxml2.DOMDocument".equals(string)) {
            if (Debug.trace) {
                Debug.trace((String)"WindowObj.script_ActiveXObject 2");
            }
            return this.addChild.getDom().createDDocument(this, false);
        }
        return null;
    }

    protected Object script_getDOMImplementation() {
        return this.addChild.getDom();
    }

    public final DynamicObject getDocumentObject() {
        return this.getDDocument();
    }

    public void updateFrameList() {
        this.getView().updateFrameList();
    }

    private int addFramesetChild(String string) {
        int n = 70;
        int n2 = 74;
        int n3 = 78;
        int n4 = 87;
        int n5 = 0;
        String string2 = null;
        int n6 = string.length();
        if (n6 == 6) {
            char c = string.charAt(2);
            if (c == 'b') {
                string2 = "onblur";
                n5 = 70;
            } else if (c == 'l') {
                string2 = "onload";
                n5 = 78;
            }
        } else if (n6 == 7) {
            string2 = "onfocus";
            n5 = 74;
        } else if (n6 == 8) {
            string2 = "onunload";
            n5 = 87;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n5 = 0;
        }
        return n5 - 1;
    }

    private void addMouseListener(int n, Object object) {
        if (this.tmpBodyEventHandlers == null) {
            this.tmpBodyEventHandlers = new HashArray();
        }
        this.tmpBodyEventHandlers.put(n, object);
    }

    private Object addMouseMotionListener(int n) {
        HashArray hashArray = this.tmpBodyEventHandlers;
        return hashArray != null ? hashArray.get(n) : null;
    }

    void moveToBodyTmpBodyEventHandlers() {
        DElement dElement;
        HashArray hashArray = this.tmpBodyEventHandlers;
        this.tmpBodyEventHandlers = null;
        if (hashArray != null && (dElement = this.addChild.getDBody()) != null) {
            HashArray.Iterator iterator = hashArray.newIterator();
            iterator.start();
            while (!iterator.done()) {
                HashArray.Entry entry = iterator.entry();
                int n = entry.index();
                Object object = entry.value;
                dElement.setDAttr(n, object, false);
                iterator.next();
            }
        }
    }

    public Object getDynamicValueOnWindow(DynamicObject dynamicObject, String string, DynEnv dynEnv) {
        int n = ThePilot.beginFrameset(string);
        if (n < 0) {
            return dynEnv.wrapMethod(dynamicObject, string);
        }
        if (n > 0) {
            return this.allowedToRunHandler(n, dynEnv);
        }
        int n2 = this.addFramesetChild(string);
        if (n2 >= 0) {
            DElement dElement = this.addChild.getDBody();
            Object object = dElement != null ? dElement.getSlot(string, dynEnv) : this.addMouseMotionListener(n2);
            return object;
        }
        return super.getDynamicValueOnWindow(dynamicObject, string, dynEnv);
    }

    public int setDynamicValueOnWindow(DynamicObject dynamicObject, String string, Object object, DynEnv dynEnv) {
        int n = ThePilot.beginFrameset(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.append(n, object, dynEnv);
        }
        int n2 = this.addFramesetChild(string);
        if (n2 >= 0) {
            DElement dElement = this.addChild.getDBody();
            if (dElement != null) {
                dElement.setDAttr(n2, object, false);
            } else {
                this.addMouseListener(n2, object);
            }
            return 1;
        }
        return super.setDynamicValueOnWindow(dynamicObject, string, object, dynEnv);
    }

    public Object execDynamicMethodOnWindow(DynamicObject dynamicObject, String string, Object[] objectArray, DynEnv dynEnv) {
        int n = ThePilot.beginFrameset(string);
        if (n < 0) {
            return this.appendGeneratedContent(n, objectArray, dynEnv);
        }
        return super.execDynamicMethodOnWindow(dynamicObject, string, objectArray, dynEnv);
    }

    private Object allowedToRunHandler(int n, DynEnv dynEnv) {
        switch (n) {
            case 2: {
                return this.addChild.currentEvent;
            }
            case 1: {
                return this.script_getDOMImplementation();
            }
        }
        return null;
    }

    private int append(int n, Object object, DynEnv dynEnv) {
        return 1;
    }

    private Object appendGeneratedContent(int n, Object[] objectArray, DynEnv dynEnv) {
        if (n == -2) {
            return this.script_createOption(objectArray);
        }
        if (n == -1) {
            return this.script_createActiveXObject(dynEnv.toStr(objectArray, 0));
        }
        return dynEnv.wrapVoid();
    }

    private static int beginFrameset(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 5: {
                string2 = "event";
                n = 2;
                break;
            }
            case 6: {
                string2 = "Option";
                n = -2;
                break;
            }
            case 11: {
                char c = string.charAt(4);
                if (c == 'X') {
                    string2 = "pageXOffset";
                    n = 3;
                    break;
                }
                if (c != 'Y') break;
                string2 = "pageYOffset";
                n = 4;
                break;
            }
            case 13: {
                string2 = "ActiveXObject";
                n = -1;
                break;
            }
            case 17: {
                string2 = "DOMImplementation";
                n = 1;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    public Object getSnapshot() {
        FormTypeElement formTypeElement;
        int n;
        DDocument dDocument = (DDocument)this.getDocument();
        if (dDocument == null) {
            return null;
        }
        HashArray hashArray = new HashArray(Defs.NO_SYNCHRONIZATION);
        String string = null;
        String string2 = null;
        NodeList nodeList = dDocument.getElementsByTagName("input");
        if (nodeList != null) {
            n = 0;
            while (n < nodeList.getLength()) {
                formTypeElement = (DInputElement)nodeList.item(n);
                string = formTypeElement.getName();
                string2 = ((DInputElement)formTypeElement).getType();
                if (string != null && string2 != null) {
                    if (string2.equals("text") || string2.equals("hidden")) {
                        hashArray.put((Object)string, (Object)((DInputElement)formTypeElement).getValue());
                    } else if (string2.equals("checkbox")) {
                        hashArray.put((Object)string, (Object)new Boolean(((DInputElement)formTypeElement).getChecked()));
                    } else if (string2.equals("radio") && formTypeElement.getAttribute("value") != null) {
                        hashArray.put((Object)(string + "_" + formTypeElement.getAttribute("value")), (Object)new Boolean(((DInputElement)formTypeElement).getChecked()));
                    }
                }
                ++n;
            }
        }
        if ((nodeList = dDocument.getElementsByTagName("textarea")) != null) {
            n = 0;
            while (n < nodeList.getLength()) {
                String string3;
                formTypeElement = (DTextAreaElement)nodeList.item(n);
                string = formTypeElement.getName();
                if (string != null && (string3 = ((DTextAreaElement)formTypeElement).getValue()) != null) {
                    hashArray.put((Object)string, (Object)string3);
                }
                ++n;
            }
        }
        if ((nodeList = dDocument.getElementsByTagName("select")) != null) {
            n = 0;
            while (n < nodeList.getLength()) {
                formTypeElement = (DSelectElement)nodeList.item(n);
                string = formTypeElement.getName();
                if (string != null) {
                    int n2 = 0;
                    while (n2 < ((DSelectElement)formTypeElement).getLength()) {
                        DOptionElement dOptionElement = (DOptionElement)((DSelectElement)formTypeElement).item(n2);
                        hashArray.put((Object)(string + "_" + n2), (Object)new Boolean(dOptionElement.getSelected()));
                        ++n2;
                    }
                }
                ++n;
            }
        }
        hashArray.sealObject();
        Snapshot snapshot = new Snapshot(null);
        snapshot.inputNames = hashArray;
        snapshot.scrollX = this.getDocPane().getScrollX();
        snapshot.scrollY = this.getDocPane().getScrollY();
        return snapshot;
    }

    public void applySnapshot(Object object) {
        Object object2;
        Object object3;
        DDocument dDocument = (DDocument)this.getDocument();
        Snapshot snapshot = (Snapshot)object;
        HashArray hashArray = snapshot.inputNames;
        if (dDocument == null || hashArray == null) {
            return;
        }
        String string = null;
        String string2 = null;
        NodeList nodeList = dDocument.getElementsByTagName("input");
        int n = 0;
        while (n < nodeList.getLength()) {
            DInputElement dInputElement = (DInputElement)nodeList.item(n);
            string = dInputElement.getName();
            string2 = dInputElement.getType();
            if (string != null && string2 != null) {
                if (string2.equals("text") || string2.equals("hidden")) {
                    object3 = (String)hashArray.get((Object)string);
                    if (object3 != null) {
                        dInputElement.setValue((String)object3);
                    }
                } else if (string2.equals("checkbox")) {
                    object3 = (Boolean)hashArray.get((Object)string);
                    if (object3 != null) {
                        dInputElement.setChecked((Boolean)object3);
                    }
                } else if (string2.equals("radio") && dInputElement.getAttribute("value") != null && (object3 = (Boolean)hashArray.get((Object)(string + "_" + dInputElement.getAttribute("value")))) != null) {
                    dInputElement.setChecked((Boolean)object3);
                }
            }
            ++n;
        }
        nodeList = dDocument.getElementsByTagName("textarea");
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            object3 = (DTextAreaElement)nodeList.item(n2);
            string = ((DElement)object3).getName();
            if (string != null && (object2 = (String)hashArray.get((Object)string)) != null) {
                ((DTextAreaElement)object3).setValue((String)object2);
            }
            ++n2;
        }
        nodeList = dDocument.getElementsByTagName("select");
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            object2 = (DSelectElement)nodeList.item(n3);
            string = ((DElement)object2).getName();
            if (string != null) {
                int n4 = 0;
                while (n4 < ((DSelectElement)object2).getLength()) {
                    DOptionElement dOptionElement = (DOptionElement)((DSelectElement)object2).item(n4);
                    Boolean bl = (Boolean)hashArray.get((Object)(string + "_" + n4));
                    if (bl != null) {
                        dOptionElement.setSelected(bl);
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        this.addColorDefinition.setPresetScrollPosition(snapshot.scrollX, snapshot.scrollY);
    }

    static boolean prepareImage(Image image, ImageObserver imageObserver) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return Boolean.TRUE == SecurityKit.doPrivileged((BoxedCode)new BoxedCode(toolkit, image, imageObserver){
            private final Toolkit val$toolkit;
            private final Image val$image;
            private final ImageObserver val$observer;
            {
                this.val$toolkit = toolkit;
                this.val$image = image;
                this.val$observer = imageObserver;
            }

            public Object run() {
                boolean bl = this.val$toolkit.prepareImage(this.val$image, -1, -1, this.val$observer);
                return bl ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    void setupRefresh(String string) {
        String string2;
        int n;
        char c;
        int n2 = 0;
        int n3 = string.length();
        n2 = CharKit.trimStart((String)string, (int)n2, (int)n3);
        n3 = CharKit.trimEnd((String)string, (int)n2, (int)n3);
        int n4 = string.indexOf(59, n2);
        if (n4 < 0) {
            n4 = string.indexOf(44, n2);
        }
        int n5 = -1;
        if (n4 >= 0) {
            n5 = CSSUtil.parseInt(string, n2, n4, -1);
            n2 = n4 + 1;
            n2 = CharKit.trimStart((String)string, (int)n2, (int)n3);
        }
        if (string.regionMatches(true, n2, "url=", 0, 4)) {
            n2 += 4;
            n2 = CharKit.trimStart((String)string, (int)n2, (int)n3);
        }
        if (n2 != n3 && ((c = string.charAt(n2)) == '\'' || c == '\"') && (n = string.indexOf(c, ++n2)) >= 0) {
            n3 = n;
        }
        if (n5 < 0 && (n5 = CSSUtil.parseInt(string, n2, n3, -1)) >= 0) {
            n2 = n3;
        }
        if ((string2 = n2 == n3 ? this.addChild.getBaseUrl() : this.addChild.resolveUrl(string.substring(n2, n3))) == null) {
            return;
        }
        n5 = n5 >= 0 ? (n5 *= 1000) : 0;
        RefreshItem refreshItem = new RefreshItem(this.addChild, string2, n5);
        refreshItem.postToEventThread(n5);
    }

    void startDownload(String string, Object object, Scripter scripter) {
        int n = this.getPilotViewport().getDocumentId();
        Thread thread = new Thread(this, string, object, scripter, n){
            private final String val$url;
            private final Object val$callback;
            private final Scripter val$scripter;
            private final int val$documentId;
            private final ThePilot this$0;
            {
                this.this$0 = thePilot;
                this.val$url = string;
                this.val$callback = object;
                this.val$scripter = scripter;
                this.val$documentId = n;
            }

            public void run() {
                SecurityKit.doPrivileged((BoxedCode)new BoxedCode(this){
                    private final 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object run() {
                        2.access$500(this.this$1).do_download(2.access$100(this.this$1), 2.access$200(this.this$1), 2.access$300(this.this$1), 2.access$400(this.this$1));
                        return null;
                    }
                });
            }

            static String access$100(2 var0) {
                return var0.val$url;
            }

            static Object access$200(2 var0) {
                return var0.val$callback;
            }

            static Scripter access$300(2 var0) {
                return var0.val$scripter;
            }

            static int access$400(2 var0) {
                return var0.val$documentId;
            }

            static ThePilot access$500(2 var0) {
                return var0.this$0;
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void do_download(String string, Object object, Scripter scripter, int n) {
        String string2;
        Object object2;
        if (n != this.getPilotViewport().getDocumentId()) {
            return;
        }
        string = this.addChild.resolveUrl(string);
        try {
            object2 = this.addChild.openUrlReader(string);
            try {
                if (n != this.getPilotViewport().getDocumentId()) {
                    Object var8_7 = null;
                    ((Reader)object2).close();
                    return;
                }
                string2 = IOKit.readAllStr((Reader)object2, (int)4096);
                Object var8_8 = null;
                ((Reader)object2).close();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                ((Reader)object2).close();
                throw throwable;
            }
        }
        catch (IOException iOException) {
            if (Debug.ex) {
                Debug.ex((Throwable)iOException);
            }
            return;
        }
        if (n != this.getPilotViewport().getDocumentId()) {
            return;
        }
        object2 = new DocAction(this, string2, scripter, object, this.addChild, n){
            private final String val$str;
            private final Scripter val$scripter;
            private final Object val$callback;
            private final ThePilot this$0;
            {
                this.this$0 = thePilot;
                this.val$str = string;
                this.val$scripter = scripter;
                this.val$callback = object;
            }

            protected void doit(DDocument dDocument) {
                Object[] objectArray = new Object[]{this.val$str};
                this.val$scripter.evalCallback(this.this$0.getPilotViewport(), this.val$callback, objectArray);
            }
        };
        ((DocAction)object2).postToEventThread(0L);
    }

    private static class Snapshot {
        HashArray inputNames;
        int scrollX;
        int scrollY;

        private Snapshot() {
        }

        Snapshot(1 var1_1) {
            this();
        }
    }
}

