/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services;

import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.PrefsAWT;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingLevel;
import com.mathworks.services.settings.SettingPath;
import java.awt.Color;
import java.awt.SystemColor;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class ColorPrefs {
    public static final String TEXT_COLOR = "ColorsText";
    public static final String BACKGROUND_COLOR = "ColorsBackground";
    public static final String USE_SYSTEM_COLORS = "ColorsUseSystem";
    public static final String M_COLORS = "Colors_M_";
    public static final String HTML_COLORS = "Colors_HTML_";
    public static final String HYPERLINK_COLOR = "Colors_HTML_HTMLLinks";
    private static final String SEARCH_RESULT_HIGHLIGHT = "ColorsSearchResult";
    private static final Color[] SEARCH_RESULT_HIGHLIGHT_DEFAULTS = new Color[]{new Color(153, 255, 255), Color.YELLOW};
    private static final String CMD_WIN_WARNINGS_COLOR = "Color_CmdWinWarnings";
    private static final String CMD_WIN_ERRORS_COLOR = "Color_CmdWinErrors";
    private static final String M_KEYWORDS = "Colors_M_Keywords";
    private static final String M_COMMENTS = "Colors_M_Comments";
    private static final String M_STRINGS = "Colors_M_Strings";
    private static final String M_UNTERMINATED_STRINGS = "Colors_M_UnterminatedStrings";
    private static final String M_SYSTEM_COMMANDS = "Colors_M_SystemCommands";
    private static final String M_WARNINGS = "Colors_M_Warnings";
    private static final String M_ERRORS = "Colors_M_Errors";
    public static final String USE_MLINT_AUTOFIX_BACKGROUND = "ColorsUseMLintAutoFixBackground";
    public static final String MLINT_AUTOFIX_BACKGROUND_COLOR = "ColorsMLintAutoFixBackground";
    public static final Color DEFAULT_TEXT_COLOR = Color.black;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.white;
    @Deprecated
    public static final String[] M_CATEGORIES = new String[]{"Colors_M_Keywords", "Colors_M_Comments", "Colors_M_Strings", "Colors_M_UnterminatedStrings", "Colors_M_SystemCommands", "Colors_M_Errors", "Colors_M_Warnings"};
    private static final List<ColorListener> COLOR_LISTENERS = new Vector<ColorListener>();
    private static final Object COLOR_LISTENERS_LOCK = new Object();
    private static final SettingPath sCWPath = new SettingPath("matlab", "desktop", "commandwindow");
    private static final Setting<Color> sCWErrorSettingKey = ColorPrefs.getColorSetting(sCWPath, "ErrorColor");
    private static final Setting<Color> sCWWarningSettingKey = ColorPrefs.getColorSetting(sCWPath, "WarningColor");
    @Deprecated
    public static final String[] HTML_CATEGORIES = new String[]{"Colors_HTML_HTMLLinks"};

    private static Setting<Color> getColorSetting(SettingPath settingPath, String string) {
        try {
            return new Setting<Color>(settingPath, Color.class, string);
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private ColorPrefs() {
    }

    public static Color getHyperlinkColor() {
        return ColorPrefs.getColorPref(HYPERLINK_COLOR);
    }

    private static MatlabColor getMatlabColorForKey(String string) {
        for (MatlabColor matlabColor : MatlabColor.values()) {
            if (!matlabColor.getKey().equals(string)) continue;
            return matlabColor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addColorListener(String string, PrefListener prefListener) {
        Object object = COLOR_LISTENERS_LOCK;
        synchronized (object) {
            COLOR_LISTENERS.add(new ColorListener(string, prefListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeColorListener(String string, PrefListener prefListener) {
        Object object = COLOR_LISTENERS_LOCK;
        synchronized (object) {
            for (ColorListener colorListener : COLOR_LISTENERS) {
                if (!colorListener.getIType().equals(string) || !colorListener.getIListener().equals(prefListener)) continue;
                COLOR_LISTENERS.remove(colorListener);
                break;
            }
        }
    }

    public static void setColorPref(String string, Color color) {
        Setting setting;
        MatlabColor matlabColor = ColorPrefs.getMatlabColorForKey(string);
        if (matlabColor != null && (setting = matlabColor.iColorSetting) != null) {
            block3: {
                try {
                    setting.set(color);
                }
                catch (SettingException settingException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
            return;
        }
        PrefsAWT.setColorPref(string, color);
    }

    public static Color getColorPref(String string) {
        Setting setting;
        MatlabColor matlabColor = ColorPrefs.getMatlabColorForKey(string);
        if (matlabColor != null && (setting = matlabColor.iColorSetting) != null) {
            try {
                return (Color)setting.get();
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }
        return PrefsAWT.getColorPref(string, ColorPrefs.getDefaultColor(string));
    }

    public static Color getDefaultColor(String string) {
        Color color = Color.black;
        MatlabColor matlabColor = ColorPrefs.getMatlabColorForKey(string);
        if (matlabColor != null) {
            color = matlabColor.getDefaultColor();
        } else if (string.equals(HYPERLINK_COLOR)) {
            color = Prefs.getColorPref("CommandWindowLinkColor", ColorPrefs.getDefaultHyperlinkColor());
        } else if (string.startsWith(SEARCH_RESULT_HIGHLIGHT)) {
            color = SEARCH_RESULT_HIGHLIGHT_DEFAULTS[Integer.valueOf(string.substring(SEARCH_RESULT_HIGHLIGHT.length()))];
        }
        return color;
    }

    public static Color getDefaultHyperlinkColor() {
        return Color.blue;
    }

    public static boolean isMLintAutoFixBackgroundEnabled() {
        return Prefs.getBooleanPref(USE_MLINT_AUTOFIX_BACKGROUND, ColorPrefs.getDefaultMLintAutoFixBackgroundEnabled());
    }

    public static boolean getDefaultMLintAutoFixBackgroundEnabled() {
        return true;
    }

    public static void setMLintAutoFixBackgroundEnabled(boolean bl) {
        Prefs.setBooleanPref(USE_MLINT_AUTOFIX_BACKGROUND, bl);
    }

    public static void addUseMLintAutoFixBackgroundListener(PrefListener prefListener) {
        Prefs.addListener(prefListener, USE_MLINT_AUTOFIX_BACKGROUND);
    }

    public static void removeUseMLintAutoFixBackgroundListener(PrefListener prefListener) {
        Prefs.removeListener(prefListener, USE_MLINT_AUTOFIX_BACKGROUND);
    }

    public static Color getTextColor() {
        if (ColorPrefs.getUseSystemColors()) {
            return ColorPrefs.getSystemTextColor();
        }
        return PrefsAWT.getColorPref(TEXT_COLOR, DEFAULT_TEXT_COLOR);
    }

    public static Color getBackgroundColor() {
        if (ColorPrefs.getUseSystemColors()) {
            return ColorPrefs.getSystemBackgroundColor();
        }
        return PrefsAWT.getColorPref(BACKGROUND_COLOR, DEFAULT_BACKGROUND_COLOR);
    }

    public static Color getSystemTextColor() {
        return SystemColor.textText;
    }

    public static Color getSystemBackgroundColor() {
        return SystemColor.text;
    }

    private static boolean getUseSystemColors() {
        return Prefs.getBooleanPref(USE_SYSTEM_COLORS, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyColorListenersMethod(String string) {
        Vector<ColorListener> vector;
        Iterator iterator = COLOR_LISTENERS_LOCK;
        synchronized (iterator) {
            vector = new Vector<ColorListener>(COLOR_LISTENERS);
        }
        for (ColorListener colorListener : vector) {
            if (!colorListener.getIType().equals(string)) continue;
            colorListener.getIListener().prefChanged(new PrefEvent(null, string, 1));
        }
    }

    public static void notifyColorListeners(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            ColorPrefs.notifyColorListenersMethod(string);
        } else {
            SwingUtilities.invokeLater(new NotifyColorListenerThread(string));
        }
    }

    public static Color getSearchResultColor(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("searchTerm must be >=0 ");
        }
        n = Math.min(n, SEARCH_RESULT_HIGHLIGHT_DEFAULTS.length - 1);
        return ColorPrefs.getColorPref(ColorPrefs.searchColorKey(n));
    }

    private static String searchColorKey(int n) {
        return SEARCH_RESULT_HIGHLIGHT + n;
    }

    private static class ColorListener {
        private final String iType;
        private final PrefListener iListener;

        private ColorListener(String string, PrefListener prefListener) {
            this.iType = string;
            this.iListener = prefListener;
        }

        public String getIType() {
            return this.iType;
        }

        public PrefListener getIListener() {
            return this.iListener;
        }
    }

    private static class NotifyColorListenerThread
    implements Runnable {
        private final String iLangType;

        private NotifyColorListenerThread(String string) {
            this.iLangType = string;
        }

        @Override
        public void run() {
            ColorPrefs.notifyColorListenersMethod(this.iLangType);
        }
    }

    public static enum MatlabColor {
        KEYWORD("Colors_M_Keywords", Color.blue, null),
        COMMENT("Colors_M_Comments", new Color(34, 139, 34), null),
        STRING("Colors_M_Strings", new Color(160, 32, 240), null),
        UNTERMINATED_STRING("Colors_M_UnterminatedStrings", Color.red.darker(), null),
        SYSTEM_COMMAND("Colors_M_SystemCommands", Color.orange.darker(), null),
        ERROR("Colors_M_Errors", Color.red, null),
        WARNING("Colors_M_Warnings", new Color(255, 148, 0), null),
        MLINT_AUTOFIX_BACKGROUND("ColorsMLintAutoFixBackground", new Color(238, 225, 180), null),
        CW_WARNING("Color_CmdWinWarnings", new Color(255, 100, 0), null),
        CW_ERROR("Color_CmdWinErrors", new Color(230, 0, 0), null);

        private final Color iLegacyDefaultColor;
        private final String iID;
        private Setting<Color> iColorSetting;

        private MatlabColor(String string2, Color color, Setting<Color> setting) {
            this.iLegacyDefaultColor = color;
            this.iID = string2;
            this.iColorSetting = setting;
        }

        public Color getDefaultColor() {
            if (this.iColorSetting != null) {
                try {
                    return this.iColorSetting.get(SettingLevel.FACTORY);
                }
                catch (SettingException settingException) {
                    throw new RuntimeException(settingException);
                }
            }
            return this.iLegacyDefaultColor;
        }

        public String getKey() {
            return this.iID;
        }

        public Color getPreferredColor() {
            return ColorPrefs.getColorPref(this.getKey());
        }
    }
}

