/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.editordataservice;

import com.mathworks.peermodel.PeerModelManager;
import com.mathworks.peermodel.PeerModelManagers;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.events.PeerNodeAdapter;
import com.mathworks.peermodel.events.PeerNodeEvent;
import com.mathworks.peermodel.events.PeerNodeListener;
import com.mathworks.services.editordataservice.EditorNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EditorDataServiceImpl {
    private final PeerModelManager fPeerModelManager;
    private final Map<String, List<String>> fFeaturesLibrary;
    private Observer fRootSetObserver = this.createRootSetObserver();
    private final Map<String, EditorNode> fActiveEditors = new HashMap<String, EditorNode>();

    public EditorDataServiceImpl(String string) {
        this(EditorDataServiceImpl.createFeaturesLibrary(), string);
    }

    EditorDataServiceImpl(Map<String, List<String>> map, String string) {
        this.fFeaturesLibrary = Collections.unmodifiableMap(map);
        this.fPeerModelManager = PeerModelManagers.getClientInstance((String)string);
        this.fPeerModelManager.setSyncEnabled(true);
        this.fPeerModelManager.addEventListener("rootSet", this.fRootSetObserver);
        this.initializeRootListeners();
    }

    private void initializeRootListeners() {
        if (this.fPeerModelManager.hasRoot()) {
            this.fPeerModelManager.getRoot().addPeerNodeListener((PeerNodeListener)new PeerNodeAdapter(){

                public void childAdded(PeerNodeEvent peerNodeEvent) {
                    PeerNode peerNode = this.getAddedChild(peerNodeEvent);
                    this.rootChildListener(peerNode);
                    String string = peerNode.getId();
                    EditorDataServiceImpl.this.addEditorNode(peerNode, string);
                }

                private void rootChildListener(final PeerNode peerNode) {
                    peerNode.addPeerNodeListener((PeerNodeListener)new PeerNodeAdapter(){

                        public void destroyed(PeerNodeEvent peerNodeEvent) {
                            String string = peerNode.getId();
                            EditorNode editorNode = (EditorNode)EditorDataServiceImpl.this.fActiveEditors.remove(string);
                            if (editorNode != null) {
                                editorNode.dispose();
                            }
                        }
                    });
                }

                private PeerNode getAddedChild(PeerNodeEvent peerNodeEvent) {
                    return (PeerNode)((Event)peerNodeEvent).getData().get("child");
                }
            });
        }
    }

    public Map<String, EditorNode> getActiveEditorNodes() {
        return Collections.unmodifiableMap(this.fActiveEditors);
    }

    private void addEditorNode(PeerNode peerNode, String string) {
        this.fActiveEditors.put(string, new EditorNode(peerNode, this.fFeaturesLibrary));
    }

    private Observer createRootSetObserver() {
        return new Observer(){

            public void handle(Event event) {
                EditorDataServiceImpl.this.initializeRootListeners();
            }
        };
    }

    private static Map<String, List<String>> createFeaturesLibrary() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("matlab.debug.executionarrow", Arrays.asList("com.mathworks.mde.editor.plugins.matlab.ExecutionArrowFeature"));
        hashMap.put("matlab.code.functions", Arrays.asList("com.mathworks.mde.editor.plugins.editordataservice.EditorMatlabFunctionsFeature"));
        hashMap.put("matlab.code.variables", Arrays.asList("com.mathworks.mde.editor.plugins.editordataservice.EditorVariableHighlightingFeature"));
        hashMap.put("matlab.code.codeanalzyer", Arrays.asList("com.mathworks.mde.editor.plugins.editordataservice.CodeAnalyzerFeature"));
        hashMap.put("matlab.code.tabcompletion", Arrays.asList("com.mathworks.mde.editor.plugins.matlab.TabCompletionFeature"));
        hashMap.put("matlab.preferences", Arrays.asList("com.mathworks.mde.editor.plugins.editordataservice.MatlabPreferencesFeature"));
        return hashMap;
    }

    public void dispose() {
        if (this.fPeerModelManager.hasRoot()) {
            this.fPeerModelManager.getRoot().destroy();
        }
        this.fPeerModelManager.removeEventListener("rootSet", this.fRootSetObserver);
    }
}

