/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.EventObject;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.ErrorManager;
import org.openide.util.Utilities;

abstract class WeakListenerImpl
implements EventListener {
    private ListenerReference ref;
    Class listenerClass;
    private Reference source;

    protected WeakListenerImpl(Class clazz, EventListener eventListener) {
        this.listenerClass = clazz;
        this.ref = new ListenerReference(eventListener, this);
    }

    protected final void setSource(Object object) {
        this.source = object == null ? null : new WeakReference<Object>(object);
    }

    protected abstract String removeMethodName();

    protected final EventListener get(EventObject eventObject) {
        Object t = this.ref.get();
        if (t == null) {
            this.ref.requestCleanUp(eventObject == null ? null : eventObject.getSource());
        }
        return (EventListener)t;
    }

    Object getImplementator() {
        return this;
    }

    public String toString() {
        Object t = this.ref.get();
        return this.getClass().getName() + "[" + (t == null ? "null" : t.getClass().getName() + "]");
    }

    public static EventListener create(Class clazz, Class clazz2, EventListener eventListener, Object object) {
        ProxyListener proxyListener = new ProxyListener(clazz, clazz2, eventListener);
        proxyListener.setSource(object);
        return (EventListener)proxyListener.proxy;
    }

    private static final class ListenerReference
    extends WeakReference
    implements Runnable {
        private static Class lastClass;
        private static String lastMethodName;
        private static Method lastRemove;
        private static Object LOCK;
        WeakListenerImpl weakListener;

        public ListenerReference(Object object, WeakListenerImpl weakListenerImpl) {
            super(object, Utilities.activeReferenceQueue());
            this.weakListener = weakListenerImpl;
        }

        public synchronized void requestCleanUp(Object object) {
            if (this.weakListener == null) {
                return;
            }
            if (this.weakListener.source != object) {
                this.weakListener.source = new WeakReference(object){
                    ListenerReference doNotGCRef;
                    {
                        this.doNotGCRef = new ListenerReference(new Object(), ListenerReference.this.weakListener);
                    }
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WeakListenerImpl weakListenerImpl;
            Object[] objectArray = new Object[1];
            Class[] classArray = new Class[1];
            Object object = null;
            Method method = null;
            Object object2 = this;
            synchronized (object2) {
                block18: {
                    block17: {
                        weakListenerImpl = this.weakListener;
                        if (weakListenerImpl.source == null) break block17;
                        Object t = weakListenerImpl.source.get();
                        object = t;
                        if (t != null) break block18;
                    }
                    return;
                }
                this.weakListener = null;
            }
            object2 = object.getClass();
            String string = weakListenerImpl.removeMethodName();
            Object object3 = LOCK;
            synchronized (object3) {
                if (lastClass == object2 && lastMethodName == string && lastRemove != null) {
                    method = lastRemove;
                }
            }
            if (method == null) {
                classArray[0] = weakListenerImpl.listenerClass;
                method = this.getRemoveMethod((Class)object2, string, classArray[0]);
                if (method == null) {
                    ErrorManager.getDefault().log(16, "Can't remove " + weakListenerImpl.listenerClass.getName() + " using method " + string + " from " + object);
                    return;
                }
                object3 = LOCK;
                synchronized (object3) {
                    lastClass = object2;
                    lastMethodName = string;
                    lastRemove = method;
                }
            }
            objectArray[0] = weakListenerImpl.getImplementator();
            try {
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().annotate((Throwable)exception, "Problem encountered while calling " + object2 + "." + string + "(...) on " + object);
                ErrorManager.getDefault().notify(1, exception);
            }
        }

        private Method getRemoveMethod(Class clazz, String string, Class clazz2) {
            Class[] classArray = new Class[]{clazz2};
            Method method = null;
            try {
                method = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                do {
                    try {
                        method = clazz.getDeclaredMethod(string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                    clazz = clazz.getSuperclass();
                } while (method == null && clazz != Object.class);
            }
            if (!(method == null || Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()))) {
                method.setAccessible(true);
            }
            return method;
        }

        static {
            LOCK = new Object();
        }
    }

    private static class ProxyListener
    extends WeakListenerImpl
    implements InvocationHandler {
        private static Method equalsMth;
        private static final WeakHashMap constructors;
        public final Object proxy;

        public ProxyListener(Class clazz, Class clazz2, EventListener eventListener) {
            super(clazz2, eventListener);
            try {
                Object object;
                Constructor<Object> constructor;
                Reference reference = (Reference)constructors.get(clazz);
                Constructor<Object> constructor2 = constructor = reference == null ? null : (Constructor<Object>)reference.get();
                if (constructor == null) {
                    object = Proxy.getProxyClass(clazz.getClassLoader(), clazz);
                    constructor = ((Class)object).getConstructor(InvocationHandler.class);
                    constructors.put(clazz, new SoftReference<Constructor<Object>>(constructor));
                }
                try {
                    object = constructor.newInstance(this);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
                }
                this.proxy = object;
            }
            catch (Exception exception) {
                IllegalStateException illegalStateException = new IllegalStateException(exception.getMessage());
                ErrorManager.getDefault().annotate((Throwable)illegalStateException, exception);
                throw illegalStateException;
            }
        }

        private static Method getEquals() {
            if (equalsMth == null) {
                try {
                    equalsMth = Object.class.getMethod("equals", Object.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
            }
            return equalsMth;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if (method == ProxyListener.getEquals()) {
                    boolean bl = this.equals(objectArray[0]);
                    return bl ? Boolean.TRUE : Boolean.FALSE;
                }
                return method.invoke((Object)this, objectArray);
            }
            EventObject eventObject = objectArray != null && objectArray[0] instanceof EventObject ? (EventObject)objectArray[0] : null;
            EventListener eventListener = super.get(eventObject);
            if (eventListener != null) {
                return method.invoke((Object)eventListener, objectArray);
            }
            return null;
        }

        @Override
        protected String removeMethodName() {
            String string = this.listenerClass.getName();
            int n = string.lastIndexOf(46);
            int n2 = (string = string.substring(n + 1)).lastIndexOf(36);
            if (n2 >= 0) {
                string = string.substring(n2 + 1);
            }
            return "remove".concat(string);
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.listenerClass + "]";
        }

        public boolean equals(Object object) {
            return this.proxy == object || this == object;
        }

        @Override
        Object getImplementator() {
            return this.proxy;
        }

        static {
            constructors = new WeakHashMap();
        }
    }

    static final class Focus
    extends WeakListenerImpl
    implements FocusListener {
        public Focus(FocusListener focusListener) {
            super(FocusListener.class, focusListener);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            FocusListener focusListener = (FocusListener)super.get(focusEvent);
            if (focusListener != null) {
                focusListener.focusGained(focusEvent);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            FocusListener focusListener = (FocusListener)super.get(focusEvent);
            if (focusListener != null) {
                focusListener.focusLost(focusEvent);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeFocusListener";
        }
    }

    static final class Change
    extends WeakListenerImpl
    implements ChangeListener {
        public Change(ChangeListener changeListener) {
            super(ChangeListener.class, changeListener);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ChangeListener changeListener = (ChangeListener)super.get(changeEvent);
            if (changeListener != null) {
                changeListener.stateChanged(changeEvent);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeChangeListener";
        }
    }

    static final class Document
    extends WeakListenerImpl
    implements DocumentListener {
        public Document(DocumentListener documentListener) {
            super(DocumentListener.class, documentListener);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.changedUpdate(documentEvent);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.insertUpdate(documentEvent);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.removeUpdate(documentEvent);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeDocumentListener";
        }

        private DocumentListener docGet(DocumentEvent documentEvent) {
            DocumentListener documentListener = (DocumentListener)((WeakListenerImpl)this).ref.get();
            if (documentListener == null) {
                ((WeakListenerImpl)this).ref.requestCleanUp(documentEvent.getDocument());
            }
            return documentListener;
        }
    }

    static class VetoableChange
    extends WeakListenerImpl
    implements VetoableChangeListener {
        public VetoableChange(VetoableChangeListener vetoableChangeListener) {
            super(VetoableChangeListener.class, vetoableChangeListener);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)super.get(propertyChangeEvent);
            if (vetoableChangeListener != null) {
                vetoableChangeListener.vetoableChange(propertyChangeEvent);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeVetoableChangeListener";
        }
    }

    static class PropertyChange
    extends WeakListenerImpl
    implements PropertyChangeListener {
        public PropertyChange(PropertyChangeListener propertyChangeListener) {
            super(PropertyChangeListener.class, propertyChangeListener);
        }

        PropertyChange(Class clazz, PropertyChangeListener propertyChangeListener) {
            super(clazz, propertyChangeListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)super.get(propertyChangeEvent);
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removePropertyChangeListener";
        }
    }
}

