/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets;

import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlservices.MLExecutionEvent;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.mwswing.MJLabel;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;

public class MatlabStatusImage
extends MJLabel
implements MLExecutionListener,
ActionListener {
    private ImageIcon fIdle = new ImageIcon(this.getClass().getResource("/com/mathworks/mwswing/resources/status_matlab_idle.gif"));
    private ImageIcon fBusy = new ImageIcon(this.getClass().getResource("/com/mathworks/mwswing/resources/status_matlab_busy.gif"));
    private ImageIcon fImage;
    private boolean fBusyTimerPending;
    private Timer fBusyTimer;
    private MLExecutionEvent fPendingEvent;
    private static final int BUSY_DELAY = 100;
    private boolean fInitialized = false;

    public MatlabStatusImage() {
        this.setIcon(this.fBusy);
        this.fImage = this.fBusy;
        this.fBusyTimer = new Timer(100, this);
        this.fBusyTimer.setRepeats(false);
        MLExecuteServices.addMLExecutionListener((MLExecutionListener)this);
    }

    public void paintComponent(Graphics graphics) {
        graphics.drawImage(this.fImage.getImage(), 0, 0, this.getSize().width, this.getSize().height, (ImageObserver)((Object)this));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fPendingEvent = (MLExecutionEvent)changeEvent;
        if (!this.fInitialized) {
            this.fInitialized = this.fPendingEvent.fromInterpreter();
            if (!this.fInitialized) {
                return;
            }
        }
        if (this.fBusyTimerPending) {
            this.fBusyTimerPending = false;
            this.fBusyTimer.stop();
            this.setImageIconBusy(this.fPendingEvent);
        } else {
            this.fBusyTimerPending = true;
            this.fBusyTimer.start();
        }
    }

    private void setImageIconBusy(MLExecutionEvent mLExecutionEvent) {
        boolean bl = (mLExecutionEvent.isCommandBusy() || mLExecutionEvent.isCommandInProgress() || !mLExecutionEvent.isCommandOver()) && !mLExecutionEvent.isEnteringKeyboardMode() && !mLExecutionEvent.isAtKeyboard() && mLExecutionEvent.getInterpretedStatus() != MLExecutionEvent.InterpretedStatus.AT_BREAKPOINT;
        this.fImage = bl ? this.fBusy : this.fIdle;
        this.repaint();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (this.fBusyTimerPending) {
            this.fBusyTimerPending = false;
            this.setImageIconBusy(this.fPendingEvent);
        }
    }
}

