/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.tooltip.BalloonToolTip;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;

public final class TransparentDialog
extends MJDialog {
    private TransparentPanel fContentPane;
    private boolean fTransparent = true;
    private Dialog fDialogOwner = null;
    private Frame fFrameOwner = null;
    private ComponentListener fComponentListener;
    private WindowFocusListener fWindowFocusListener;
    private static Robot sRobot;

    public TransparentDialog(Dialog dialog) {
        super((Frame)dialog.getParent());
        this.setUndecorated(true);
        this.fDialogOwner = dialog;
        this.init();
        this.setTransparent(true);
    }

    public TransparentDialog(Frame frame) {
        super((Frame)frame.getParent());
        this.setUndecorated(true);
        this.fFrameOwner = frame;
        this.init();
        this.setTransparent(true);
    }

    TransparentDialog(Dialog dialog, boolean bl) {
        this.setAlwaysOnTop(bl);
        this.setUndecorated(true);
        this.fDialogOwner = dialog;
        this.init();
        this.setTransparent(true);
    }

    TransparentDialog(Frame frame, boolean bl) {
        this.setAlwaysOnTop(bl);
        this.setUndecorated(true);
        this.fFrameOwner = frame;
        this.init();
        this.setTransparent(true);
    }

    Rectangle getOwnerBounds() {
        if (this.fDialogOwner != null) {
            return this.fDialogOwner.getBounds();
        }
        return null;
    }

    void setTransparent(boolean bl) {
        this.fTransparent = bl;
        if (this.fTransparent && TransparentDialog.isTransparencySupported()) {
            this.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        }
    }

    public boolean getTranparent() {
        return this.fTransparent;
    }

    static boolean isTransparencySupported() {
        return PlatformInfo.isIntelMac() || PlatformInfo.isWindows();
    }

    public void show() {
        if (PlatformInfo.isWindows() && this.fTransparent && this.fContentPane != null && this.getContentPane() == this.fContentPane) {
            this.fContentPane.takeSnapShot();
        }
        super.show();
        this.paint(this.getGraphics());
    }

    public void toFront() {
        if (this.fTransparent) {
            this.setFocusableWindowState(false);
        } else {
            this.setFocusableWindowState(BalloonToolTip.isAlwaysFocusable());
        }
        super.toFront();
    }

    void init() {
        if (PlatformInfo.isWindows()) {
            try {
                sRobot = new Robot();
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
            this.fContentPane = new TransparentPanel();
            this.setContentPane((Container)((Object)this.fContentPane));
        } else if (PlatformInfo.isIntelMac()) {
            this.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        }
        this.fComponentListener = new ComponentAdapter(){

            void removeListenersAndDispose() {
                if (TransparentDialog.this.fDialogOwner != null) {
                    TransparentDialog.this.fDialogOwner.removeComponentListener(TransparentDialog.this.fComponentListener);
                }
                if (TransparentDialog.this.fFrameOwner != null) {
                    TransparentDialog.this.fFrameOwner.removeComponentListener(TransparentDialog.this.fComponentListener);
                }
                TransparentDialog.this.dispose();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                this.removeListenersAndDispose();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                this.removeListenersAndDispose();
            }
        };
        this.fWindowFocusListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                TransparentDialog.this.toFront();
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                TransparentDialog.this.toFront();
            }
        };
        if (this.fDialogOwner != null) {
            this.fDialogOwner.addComponentListener(this.fComponentListener);
            this.fDialogOwner.addWindowFocusListener(this.fWindowFocusListener);
        } else if (this.fFrameOwner != null) {
            this.fFrameOwner.addComponentListener(this.fComponentListener);
            this.fFrameOwner.addWindowFocusListener(this.fWindowFocusListener);
        }
    }

    void deParent() {
        this.cleanup();
    }

    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    void cleanup() {
        if (this.fDialogOwner != null) {
            this.fDialogOwner.removeComponentListener(this.fComponentListener);
            this.fDialogOwner.removeWindowFocusListener(this.fWindowFocusListener);
        }
        if (this.fFrameOwner != null) {
            this.fFrameOwner.removeComponentListener(this.fComponentListener);
            this.fFrameOwner.removeWindowFocusListener(this.fWindowFocusListener);
        }
        this.fComponentListener = null;
        this.fWindowFocusListener = null;
        this.fDialogOwner = null;
        this.fFrameOwner = null;
    }

    private class TransparentPanel
    extends MJPanel {
        private BufferedImage fImage;

        TransparentPanel() {
            super((LayoutManager)new BorderLayout(5, 5));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }

        protected void paintComponent(Graphics graphics) {
            if (TransparentDialog.this.fTransparent) {
                graphics.drawImage(this.fImage, this.getBounds().x, this.getBounds().y, null);
            } else {
                super.paintComponent(graphics);
            }
        }

        private void takeSnapShot() {
            if (sRobot == null) {
                return;
            }
            Rectangle rectangle = TransparentDialog.this.getBounds();
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                return;
            }
            Point point = new Point(rectangle.x, rectangle.y);
            this.fImage = sRobot.createScreenCapture(new Rectangle(point.x, point.y, rectangle.width, rectangle.height));
        }
    }
}

