/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.array.AbstractDatasetTable;
import com.mathworks.mlwidgets.array.AbstractTabularObjectTable;
import com.mathworks.mlwidgets.array.ArrayColumnModel;
import com.mathworks.mlwidgets.array.ArrayTable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.ExtractVariableAction;
import com.mathworks.mlwidgets.array.ObjectIdentifier;
import com.mathworks.mlwidgets.array.RefreshableObjectVariableLiteral;
import com.mathworks.mlwidgets.array.TabularObjectTable;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.spreadsheet.SpreadsheetColumnModel;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class AbstractVariableObjectTable
extends AbstractTabularObjectTable {
    protected MJMenu fExtractMenu;
    protected String fLastCopyKey;
    private ExtractCellArrayAction fExtractCellArrayAction = new ExtractCellArrayAction();

    public AbstractVariableObjectTable(TabularObjectTableModel tabularObjectTableModel) {
        super(tabularObjectTableModel);
        this.fExtractCellArrayAction.setComponentName("ExtractCellArrays");
    }

    public void createDefaultColumnsFromModel() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableModel tableModel = this.getModel();
        if (tableModel != null && tableColumnModel instanceof ArrayColumnModel) {
            ((SpreadsheetColumnModel)tableColumnModel).clear();
            ((ArrayColumnModel)((Object)tableColumnModel)).setColumnCount(tableModel.getColumnCount());
        } else {
            super.createDefaultColumnsFromModel();
        }
    }

    public Dimension getPreferredSize() {
        if (this.getColumnModel() instanceof ArrayColumnModel) {
            int n = 0;
            int n2 = this.getRowCount();
            if (n2 > 0 && this.getColumnCount() > 0) {
                Rectangle rectangle = this.getCellRect(n2 - 1, 0, true);
                n = rectangle.y + rectangle.height;
            }
            return new Dimension(this.getColumnModel().getTotalColumnWidth(), n);
        }
        return super.getPreferredSize();
    }

    protected JTableHeader createDefaultTableHeader() {
        return new ArrayTable.ArrayTableHeader(this.columnModel);
    }

    protected void doRegionCut(ActionEvent actionEvent) {
        this.doRegionCopy(actionEvent);
        if (!this.isAllTabularObjectRowsSelected() && !this.isAllTabularObjectColumnsSelected()) {
            return;
        }
        String string = this.getSelectionNameString() + "= [];";
        ((TabularObjectTableModel)((Object)this.getModel())).evalMatlabString(string, false);
    }

    @Override
    public void doColumnInsert(TabularObjectTableModel.PasteType pasteType) {
        this.doPaste(0, pasteType);
    }

    @Override
    void doRowInsert(TabularObjectTableModel.PasteType pasteType) {
        this.doPaste(0, pasteType);
    }

    abstract void doPaste(int var1, TabularObjectTableModel.PasteType var2);

    String getEvalStringForPasteInsert(TabularObjectTableModel.PasteType pasteType, String string, int n, int n2, int n3, int n4) {
        int n5;
        String string2 = null;
        int n6 = pasteType == TabularObjectTableModel.PasteType.INSERTCOLUMNS_RIGHT ? n3 + 1 : 1;
        int n7 = n5 = pasteType == TabularObjectTableModel.PasteType.INSERTROWS_BELOW ? n4 + 1 : 1;
        if (pasteType == TabularObjectTableModel.PasteType.INSERTCOLUMNS || pasteType == TabularObjectTableModel.PasteType.INSERTCOLUMNS_RIGHT) {
            string2 = this.getVariableName() + "= variableEditorInsert(" + this.getVariableName() + ",'columns'," + Integer.toString(n2 + n5) + "," + Integer.toString(n + n6) + ",arrayviewfunc('retrieveValue','" + string + "'));";
        } else if (pasteType == TabularObjectTableModel.PasteType.INSERTROWS || pasteType == TabularObjectTableModel.PasteType.INSERTROWS_BELOW) {
            string2 = this.getVariableName() + "= variableEditorInsert(" + this.getVariableName() + ",'rows'," + Integer.toString(n2 + n5) + "," + Integer.toString(n + n6) + ",arrayviewfunc('retrieveValue','" + string + "'));";
        }
        return string2;
    }

    protected void doPaste(int n) {
        this.doPaste(n, TabularObjectTableModel.PasteType.PASTE);
    }

    protected void pasteContent(int n) {
        super.doPaste(n);
    }

    protected void setupContextMenu() {
        this.fSelectionPopupMenu = new MJPopupMenu();
        this.fSelectionPopupMenu.add(this.getCutAction());
        this.fSelectionPopupMenu.add(this.getCopyAction());
        this.fSelectionPopupMenu.add(this.getPasteAction());
        this.fExtractMenu = new MJMenu(ArrayUtils.getResource("dataset.createfromselect"));
        this.fExtractMenu.setName("ExtractParent");
        this.setupInsertActions("categorical");
        this.fInsertColumnAction.setComponentName("InsertAsNewVariable");
        this.fInsertColumnRightAction.setComponentName("InsertAsNewVariableRight");
        this.fInsertRowAction.setComponentName("InsertAsNewObservation");
        this.fInsertRowBelowAction.setComponentName("InsertAsNewObservationBelow");
        this.addContextMenuMouseListener();
    }

    @Override
    protected void populateClipboardFromIdentifier(VariableIdentifier variableIdentifier) {
        if (variableIdentifier.getVariable() != null || variableIdentifier.getExpression() != null) {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            RefreshableObjectVariableLiteral.populateClipboardFromObjectIdentifier((ObjectIdentifier)variableIdentifier, (ChangeListener)new SpreadsheetTable.CopyChangeListener((SpreadsheetTable)this, cursor));
        }
    }

    @Override
    protected String[] getSelectionVariableStrings() {
        String string = this.getSelectionNameString();
        if (string != null) {
            return new String[]{string};
        }
        return null;
    }

    @Override
    protected String getSelectionNameString() {
        String string;
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        int[] nArray2 = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
        if (nArray.length == 0 || nArray2.length == 0) {
            return null;
        }
        int[] nArray3 = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
        String string2 = TabularObjectTable.arrayToMatlabString(nArray, nArray3[0]);
        if (string2.contains(",") && !string2.startsWith("[")) {
            string2 = "[" + string2 + "]";
        }
        if ((string = TabularObjectTable.arrayToMatlabString(nArray2, nArray3[1])).contains(",") && !string.startsWith("[")) {
            string = "[" + string + "]";
        }
        if (string2.isEmpty() && string.isEmpty()) {
            return this.getVariableName();
        }
        if (string.isEmpty()) {
            return this.getVariableName() + "(" + string2 + ",:)";
        }
        if (string2.isEmpty()) {
            return this.getVariableName() + "(:," + string + ")";
        }
        return this.getVariableName() + "(" + string2 + "," + string + ")";
    }

    protected void doRegionCopy(ActionEvent actionEvent) {
        String string = this.getSelectionNameString();
        if (string == null || string.isEmpty()) {
            return;
        }
        this.fLastCopyKey = this.getVariableName() + "_copy";
        this.populateClipboardFromIdentifier(new ObjectIdentifier(string, string, this.fLastCopyKey, this.getVariable().getWorkspaceID()));
    }

    @Override
    public boolean isSortEnabled() {
        return true;
    }

    @Override
    void sortAscending() {
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
        if (nArray == null || nArray.length == 0) {
            return;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Integer.toString(nArray[i] + 1);
        }
        ((TabularObjectTableModel)((Object)this.getModel())).sortAscending(stringArray);
    }

    @Override
    void sortDescending() {
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
        if (nArray == null || nArray.length == 0) {
            return;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Integer.toString(nArray[i] + 1);
        }
        ((TabularObjectTableModel)((Object)this.getModel())).sortDescending(stringArray);
    }

    Runnable getPostPasteSelectionRunnable(String string, Point point) {
        return new PostPasteSelectionRunnable(string, point);
    }

    protected boolean updateBaseMenuForSelectionChange(String[] stringArray) {
        int n;
        this.fExtractCellArrayAction.setEnabled(stringArray != null && stringArray.length > 0);
        this.fExtractMenu.setEnabled(stringArray != null && stringArray.length > 0);
        if (this.fSelectionPopupMenu == null) {
            return true;
        }
        for (n = 0; n < this.fSPItemsAddedCount; ++n) {
            this.fSelectionPopupMenu.remove(this.fSelectionPopupMenu.getComponentCount() - 1);
        }
        this.fSPItemsAddedCount = 0;
        if (this.getSelectedColumnCount() > 0 && this.getSelectedRowCount() > 0) {
            n = this.isAllTabularObjectColumnsSelected() ? 1 : 0;
            boolean bl = this.isAllTabularObjectRowsSelected();
            if (!(n == 0 && !bl || n != 0 && bl)) {
                if (bl) {
                    this.fSelectionPopupMenu.add((Action)this.fInsertColumnAction);
                    this.fSelectionPopupMenu.add((Action)this.fInsertColumnRightAction);
                } else {
                    this.fSelectionPopupMenu.add((Action)this.fInsertRowAction);
                    this.fSelectionPopupMenu.add((Action)this.fInsertRowBelowAction);
                }
                this.fSPItemsAddedCount += 2;
                this.fSelectionPopupMenu.addSeparator();
                ++this.fSPItemsAddedCount;
                if (bl) {
                    this.fSelectionPopupMenu.add((Action)this.fDeleteColumnAction);
                    ++this.fSPItemsAddedCount;
                }
                if (!bl) {
                    this.fSelectionPopupMenu.add((Action)this.fDeleteRowAction);
                    ++this.fSPItemsAddedCount;
                }
            }
            if (bl && this.isSortEnabled()) {
                this.fSelectionPopupMenu.addSeparator();
                this.fSelectionPopupMenu.add((Action)this.fSortAscendingAction);
                this.fSelectionPopupMenu.add((Action)this.fSortDescendingAction);
                this.fSPItemsAddedCount += 3;
            }
        }
        return false;
    }

    @Override
    public void cleanup() {
        String string = this.getVariableName() + "_copy";
        boolean bl = false;
        MJClipboard mJClipboard = MJClipboard.getMJClipboard();
        try {
            List list = (List)mJClipboard.getData(MLDataFlavor.simpleVariableListFlavor);
            SimpleVariableDefinition simpleVariableDefinition = (SimpleVariableDefinition)list.get(0);
            if (simpleVariableDefinition instanceof RefreshableObjectVariableLiteral.ObjectVariableDefinition) {
                bl = string.equals(((RefreshableObjectVariableLiteral.ObjectVariableDefinition)simpleVariableDefinition).getObjectIdentifier().getKey());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Matlab.isMatlabAvailable() && !bl) {
            WorkspaceMCRProvider.getMCRForUserActions().feval("arrayviewfunc", new Object[]{"clearValueSafely", this.fLastCopyKey}, null);
        }
        super.cleanup();
    }

    protected MJAbstractAction getExtractCellArrayAction() {
        return this.fExtractCellArrayAction;
    }

    private class ExtractCellArrayAction
    extends MJAbstractAction {
        private ExtractCellArrayAction() {
            this.setName(ArrayUtils.getResource("dataset.newcell"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = AbstractVariableObjectTable.this.getSelectionNameString();
            if (string == null || string.isEmpty()) {
                return;
            }
            final String string2 = "cellstr(" + AbstractVariableObjectTable.this.getSelectionNameString() + ")";
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    String string = AbstractDatasetTable.getUniqueMatlabVariableName(AbstractVariableObjectTable.this.getVariable().getVariableName());
                    if (ArrayUtils.isCodeGenEnabled()) {
                        MLExecuteServices.executeCommand((String)(string + " = " + string2 + ";"));
                    } else {
                        MLExecuteServices.consoleEval((String)(string + " = " + string2 + ";"));
                    }
                    MLExecuteServices.consoleEval((String)("openvar('" + string + "');"));
                }
            });
        }
    }

    protected static class VarCreator
    implements ExtractVariableAction.VariableCreatorInterface {
        protected VarCreator() {
        }

        @Override
        public void createVariable(String string) {
            try {
                String string2;
                int n = string.indexOf("openvar");
                String string3 = null;
                if (n >= 0) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n);
                } else {
                    string2 = string;
                }
                if (ArrayUtils.isCodeGenEnabled()) {
                    MLExecuteServices.executeCommand((String)string2);
                } else {
                    MLExecuteServices.consoleEval((String)string2);
                }
                if (string3 != null) {
                    MLExecuteServices.consoleEval((String)string3);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class PostPasteSelectionRunnable
    implements Runnable {
        private final String iPastedDataExpression;
        private final Point iTopLeftCell;

        PostPasteSelectionRunnable(String string, Point point) {
            this.iPastedDataExpression = string;
            this.iTopLeftCell = point;
        }

        @Override
        public void run() {
            MatlabWorker<double[]> matlabWorker = new MatlabWorker<double[]>(){

                public double[] runOnMatlabThread() {
                    try {
                        return (double[])Matlab.mtEval((String)("size(" + PostPasteSelectionRunnable.this.iPastedDataExpression + ");"), (int)1);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                public void runOnAWTEventDispatchThread(double[] dArray) {
                    if (dArray == null || dArray.length != 2) {
                        return;
                    }
                    AbstractVariableObjectTable.this.clearSelection();
                    AbstractVariableObjectTable.this.setRowSelectionInterval(((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.x, ((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.x + (int)dArray[0] - 1);
                    AbstractVariableObjectTable.this.setColumnSelectionInterval(((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.y, ((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.y + (int)dArray[1] - 1);
                }
            };
            matlabWorker.start();
        }
    }
}

