/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayEditorProvider;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.EditableValue;
import com.mathworks.mlwidgets.array.FormatToolsetSupplierFactory;
import com.mathworks.mlwidgets.array.ValueEditorProvider;
import com.mathworks.mlwidgets.array.VariableCodeGenProvider;
import com.mathworks.mlwidgets.array.VariableFormatSpecifier;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.spreadsheet.ISpreadsheetNavPrefControl;
import com.mathworks.widgets.spreadsheet.SpreadsheetActions;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.FormattableDisplay;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;

public class AggregatedComponents {
    private ValueEditorProvider fProvider;
    private Action[] fContextActions;
    private int stopEditingCount = 0;

    AggregatedComponents(ValueEditorProvider valueEditorProvider, FormattableDisplay formattableDisplay, WorkspaceVariable workspaceVariable) {
        this.fProvider = valueEditorProvider;
        this.registerQuickActions(valueEditorProvider);
    }

    private void registerQuickActions(ValueEditorProvider valueEditorProvider) {
        Action action = SpreadsheetActions.getPasteAction((Object)valueEditorProvider.getClipboardOpProvider());
        ContextTargetingManager.setToolName((Action)action, (String)DTMenuMergeTag.PASTE.toString());
        Action action2 = SpreadsheetActions.getCopyAction((Object)valueEditorProvider.getClipboardOpProvider());
        ContextTargetingManager.setToolName((Action)action2, (String)DTMenuMergeTag.COPY.toString());
        Action action3 = SpreadsheetActions.getCutAction((Object)valueEditorProvider.getClipboardOpProvider());
        ContextTargetingManager.setToolName((Action)action3, (String)DTMenuMergeTag.CUT.toString());
        Action action4 = SpreadsheetActions.getSaveAction((Object)valueEditorProvider);
        ContextTargetingManager.setToolName((Action)action4, (String)DTMenuMergeTag.SAVE.toString());
        Action action5 = SpreadsheetActions.getPrintAction((Object)valueEditorProvider);
        ContextTargetingManager.setToolName((Action)action5, (String)DTMenuMergeTag.PRINT.toString());
        Action action6 = SpreadsheetActions.getPrintSelectionAction((Object)valueEditorProvider);
        ContextTargetingManager.setToolName((Action)action6, (String)DTMenuMergeTag.PRINT_SELECTION.toString());
        Action action7 = SpreadsheetActions.getPageSetupAction((Object)valueEditorProvider);
        ContextTargetingManager.setToolName((Action)action7, (String)DTMenuMergeTag.PAGE_SETUP.toString());
        Action action8 = SpreadsheetActions.getUndoAction((Object)valueEditorProvider.getUndoOpProvider());
        ContextTargetingManager.setToolName((Action)action8, (String)DTMenuMergeTag.UNDO.toString());
        Action action9 = SpreadsheetActions.getRedoAction((Object)valueEditorProvider.getUndoOpProvider());
        ContextTargetingManager.setToolName((Action)action9, (String)DTMenuMergeTag.REDO.toString());
        Action action10 = SpreadsheetActions.getSelectAllAction((Object)valueEditorProvider);
        ContextTargetingManager.setToolName((Action)action10, (String)DTMenuMergeTag.SELECT_ALL.toString());
        Action action11 = SpreadsheetActions.getDeleteAction((Object)valueEditorProvider);
        ContextTargetingManager.setToolName((Action)action11, (String)DTMenuMergeTag.DELETE.toString());
        MJAbstractAction mJAbstractAction = (MJAbstractAction)SpreadsheetActions.getClearContentsAction((Object)valueEditorProvider);
        if (valueEditorProvider instanceof ArrayEditorProvider) {
            mJAbstractAction.setName(ArrayUtils.getResource("replace.WithZero"));
        } else {
            mJAbstractAction.setName(ArrayUtils.getResource("replace.WithEmpty"));
        }
        this.fContextActions = new Action[]{action4, action5, action6, action7, action8, action9, action3, action2, action, action10, action11};
    }

    public boolean supportsCodeGen() {
        return this.fProvider instanceof VariableCodeGenProvider;
    }

    public List<FormatToolsetSupplierFactory.FormatSupported> getSupportedFormats() {
        if (this.fProvider instanceof VariableFormatSpecifier) {
            return ((VariableFormatSpecifier)((Object)this.fProvider)).getSupportedFormats();
        }
        return null;
    }

    public Action[] getContextActions() {
        return this.fContextActions;
    }

    void cleanup() {
        this.fProvider.cleanup();
    }

    public void setFont(Font font) {
        this.fProvider.getComponent().setFont(font);
    }

    public Font getFont() {
        return this.fProvider.getComponent().getFont();
    }

    public void setForeground(Color color) {
        this.fProvider.getComponent().setForeground(color);
    }

    public Color getForeground() {
        return this.fProvider.getComponent().getForeground();
    }

    public void setBackground(Color color) {
        this.fProvider.getComponent().setBackground(color);
    }

    public Color getBackground() {
        return this.fProvider.getComponent().getBackground();
    }

    void setFormat(FormatIdentifier formatIdentifier) {
        if (this.fProvider.getFormattableDisplay() != null) {
            this.fProvider.getFormattableDisplay().setFormat(formatIdentifier);
        }
    }

    public ValueEditorProvider getProvider() {
        return this.fProvider;
    }

    void setMotionOnEnterDirection(int n) {
        if (this.fProvider.getComponent() instanceof ISpreadsheetNavPrefControl) {
            ((ISpreadsheetNavPrefControl)this.fProvider.getComponent()).setMotionOnEnterDirection(n);
        }
    }

    void setMotionOnEnter(boolean bl) {
        if (this.fProvider.getComponent() instanceof ISpreadsheetNavPrefControl) {
            ((ISpreadsheetNavPrefControl)this.fProvider.getComponent()).setMotionOnEnter(bl);
        }
    }

    void setEditable(boolean bl) {
        JComponent jComponent = this.fProvider.getComponent();
        if (jComponent != null && jComponent instanceof EditableValue) {
            ((EditableValue)((Object)jComponent)).setEditable(bl);
        }
    }

    public int getStopEditingCount() {
        return this.stopEditingCount;
    }

    void stopEditing() {
        ++this.stopEditingCount;
        JComponent jComponent = this.fProvider.getComponent();
        if (jComponent != null && jComponent instanceof EditableValue) {
            ((EditableValue)((Object)jComponent)).stopEditing();
        }
    }
}

