/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.AbstractTabularObjectTable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.CategoricalVariableTable;
import com.mathworks.mlwidgets.array.CategoricalVariableTableModel;
import com.mathworks.mlwidgets.array.TabularObjectTable;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.array.data.CategoricalScalar;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class CategoricalVariableEditor
extends AbstractCellEditor
implements TableCellEditor {
    private EditingComboBox fComboBox = new EditingComboBox();
    private KeyListener fKeyListener;
    private static Prompt PROMPT = new Prompt();

    CategoricalVariableEditor() {
        this.fComboBox.setCategoricalVariableEditor(this);
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        boolean bl;
        if (eventObject == null) {
            return true;
        }
        boolean bl2 = bl = !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getClickCount() >= 2;
        if (!bl) {
            return false;
        }
        Object object = eventObject.getSource();
        if (!(object instanceof JTable)) {
            return false;
        }
        JTable jTable = (JTable)eventObject.getSource();
        return jTable.getModel() instanceof TabularObjectTableModel;
    }

    @Override
    public Component getTableCellEditorComponent(final JTable jTable, Object object, boolean bl, int n, int n2) {
        String[] stringArray;
        String string = null;
        if (jTable instanceof TabularObjectTable) {
            string = ((TabularObjectTable)((Object)jTable)).fTabularObjectColumnModel.getVariableName(((TabularObjectTable)((Object)jTable)).fTabularObjectColumnModel.getGroupIndex(n2));
            stringArray = ((TabularObjectTable)((Object)jTable)).fTabularObjectColumnModel.getVarName();
            string = (String)stringArray + "." + string;
        } else if (jTable instanceof CategoricalVariableTable) {
            string = ((AbstractTabularObjectTable)((Object)jTable)).getVariableName();
        }
        this.fComboBox.setProtected(CategoricalVariableTableModel.isVarProtected(string));
        this.fComboBox.setEditable(false);
        this.fComboBox.reset();
        this.fComboBox.removePromptingListener();
        this.fComboBox.removeAllItems();
        if (object instanceof CategoricalScalar) {
            stringArray = ((CategoricalScalar)object).getLabels();
        } else if (object == null && jTable instanceof CategoricalVariableTable && jTable.getValueAt(0, 0) instanceof CategoricalScalar) {
            stringArray = ((CategoricalScalar)jTable.getValueAt(0, 0)).getLabels();
        } else if (object == null && jTable.getValueAt(0, n2) instanceof CategoricalScalar) {
            stringArray = ((CategoricalScalar)jTable.getValueAt(0, n2)).getLabels();
        } else {
            return null;
        }
        for (String string2 : stringArray) {
            this.fComboBox.addItem(string2);
        }
        if (object != null) {
            this.fComboBox.setSelectedItem(object.toString().replaceAll("'", ""));
        } else if (this.fComboBox.getModel() instanceof DefaultComboBoxModel) {
            this.fComboBox.setSelectedIndex(((DefaultComboBoxModel)this.fComboBox.getModel()).getIndexOf(CategoricalScalar.UNDEFINED));
        }
        this.fComboBox.addPromptingListener();
        jTable.removeKeyListener(this.fKeyListener);
        if (this.fKeyListener == null) {
            this.fKeyListener = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    keyEvent.setSource((Object)CategoricalVariableEditor.this.fComboBox);
                    CategoricalVariableEditor.this.fComboBox.requestFocus();
                    int n = CategoricalVariableEditor.this.fComboBox.getKeySelectionManager().selectionForKey(keyEvent.getKeyChar(), CategoricalVariableEditor.this.fComboBox.getModel());
                    if (n >= 0 && !CategoricalVariableEditor.this.fComboBox.getItemAt(n).equals(PROMPT)) {
                        CategoricalVariableEditor.this.fComboBox.selectWithKeyChar(keyEvent.getKeyChar());
                    } else {
                        CategoricalVariableEditor.this.fComboBox.selectNewItemRow(keyEvent.getKeyChar());
                    }
                    jTable.removeKeyListener(this);
                }
            };
        }
        jTable.addKeyListener(this.fKeyListener);
        return this.fComboBox;
    }

    @Override
    public Object getCellEditorValue() {
        String[] stringArray;
        String[] stringArray2 = null;
        if (this.fComboBox.getSelectedItem() instanceof Prompt && !((stringArray = this.fComboBox.getEditor().getItem()) instanceof Prompt)) {
            stringArray2 = stringArray;
        }
        if (stringArray2 == null) {
            stringArray = new String[this.fComboBox.getItemCount() - 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)this.fComboBox.getItemAt(i);
            }
        } else {
            stringArray = new String[this.fComboBox.getItemCount()];
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringArray[i] = (String)this.fComboBox.getItemAt(i);
            }
            stringArray[stringArray.length - 1] = (String)stringArray2;
        }
        if (stringArray2 != null) {
            return new CategoricalScalar((String)stringArray2, stringArray);
        }
        if (this.fComboBox.getSelectedItem() instanceof Prompt) {
            return new CategoricalScalar(this.fComboBox.getItemAt(0).toString(), stringArray);
        }
        return new CategoricalScalar(this.fComboBox.getSelectedItem().toString(), stringArray);
    }

    @Override
    public void fireEditingStopped() {
        if (this.fComboBox.getSelectedItem() instanceof Prompt && this.fComboBox.getEditor().getItem() instanceof Prompt) {
            this.fireEditingCanceled();
        } else {
            super.fireEditingStopped();
        }
    }

    private static class Prompt {
        private Prompt() {
        }

        public String toString() {
            return ArrayUtils.getResource("dataset.CategoryNewItem");
        }
    }

    public static class EditingComboBox
    extends MJComboBox {
        private boolean iPrompting = false;
        private CategoricalVariableEditor iCategoricalVariableEditor;
        ItemListener iItemListener;
        private boolean isProtected = false;

        EditingComboBox() {
            this.setEditor(new LightWeightComboBoxEditor());
            this.setRenderer(new LightWeightComboBoxRenderer());
            this.addPrompt();
            if (PlatformInfo.isMacintosh()) {
                this.setUI(new BasicComboBoxUI());
            }
            KeyAdapter keyAdapter = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    if (EditingComboBox.this.iPrompting) {
                        ((JTextComponent)EditingComboBox.this.getEditor().getEditorComponent()).setText("");
                        EditingComboBox.this.getEditor().getEditorComponent().setForeground(Color.black);
                        EditingComboBox.this.iPrompting = false;
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (EditingComboBox.this.iCategoricalVariableEditor != null && keyEvent.getKeyCode() == 10) {
                        keyEvent.consume();
                        EditingComboBox.this.iCategoricalVariableEditor.fireEditingStopped();
                    }
                }
            };
            this.iItemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() != 1 || EditingComboBox.this.getSelectedIndex() < 0) {
                        return;
                    }
                    if (EditingComboBox.this.getItemCount() > 1 && EditingComboBox.this.getSelectedItem() instanceof Prompt) {
                        EditingComboBox.this.setEditable(true);
                        EditingComboBox.this.iPrompting = true;
                    } else {
                        EditingComboBox.this.setEditable(false);
                    }
                }
            };
            this.addItemListener(this.iItemListener);
            this.getEditor().getEditorComponent().addKeyListener(keyAdapter);
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    EditingComboBox.this.iCategoricalVariableEditor.fireEditingCanceled();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    if (EditingComboBox.this.getSelectedItem().equals(PROMPT)) {
                        return;
                    }
                    EditingComboBox.this.iCategoricalVariableEditor.fireEditingStopped();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
        }

        void reset() {
            this.setKeySelectionManager(this.createDefaultKeySelectionManager());
        }

        public void addItem(Object object) {
            if (object instanceof Prompt || !(this.getItemAt(this.getItemCount() - 1) instanceof Prompt)) {
                super.addItem(object);
            } else {
                this.insertItemAt(object, this.getItemCount() - 1);
            }
        }

        public void removeAllItems() {
            super.removeAllItems();
            this.addPrompt();
        }

        void setCategoricalVariableEditor(CategoricalVariableEditor categoricalVariableEditor) {
            this.iCategoricalVariableEditor = categoricalVariableEditor;
        }

        private void typeCharIntoNewItem(String string) {
            this.iPrompting = false;
            this.setEditable(true);
            this.getEditor().getEditorComponent().setForeground(Color.black);
            ((JTextComponent)this.getEditor().getEditorComponent()).setText(string);
        }

        void removePromptingListener() {
            this.removeItemListener(this.iItemListener);
        }

        void addPromptingListener() {
            this.removeItemListener(this.iItemListener);
            this.addItemListener(this.iItemListener);
        }

        private void selectNewItemRow(char c) {
            int n = ((DefaultComboBoxModel)this.getModel()).getIndexOf(PROMPT);
            if (n > 0) {
                this.setSelectedIndex(n);
                this.typeCharIntoNewItem(Character.toString(c));
            }
        }

        private void addPrompt() {
            int n;
            if (!this.isProtected && (n = ((DefaultComboBoxModel)this.getModel()).getIndexOf(PROMPT)) < 0) {
                this.addItem(PROMPT);
            }
        }

        public void setProtected(boolean bl) {
            this.isProtected = bl;
            if (bl) {
                this.removeItem(PROMPT);
                this.setEditable(false);
            } else {
                this.addPrompt();
            }
        }

        private static class LightWeightComboBoxEditor
        extends BasicComboBoxEditor {
            private LightWeightComboBoxEditor() {
            }

            @Override
            public void setItem(Object object) {
                super.setItem(object);
                if (object instanceof Prompt) {
                    this.getEditorComponent().setForeground(Color.lightGray);
                    ((JTextComponent)this.getEditorComponent()).moveCaretPosition(0);
                    ((JTextComponent)this.getEditorComponent()).setCaretPosition(0);
                } else {
                    this.getEditorComponent().setForeground(Color.black);
                }
            }
        }

        private static class LightWeightComboBoxRenderer
        extends BasicComboBoxRenderer {
            private LightWeightComboBoxRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof Prompt) {
                    component.setForeground(Color.lightGray);
                } else {
                    component.setForeground(Color.black);
                }
                return component;
            }
        }
    }
}

