/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExtractVariableAction
extends ArrayUtils.ExtractAction
implements ListSelectionListener {
    private final INewVariableProvider.CreationParams fCreationType;
    protected final VariableCreatorInterface fVarCreator;
    private final VariableIdentifierProvider fIdentifierProvider;
    private final AbstractSpreadsheetTable fTable;
    private static final int MAX_VAR_NAME_LENGTH = 63;
    private static final int MAX_OPEN_VARS = 5;
    private TSSplitButton fSplitButton = null;

    public ExtractVariableAction(final VariableIdentifierProvider variableIdentifierProvider, String string, INewVariableProvider.CreationParams creationParams, AbstractSpreadsheetTable abstractSpreadsheetTable, VariableCreatorInterface variableCreatorInterface) {
        super(new ArrayUtils.CreateVariableActionProvider(){

            @Override
            public VariableIdentifier getVariableIdentifier() {
                return variableIdentifierProvider.getVariableIdentifier();
            }

            @Override
            public void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction) {
            }
        });
        this.setName(string);
        this.fCreationType = creationParams;
        this.fIdentifierProvider = variableIdentifierProvider;
        this.fTable = abstractSpreadsheetTable;
        this.fVarCreator = variableCreatorInterface;
        this.updateEnabled(variableIdentifierProvider);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.updateEnabled(this.fIdentifierProvider);
        }
    }

    public void addVariableIdentifierListener() {
        this.removeVariableIdentifierListener();
        this.fIdentifierProvider.addVariableIdentifierListener((ListSelectionListener)this);
    }

    public void removeVariableIdentifierListener() {
        this.fIdentifierProvider.removeVariableIdentifierListener((ListSelectionListener)this);
    }

    private void updateEnabled(VariableIdentifierProvider variableIdentifierProvider) {
        VariableIdentifier variableIdentifier = variableIdentifierProvider.getVariableIdentifier();
        String string = variableIdentifier.getVariable();
        if (string == null) {
            string = variableIdentifier.getExpression();
        }
        this.setEnabled(string != null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        VariableIdentifier variableIdentifier = this.fIdentifierProvider.getVariableIdentifier();
        if (variableIdentifier != null) {
            String string;
            if (actionEvent.getSource() instanceof TSSplitButton) {
                this.fSplitButton = (TSSplitButton)actionEvent.getSource();
                this.fSplitButton.setEnabled(false);
            }
            String string2 = (string = ExtractVariableAction.getCurrentVariableName(variableIdentifier)) != null && string.indexOf(123) > 0 ? string.substring(0, string.indexOf(123)) : string;
            boolean bl = false;
            if (string2 != null) {
                int[] nArray = this.fTable.restrictRowColumnSpecToValidRegion(this.fTable.getSelectedRows(), 0);
                int[] nArray2 = this.fTable.restrictRowColumnSpecToValidRegion(this.fTable.getSelectedColumns(), 1);
                if (nArray.length > 0 && nArray2.length > 0) {
                    List list = SpreadsheetUtils.getSelectionIntervals((int[])nArray);
                    List list2 = SpreadsheetUtils.getSelectionIntervals((int[])nArray2);
                    this.createVariables(string2, string, list, list2);
                    bl = true;
                }
            }
            if (!bl) {
                this.enableSplitButton();
            }
        }
    }

    private static String getCurrentVariableName(VariableIdentifier variableIdentifier) {
        if (variableIdentifier == null) {
            return null;
        }
        String string = variableIdentifier.getVariable();
        if (string == null) {
            string = variableIdentifier.getExpression();
        }
        String string2 = null;
        if (string != null) {
            string2 = string.indexOf(40) > 0 ? string.substring(0, string.lastIndexOf(40)) : string;
        }
        return string2;
    }

    protected void createVariables(final String string, final String string2, final List<int[]> list, final List<int[]> list2) {
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(){

            public Object runOnMatlabThread() throws Exception {
                ExtractVariableAction.this.createVariablesOnMatlabThread(string, string2, list, list2);
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                ExtractVariableAction.this.enableSplitButton();
            }
        };
        matlabWorker.start();
    }

    private void enableSplitButton() {
        if (this.fSplitButton != null) {
            this.fSplitButton.setEnabled(true);
        }
    }

    protected void createVariablesOnMatlabThread(String string, String string2, List<int[]> list, List<int[]> list2) {
        Vector<String> vector = new Vector<String>();
        String string3 = ExtractVariableAction.getFieldName(string);
        boolean bl = true;
        if (this.fCreationType == INewVariableProvider.CreationParams.COLUMNS) {
            String string4 = ExtractVariableAction.getRange(list);
            int n = 0;
            for (int[] nArray : list2) {
                for (int i = nArray[0]; i <= nArray[1]; ++i) {
                    String string5 = string3 + ExtractVariableAction.getUniqueVarNameSuffix(string3, vector);
                    if (string5.length() > 63) {
                        string5 = "unnamed" + ExtractVariableAction.getUniqueVarNameSuffix("unnamed", vector);
                    }
                    this.fVarCreator.createVariable(string5 + " = " + string2 + "(" + string4 + "," + (i + 1) + ");" + ExtractVariableAction.getOpenVarStr(bl, string5));
                    vector.add(string5);
                    if (++n != 5) continue;
                    bl = false;
                }
            }
        } else if (this.fCreationType == INewVariableProvider.CreationParams.ROWS) {
            String string6 = ExtractVariableAction.getRange(list2);
            int n = 0;
            for (int[] nArray : list) {
                for (int i = nArray[0]; i <= nArray[1]; ++i) {
                    String string7 = string3 + ExtractVariableAction.getUniqueVarNameSuffix(string3, vector);
                    if (string7.length() > 63) {
                        string7 = "unnamed" + ExtractVariableAction.getUniqueVarNameSuffix("unnamed", vector);
                    }
                    this.fVarCreator.createVariable(string7 + " = " + string2 + "(" + (i + 1) + "," + string6 + ");" + ExtractVariableAction.getOpenVarStr(bl, string7));
                    vector.add(string7);
                    if (++n != 5) continue;
                    bl = false;
                }
            }
        } else if (this.fCreationType == INewVariableProvider.CreationParams.ALL) {
            String string8 = string3 + ExtractVariableAction.getUniqueVarNameSuffix(string3, vector);
            if (string8.length() > 63) {
                string8 = "unnamed" + ExtractVariableAction.getUniqueVarNameSuffix("unnamed", vector);
            }
            this.fVarCreator.createVariable(string8 + " = " + string2 + "(" + ExtractVariableAction.getRange(list) + "," + ExtractVariableAction.getRange(list2) + ");openvar " + string8);
        }
    }

    private static String getOpenVarStr(boolean bl, String string) {
        return bl ? "openvar " + string : "";
    }

    public static String getFieldName(String string) {
        if (string != null && string.indexOf(46) > 0) {
            return string.substring(string.lastIndexOf(46) + 1);
        }
        return string;
    }

    public static String getUniqueVarNameSuffix(String string, List<String> list) {
        String string2 = "";
        try {
            int n = 0;
            boolean bl = true;
            while (bl) {
                bl = false;
                String string3 = string + string2;
                if (string3.length() > 63) {
                    string2 = "-1";
                    break;
                }
                if (list.contains(string3)) {
                    bl = true;
                } else {
                    double[] dArray;
                    Object object = Matlab.mtEval((String)("exist('" + string3 + "','var')"), (int)1);
                    if (object instanceof double[] && (dArray = (double[])object).length == 1 && dArray[0] > 0.9 && dArray[0] < 1.1) {
                        bl = true;
                    }
                }
                if (!bl) continue;
                string2 = Integer.toString(++n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private static String getRange(List<int[]> list) {
        Object object;
        if (list.size() == 1 && (object = list.get(0))[0] == object[1]) {
            return Integer.toString((int)(object[0] + true));
        }
        object = new StringBuilder("[");
        for (int[] nArray : list) {
            ((StringBuilder)object).append(nArray[0] + 1);
            ((StringBuilder)object).append(":");
            ((StringBuilder)object).append(nArray[1] + 1);
            ((StringBuilder)object).append(",");
        }
        ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
        ((StringBuilder)object).append("]");
        return ((StringBuilder)object).toString();
    }

    public static interface VariableCreatorInterface {
        public void createVariable(String var1);
    }
}

