/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.array.ArrayDialog;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.InvertableRunnable;
import com.mathworks.mlwidgets.array.UndoableEditFromRunnables;
import com.mathworks.mlwidgets.array.UndoerCompletionObserver;
import com.mathworks.mlwidgets.array.ValueUpdateRegistry;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import org.jetbrains.annotations.Nullable;

public class MatlabEvalDoer
implements InvertableRunnable {
    private final String iVarName;
    private String iCode;
    private final WorkspaceUndoManager.UndoKey iKey;
    private final WorkspaceUndoManager iUndoManager;
    private boolean iViaMatlab = false;
    private boolean iViaCommandLine = true;
    private int iNumOutputArgs = 2;
    private Runnable fRunnable = null;

    public MatlabEvalDoer(String string, String string2, boolean bl, boolean bl2, WorkspaceUndoManager workspaceUndoManager, WorkspaceUndoManager.UndoKey undoKey) {
        this(string, string2, bl, bl2, workspaceUndoManager, undoKey, 2);
    }

    public MatlabEvalDoer(String string, String string2, boolean bl, boolean bl2, WorkspaceUndoManager workspaceUndoManager, WorkspaceUndoManager.UndoKey undoKey, int n) {
        this.iVarName = string;
        this.iCode = string2;
        this.iKey = undoKey;
        this.iUndoManager = workspaceUndoManager;
        this.iViaMatlab = bl;
        this.iViaCommandLine = bl2;
        this.iNumOutputArgs = n;
    }

    @Override
    public void run() {
        if (this.iUndoManager != null) {
            this.iUndoManager.receiveNextUndoableEdit();
        }
        MatlabWorker<Object[]> matlabWorker = this.createWorker();
        matlabWorker.start();
    }

    private MatlabWorker<Object[]> createWorker() {
        return new MatlabEvalWorker();
    }

    @Override
    public InvertableRunnable getInverse() {
        return new MatlabEvalUndoer(this.iVarName, this.iCode, this.iViaMatlab, this.iViaCommandLine, this.iUndoManager, this.iKey);
    }

    public static void evalDoerInMatlab(boolean bl, String string, @Nullable WorkspaceUndoManager.UndoKey undoKey, String string2, int n) throws Exception {
        if (undoKey != null && string2 != null) {
            Matlab.mtEvalNoBreakpoints((String)WorkspaceUndoManager.UndoKey.getStorageString(undoKey, string2), (int)1);
        }
        if (!bl || !ArrayUtils.isCodeGenEnabled()) {
            Matlab.mtFevalNoBreakpoints((String)"eval", (Object[])new Object[]{string}, (int)0);
        } else if (Matlab.isMatlabAvailable()) {
            MLExecuteServices.executeCommand((String)string);
        }
    }

    public static Object[] evalDoerInMatlabFromCodeGenMethod(String string, @Nullable WorkspaceUndoManager.UndoKey undoKey, String string2, final int n) throws Exception {
        Object object;
        if (undoKey != null && string2 != null) {
            Matlab.mtEvalNoBreakpoints((String)WorkspaceUndoManager.UndoKey.getStorageString(undoKey, string2), (int)1);
        }
        if ((object = Matlab.mtFevalNoBreakpoints((String)"eval", (Object[])new Object[]{string}, (int)n)) instanceof Object[]) {
            final Object[] objectArray = (Object[])object;
            Object[] objectArray2 = Arrays.copyOf(objectArray, n - 1);
            if (objectArray.length >= n && objectArray[n - 1] != null && objectArray[n - 1] instanceof String && ((CharSequence)objectArray[n - 1]).length() > 0) {
                MJUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MJOptionPane.showMessageDialog(null, (Object)objectArray[n - 1], (String)ArrayUtils.getResource("alert.Title"), (int)2);
                    }
                });
            }
            if (!ArrayUtils.isCodeGenEnabled() && objectArray2.length >= 1 && objectArray2[0] != null && objectArray2[0] instanceof String) {
                for (int i = 0; i < objectArray2.length; ++i) {
                    if (objectArray2[i] == null || !(objectArray2[i] instanceof String) || ((String)objectArray2[i]).isEmpty()) continue;
                    Matlab.mtFevalNoBreakpoints((String)"eval", (Object[])new Object[]{objectArray2[i]}, (int)0);
                }
                return null;
            }
            return objectArray2;
        }
        return null;
    }

    public void setRunnableToExecuteAtEnd(Runnable runnable) {
        this.fRunnable = runnable;
    }

    private static class MatlabEvalUndoer
    implements InvertableRunnable {
        private final String iVarName;
        private final String iCode;
        private final WorkspaceUndoManager.UndoKey iKey;
        private final WorkspaceUndoManager iUndoManager;
        private boolean iViaMatlab = false;
        private boolean iViaCommandLine = true;

        MatlabEvalUndoer(String string, String string2, boolean bl, boolean bl2, WorkspaceUndoManager workspaceUndoManager, WorkspaceUndoManager.UndoKey undoKey) {
            this.iVarName = string;
            this.iCode = string2;
            this.iKey = undoKey;
            this.iUndoManager = workspaceUndoManager;
            this.iViaMatlab = bl;
            this.iViaCommandLine = bl2;
        }

        @Override
        public void run() {
            if (this.iUndoManager != null) {
                this.iUndoManager.receiveNextUndoableEdit();
            }
            WorkspaceMCRProvider.getMCRForUserActions().eval(WorkspaceUndoManager.UndoKey.getRetrieveAndClearValueString(this.iKey, this.iVarName), (CompletionObserver)new UndoerCompletionObserver(this.iUndoManager));
        }

        @Override
        public InvertableRunnable getInverse() {
            return new MatlabEvalDoer(this.iVarName, this.iCode, this.iViaMatlab, this.iViaCommandLine, this.iUndoManager, this.iKey);
        }
    }

    private class MatlabEvalWorker
    extends MatlabWorker<Object[]> {
        private MatlabEvalWorker() {
        }

        public Object[] runOnMatlabThread() {
            try {
                if (MatlabEvalDoer.this.iViaMatlab) {
                    return MatlabEvalDoer.evalDoerInMatlabFromCodeGenMethod(MatlabEvalDoer.this.iCode, MatlabEvalDoer.this.iKey, MatlabEvalDoer.this.iVarName, MatlabEvalDoer.this.iNumOutputArgs);
                }
                MatlabEvalDoer.evalDoerInMatlab(MatlabEvalDoer.this.iViaCommandLine, MatlabEvalDoer.this.iCode, MatlabEvalDoer.this.iKey, MatlabEvalDoer.this.iVarName, MatlabEvalDoer.this.iNumOutputArgs);
                return null;
            }
            catch (Exception exception) {
                if (MatlabEvalDoer.this.iUndoManager != null) {
                    MatlabEvalDoer.this.iUndoManager.doNotReceiveUndoableEdits();
                }
                if ("DebugQuitException".equals(exception.getMessage())) {
                    ArrayDialog.showErrorDialog(ArrayUtils.getResource("status.EvalErr"));
                } else {
                    ArrayDialog.showErrorDialog(exception.getMessage());
                }
                ValueUpdateRegistry.refreshClients();
                return null;
            }
        }

        public void runOnAWTEventDispatchThread(Object[] objectArray) {
            String string;
            if (objectArray == null) {
                this.fireWorkspaceEvent();
                return;
            }
            if (objectArray.length >= 1 && objectArray[0] != null && objectArray[0] instanceof String && !(string = (String)objectArray[0]).isEmpty()) {
                MLExecuteServices.executeCommand((String)string);
                if (objectArray.length > 1) {
                    for (int i = 1; i < objectArray.length; ++i) {
                        String string2 = (String)objectArray[i];
                        if (string2.isEmpty()) continue;
                        WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput(string2);
                    }
                }
            }
            this.fireWorkspaceEvent();
        }

        private void fireWorkspaceEvent() {
            if (MatlabEvalDoer.this.fRunnable != null) {
                SwingUtilities.invokeLater(MatlabEvalDoer.this.fRunnable);
            }
            if (Matlab.isMatlabAvailable()) {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                ValueUpdateRegistry.refreshClients();
                                UndoableEditFromRunnables undoableEditFromRunnables = new UndoableEditFromRunnables(MatlabEvalDoer.this.getInverse());
                                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, undoableEditFromRunnables);
                                if (MatlabEvalDoer.this.iUndoManager != null) {
                                    MatlabEvalDoer.this.iUndoManager.undoableEditHappened(undoableEditEvent);
                                }
                            }
                            catch (Exception exception) {
                                if (MatlabEvalDoer.this.iUndoManager == null) break block3;
                                MatlabEvalDoer.this.iUndoManager.doNotReceiveUndoableEdits();
                            }
                        }
                    }
                });
            }
        }
    }
}

