/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.AbstractMatlabObjectTable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.MatlabObjArrayTableModel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.widgets.action.AbstractCopyAction;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class ObjArrayTable
extends AbstractMatlabObjectTable {
    private CopyAction fArrayCopyAction;

    public ObjArrayTable(MatlabObjArrayTableModel matlabObjArrayTableModel) {
        super(matlabObjArrayTableModel);
        this.setName("ObjArrayTable");
        ObjArrayTable.addTranspose(matlabObjArrayTableModel, this.fSelectionPopupMenu);
    }

    private static void addTranspose(final MatlabObjArrayTableModel matlabObjArrayTableModel, MJPopupMenu mJPopupMenu) {
        MJMenuItem mJMenuItem = new MJMenuItem(ArrayUtils.getResource("transpose.Title"));
        mJMenuItem.setName("Transpose");
        mJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                matlabObjArrayTableModel.transpose();
            }
        });
        mJPopupMenu.add((Component)new JSeparator());
        mJPopupMenu.add((JMenuItem)mJMenuItem);
    }

    protected void addClearContentsItem() {
    }

    @Override
    public void setEditable(boolean bl) {
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public Action getCopyAction() {
        if (this.fArrayCopyAction == null) {
            this.fArrayCopyAction = new CopyAction();
        }
        return this.fArrayCopyAction;
    }

    VariableIdentifier getVariableIdentifier() {
        String string = this.getSelectionNameString();
        return new VariableIdentifier(string, string, this.getVariable().getWorkspaceID());
    }

    private String getSelectionNameString() {
        String string = null;
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        int[] nArray2 = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
        if (nArray.length > 0 && nArray2.length > 0) {
            String string2 = nArray2.length == 1 ? Integer.toString(nArray2[0] + 1) : nArray2[0] + 1 + ":" + (nArray2[nArray2.length - 1] + 1);
            String string3 = nArray.length == 1 ? Integer.toString(nArray[0] + 1) : nArray[0] + 1 + ":" + (nArray[nArray.length - 1] + 1);
            string = this.getVariableName() + '(' + string3 + ", " + string2 + ')';
        }
        return string;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 127) {
            super.processKeyEvent(keyEvent);
        }
    }

    private class CopyAction
    extends AbstractCopyAction {
        CopyAction() {
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ObjArrayTable.this.populateClipboardFromIdentifier(ObjArrayTable.this.getVariableIdentifier());
        }
    }
}

